/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.overlay;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.Mergeable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.overlay.Overlay;
import com.alee.extended.overlay.WebOverlay;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

@XStreamAlias(value="OverlayLayout")
public class OverlayLayout
extends AbstractLayoutManager
implements SwingConstants,
Mergeable,
Cloneable,
Serializable {
    @Override
    public void layoutContainer(@NotNull Container parent) {
        WebOverlay container = (WebOverlay)parent;
        Insets overlayPadding = container.getInsets();
        Insets contentPadding = SwingUtils.increase(overlayPadding, this.getOverlaysPadding(container));
        Rectangle contentBounds = new Rectangle(contentPadding.left, contentPadding.top, container.getWidth() - contentPadding.left - contentPadding.right, container.getHeight() - contentPadding.top - contentPadding.bottom);
        JComponent content = container.getContent();
        if (content != null) {
            container.setComponentZOrder(content, container.getComponentCount() - 1);
            content.setBounds(contentBounds);
        }
        for (Overlay overlay : container.getOverlays()) {
            Insets padding = overlay.margin();
            overlay.component().setBounds(overlay.bounds(container, content, new Rectangle(contentBounds.x - padding.left, contentBounds.y - padding.top, contentBounds.width + padding.left + padding.right, contentBounds.height + padding.top + padding.bottom)));
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Dimension ps = new Dimension(0, 0);
        WebOverlay container = (WebOverlay)parent;
        JComponent content = container.getContent();
        if (content != null) {
            Dimension cps = content.getPreferredSize();
            ps = SwingUtils.maxNonNull(ps, cps);
        }
        ps = SwingUtils.increase(ps, this.getOverlaysPadding(container));
        SwingUtils.increase(ps, container.getInsets());
        return ps;
    }

    @NotNull
    protected Insets getOverlaysPadding(@NotNull WebOverlay container) {
        Insets maxMargin = new Insets(0, 0, 0, 0);
        for (Overlay overlay : container.getOverlays()) {
            maxMargin = SwingUtils.maxNonNull(maxMargin, overlay.margin());
        }
        return maxMargin;
    }

    @XStreamAlias(value="OverlayLayout$UIResource")
    public static final class UIResource
    extends OverlayLayout
    implements javax.swing.plaf.UIResource {
    }
}

