/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.ComponentPanelLayout;
import com.alee.extended.panel.WebComponentPane;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class WebSelectablePanel
extends WebPanel {
    private final WebComponentPane componentPane;
    private final DefaultFocusTracker focusTracker;
    private boolean dragged = false;
    private boolean focused = false;

    public WebSelectablePanel(final WebComponentPane componentPane) {
        super(StyleId.componentpanePanel.at(componentPane));
        this.componentPane = componentPane;
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private int startY;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtils.hasFocusOwner(WebSelectablePanel.this)) {
                    WebSelectablePanel.this.transferFocus();
                }
                if (WebSelectablePanel.this.getComponentPane().isEnabled() && componentPane.isReorderingAllowed() && SwingUtilities.isLeftMouseButton(e)) {
                    WebSelectablePanel.this.dragged = true;
                    this.startY = this.getY();
                    WebSelectablePanel.this.getComponentPane().getContainer().setComponentZOrder(WebSelectablePanel.this, 0);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (componentPane.isReorderingAllowed() && WebSelectablePanel.this.dragged) {
                    WebSelectablePanel.this.getComponentPane().getContainerLayout().setComponentShift(WebSelectablePanel.this, this.getY() - this.startY);
                    WebSelectablePanel.this.revalidate();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WebSelectablePanel wsp = WebSelectablePanel.this;
                ComponentPanelLayout cpl = WebSelectablePanel.this.getComponentPane().getContainerLayout();
                if (componentPane.isReorderingAllowed() && SwingUtilities.isLeftMouseButton(e) && WebSelectablePanel.this.dragged) {
                    WebSelectablePanel.this.dragged = false;
                    if (this.getY() - this.startY == 0 || cpl.getComponents().size() <= 1) {
                        cpl.setComponentShift(wsp, null);
                    } else {
                        int oldIndex = cpl.indexOf(wsp);
                        int middle = this.getMiddleY(wsp);
                        int insertIndex = 0;
                        for (Component component2 : cpl.getComponents()) {
                            if (component2 == wsp || middle <= this.getMiddleY(component2)) continue;
                            insertIndex = cpl.indexOf(component2) + 1;
                        }
                        if (insertIndex > oldIndex) {
                            --insertIndex;
                        }
                        cpl.setComponentShift(wsp, null);
                        if (oldIndex != insertIndex) {
                            cpl.removeLayoutComponent(wsp);
                            cpl.insertLayoutComponent(insertIndex, wsp);
                            WebSelectablePanel.this.getComponentPane().fireComponentOrderChanged(wsp.getComponent(), oldIndex, insertIndex);
                        }
                    }
                    wsp.revalidate();
                }
            }

            private int getMiddleY(Component component2) {
                Rectangle rectangle = component2.getBounds();
                return rectangle.y + rectangle.height / 2;
            }

            private int getY() {
                return CoreSwingUtils.getMouseLocation().y;
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.focusTracker = new DefaultFocusTracker(this, true){

            @Override
            public void focusChanged(boolean focused) {
                WebSelectablePanel wsp = WebSelectablePanel.this;
                wsp.focused = focused;
                if (!focused && WebSelectablePanel.this.dragged) {
                    WebSelectablePanel.this.dragged = false;
                    WebSelectablePanel.this.getComponentPane().getContainerLayout().setComponentShift(wsp, null);
                    wsp.revalidate();
                }
                WebSelectablePanel.this.repaint();
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public Component getComponent() {
        return this.getComponent(0);
    }

    public int getIndex() {
        WebComponentPane pane = this.getComponentPane();
        return pane != null ? pane.getContainerLayout().indexOf(this) : -1;
    }

    public int getTotal() {
        WebComponentPane pane = this.getComponentPane();
        return pane != null ? pane.getContainer().getComponentCount() : 0;
    }

    public WebComponentPane getComponentPane() {
        return this.componentPane;
    }
}

