/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.utils.TextUtils;
import java.io.Serializable;
import java.util.List;

public class MultiSplitConstraints
implements Cloneable,
Serializable {
    public static final double FILL = -1.0;
    public static final double PREFERRED = -2.0;
    public static final double MINIMUM = -3.0;
    protected final double size;
    protected final double weight;

    public MultiSplitConstraints() {
        this(null, null);
    }

    public MultiSplitConstraints(Number size) {
        this(size.doubleValue(), null);
    }

    public MultiSplitConstraints(Double size, Double weight) {
        this.size = this.validSize(size);
        this.weight = this.validWeight(weight);
    }

    public MultiSplitConstraints(String constraints) {
        try {
            Double weight;
            Double size;
            List<String> values2 = TextUtils.stringToList(constraints, ",");
            if (values2.size() == 1) {
                size = Double.parseDouble(values2.get(0));
                weight = null;
            } else if (values2.size() == 2) {
                size = Double.parseDouble(values2.get(0));
                weight = Double.parseDouble(values2.get(1));
            } else {
                String msg = "Unknown layout constraints: %s";
                throw new IllegalArgumentException(String.format("Unknown layout constraints: %s", constraints));
            }
            this.size = this.validSize(size);
            this.weight = this.validWeight(weight);
        }
        catch (Exception e) {
            String msg = "Unable to parse layout constraints: %s";
            throw new IllegalArgumentException(String.format("Unable to parse layout constraints: %s", constraints));
        }
    }

    protected double validSize(Double size) {
        if (size != null && size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            throw new IllegalArgumentException("Unknown size value: " + this.size());
        }
        return size != null ? size : 1.0;
    }

    protected double validWeight(Double weight) {
        double defaultWeight;
        if (weight != null) {
            if (weight < 0.0) {
                throw new IllegalArgumentException("Weight cannot be less than zero: " + weight);
            }
            defaultWeight = weight;
        } else {
            defaultWeight = this.isPercents() ? this.percents() : (this.isFill() ? 1.0 : 0.0);
        }
        return defaultWeight;
    }

    public double size() {
        return this.size;
    }

    public boolean isPixels() {
        return this.size > 1.0;
    }

    public int pixels() {
        if (this.isPixels()) {
            return (int)this.size;
        }
        throw new IllegalArgumentException("View size is not pixel");
    }

    public boolean isPercents() {
        return 0.0 <= this.size && this.size <= 1.0;
    }

    public double percents() {
        if (this.isPercents()) {
            return this.size;
        }
        throw new IllegalArgumentException("View size is not percents");
    }

    public boolean isFill() {
        return this.size == -1.0;
    }

    public boolean isPreferred() {
        return this.size == -2.0;
    }

    public boolean isMinimum() {
        return this.size == -3.0;
    }

    public double weight() {
        return this.weight;
    }

    public boolean hasWeight() {
        return this.weight > 0.0;
    }
}

