/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.extended.split.MultiSplitExpansionAdapter;
import com.alee.extended.split.MultiSplitResizeAdapter;
import com.alee.extended.split.MultiSplitState;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.extended.split.WebMultiSplitPaneDivider;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.awt.Component;

public class MultiSplitPaneSettingsProcessor
extends SettingsProcessor<WebMultiSplitPane, MultiSplitState, Configuration<MultiSplitState>> {
    protected transient MultiSplitResizeAdapter multiSplitResizeListener;
    protected transient MultiSplitExpansionAdapter multiSplitExpansionListener;

    public MultiSplitPaneSettingsProcessor(WebMultiSplitPane multiSplitPane, Configuration configuration) {
        super(multiSplitPane, configuration);
    }

    @Override
    protected void register(@NotNull WebMultiSplitPane multiSplitPane) {
        this.multiSplitResizeListener = new MultiSplitResizeAdapter(){

            @Override
            public void viewResizeEnded(@NotNull WebMultiSplitPane multiSplitPane, @NotNull WebMultiSplitPaneDivider divider) {
                MultiSplitPaneSettingsProcessor.this.save();
            }

            @Override
            public void viewSizeAdjusted(@NotNull WebMultiSplitPane multiSplitPane) {
                MultiSplitPaneSettingsProcessor.this.save();
            }
        };
        multiSplitPane.addResizeListener(this.multiSplitResizeListener);
        this.multiSplitExpansionListener = new MultiSplitExpansionAdapter(){

            @Override
            public void viewExpanded(@NotNull WebMultiSplitPane multiSplitPane, @NotNull Component view) {
                MultiSplitPaneSettingsProcessor.this.save();
            }

            @Override
            public void viewCollapsed(@NotNull WebMultiSplitPane multiSplitPane, @NotNull Component view) {
                MultiSplitPaneSettingsProcessor.this.save();
            }
        };
        multiSplitPane.addExpansionListener(this.multiSplitExpansionListener);
    }

    @Override
    protected void unregister(@NotNull WebMultiSplitPane multiSplitPane) {
        multiSplitPane.removeExpansionListener(this.multiSplitExpansionListener);
        this.multiSplitExpansionListener = null;
        multiSplitPane.removeResizeListener(this.multiSplitResizeListener);
        this.multiSplitResizeListener = null;
    }

    @Override
    protected void loadSettings(@NotNull WebMultiSplitPane multiSplitPane) {
        MultiSplitState state = (MultiSplitState)this.loadSettings();
        if (state != null) {
            multiSplitPane.setMultiSplitState(state);
        }
    }

    @Override
    protected void saveSettings(@NotNull WebMultiSplitPane multiSplitPane) {
        MultiSplitState state = multiSplitPane.getMultiSplitState();
        if (state != null) {
            this.saveSettings(state);
        }
    }
}

