/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.svg;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.api.resource.Resource;
import com.alee.api.ui.DisabledCopySupplier;
import com.alee.api.ui.TransparentCopySupplier;
import com.alee.extended.svg.SvgGrayscale;
import com.alee.extended.svg.SvgOpacity;
import com.alee.extended.svg.SvgSelector;
import com.alee.managers.icon.data.IconAdjustment;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class SvgIcon
extends SVGIcon
implements DisabledCopySupplier<SvgIcon>,
TransparentCopySupplier<SvgIcon>,
Cloneable {
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient BufferedImage cache;

    public SvgIcon(@NotNull Resource resource) {
        this(resource, 16, 16);
    }

    public SvgIcon(@NotNull Resource resource, int width, int height) {
        try {
            SVGUniverse universe = new SVGUniverse();
            URI uri = universe.loadSVG(resource.getInputStream(), "SvgIcon", true);
            this.checkDiagram(universe, uri);
            this.setSvgUniverse(universe);
            this.setSvgURI(uri);
            this.setAntiAlias(true);
            this.setAutosize(4);
            this.setPreferredSize(width, height);
        }
        catch (Exception e) {
            String msg = "Unable to load SVG from resource: %s";
            throw new RuntimeException(String.format("Unable to load SVG from resource: %s", resource), e);
        }
    }

    protected void checkDiagram(@NotNull SVGUniverse universe, @NotNull URI uri) {
        if (universe.getDiagram(uri) == null) {
            String msg = "Unable to load SVG file: %s";
            throw new RuntimeException(String.format("Unable to load SVG file: %s", this.getSvgURI()));
        }
    }

    public void apply(IconAdjustment<SvgIcon> ... adjustments) {
        for (IconAdjustment<SvgIcon> adjustment : adjustments) {
            adjustment.apply(this);
        }
    }

    public void apply(@NotNull List<? extends IconAdjustment<SvgIcon>> adjustments) {
        for (IconAdjustment<SvgIcon> iconAdjustment : adjustments) {
            iconAdjustment.apply(this);
        }
    }

    @NotNull
    protected SVGDiagram getDiagram() {
        return this.getSvgUniverse().getDiagram(this.getSvgURI());
    }

    @NotNull
    public SVGRoot getRoot() {
        return this.getDiagram().getRoot();
    }

    @NotNull
    public List<SVGElement> find(@NotNull String selector) {
        return this.find(selector, (SVGElement)this.getRoot());
    }

    @NotNull
    public List<SVGElement> find(@NotNull SvgSelector selector) {
        return this.find(selector, (SVGElement)this.getRoot());
    }

    @NotNull
    public List<SVGElement> find(@NotNull String selector, @NotNull SVGElement element) {
        return this.find(selector, element, new ArrayList<SVGElement>(1));
    }

    @NotNull
    public List<SVGElement> find(@NotNull SvgSelector selector, @NotNull SVGElement element) {
        return this.find(selector, element, new ArrayList<SVGElement>(1));
    }

    @NotNull
    public List<SVGElement> find(@NotNull String selector, @NotNull SVGElement element, @NotNull List<SVGElement> result2) {
        return this.find(new SvgSelector(selector), element, result2);
    }

    @NotNull
    public List<SVGElement> find(@NotNull SvgSelector selector, @NotNull SVGElement element, @NotNull List<SVGElement> result2) {
        if (selector.isApplicable(this, element)) {
            result2.add(element);
        }
        for (int i = 0; i < element.getNumChildren(); ++i) {
            this.find(selector, element.getChild(i), result2);
        }
        return result2;
    }

    public boolean hasAttribute(@NotNull SVGElement element, @NotNull String attribute) {
        try {
            return element.hasAttribute(attribute, 1);
        }
        catch (SVGElementException e) {
            String msg = "Unable to check attribute %s existence for element: %s";
            throw new RuntimeException(String.format("Unable to check attribute %s existence for element: %s", attribute, element));
        }
    }

    @Nullable
    public StyleAttribute getAttribute(@NotNull SVGElement element, @NotNull String attribute) {
        return element.getPresAbsolute(attribute);
    }

    public void setAttribute(@NotNull SVGElement element, @NotNull String attribute, @Nullable String value) {
        try {
            if (this.hasAttribute(element, attribute)) {
                element.setAttribute(attribute, 1, value);
            } else {
                element.addAttribute(attribute, 1, value);
            }
            this.update(element);
        }
        catch (SVGElementException e) {
            String msg = "Unable to set SVG attribute %s with value %s for element: %s";
            throw new RuntimeException(String.format("Unable to set SVG attribute %s with value %s for element: %s", attribute, value, element));
        }
    }

    public void removeAttribute(@NotNull SVGElement element, @NotNull String attribute) {
        if (!attribute.equals("id")) {
            if (this.hasAttribute(element, attribute)) {
                element.getPresentationAttributes().remove(attribute);
            }
        } else {
            String msg = "SVG element identifier attribute cannot be removed: %s";
            throw new RuntimeException(String.format("SVG element identifier attribute cannot be removed: %s", element));
        }
        this.update(element);
    }

    protected void update(@NotNull SVGElement element) {
        try {
            element.updateTime(0.0);
            this.cache = null;
        }
        catch (SVGException e) {
            String msg = "Unable to update element: %s";
            throw new RuntimeException(String.format("Unable to update element: %s", element));
        }
    }

    @Override
    public void paintIcon(@NotNull Component component2, @NotNull Graphics g, int x, int y) {
        Dimension size = this.getPreferredSize();
        if (this.cache == null || this.cache.getWidth() != size.width || this.cache.getHeight() != size.height) {
            if (this.cache != null) {
                this.cache.flush();
            }
            this.cache = this.asBufferedImage(size);
        }
        g.drawImage(this.cache, x, y, null);
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @NotNull
    public BufferedImage asBufferedImage() {
        return this.asBufferedImage(this.getPreferredSize());
    }

    @NotNull
    public BufferedImage asBufferedImage(@NotNull Dimension size) {
        return this.asBufferedImage(size.width, size.height);
    }

    @NotNull
    public BufferedImage asBufferedImage(int width, int height) {
        Dimension ps = this.getPreferredSize();
        this.setPreferredSize(width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        super.paintIcon(null, (Graphics)g2d, 0, 0);
        g2d.dispose();
        this.setPreferredSize(ps);
        return image;
    }

    @Override
    @NotNull
    public SvgIcon createDisabledCopy() {
        SvgIcon svgIcon = this.clone();
        svgIcon.apply(new SvgGrayscale());
        svgIcon.apply(new SvgOpacity(0.7));
        return svgIcon;
    }

    @Override
    @NotNull
    public SvgIcon createTransparentCopy(float opacity) {
        SvgIcon svgIcon = this.clone();
        svgIcon.apply(new SvgOpacity(Double.valueOf(opacity)));
        return svgIcon;
    }

    @NotNull
    protected SvgIcon clone() {
        return Clone.reflective().nonNullClone(this);
    }
}

