/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.svg;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.extended.svg.SvgIcon;
import com.alee.extended.svg.SvgIconSourceConverter;
import com.alee.managers.icon.data.AbstractIconSource;
import com.alee.managers.icon.data.IconAdjustment;
import com.alee.utils.CollectionUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Dimension;
import java.util.List;

@XStreamAlias(value="SvgIcon")
@XStreamConverter(value=SvgIconSourceConverter.class)
public class SvgIconSource
extends AbstractIconSource<SvgIcon> {
    @XStreamAsAttribute
    @Nullable
    protected final Dimension size;

    public SvgIconSource(@NotNull String id, @NotNull Resource resource) {
        this(id, resource, null, (List<IconAdjustment<SvgIcon>>)null);
    }

    public SvgIconSource(@NotNull String id, @NotNull Resource resource, @Nullable Dimension size) {
        this(id, resource, size, (List<IconAdjustment<SvgIcon>>)null);
    }

    public SvgIconSource(@NotNull String id, @NotNull Resource resource, IconAdjustment<SvgIcon> ... adjustments) {
        this(id, resource, null, CollectionUtils.asList(adjustments));
    }

    public SvgIconSource(@NotNull String id, @NotNull Resource resource, @Nullable Dimension size, IconAdjustment<SvgIcon> ... adjustments) {
        this(id, resource, size, CollectionUtils.asList(adjustments));
    }

    public SvgIconSource(@NotNull String id, @NotNull Resource resource, @Nullable List<IconAdjustment<SvgIcon>> adjustments) {
        this(id, resource, null, adjustments);
    }

    public SvgIconSource(@NotNull String id, @NotNull Resource resource, @Nullable Dimension size, @Nullable List<IconAdjustment<SvgIcon>> adjustments) {
        super(id, resource, adjustments);
        this.size = size;
    }

    @Nullable
    public Dimension getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public SvgIcon loadIcon(@NotNull Resource resource) {
        int width = this.size != null ? this.size.width : 16;
        int height = this.size != null ? this.size.height : 16;
        return new SvgIcon(resource, width, height);
    }
}

