/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.api.merge.Mergeable;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.utils.general.Pair;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.List;

@XStreamAlias(value="DocumentPaneState")
public class DocumentPaneState
implements Mergeable,
Cloneable,
Serializable {
    @XStreamAsAttribute
    protected Boolean split;
    @XStreamAsAttribute
    protected String selectedId;
    @XStreamImplicit
    protected List<String> documentIds;
    @XStreamAsAttribute
    protected Integer splitOrientation;
    @XStreamAsAttribute
    protected Double dividerLocation;
    protected Pair<DocumentPaneState, DocumentPaneState> splitState;

    public DocumentPaneState() {
        this.split = false;
    }

    public DocumentPaneState(PaneData paneData) {
        this.split = false;
        Object selected = paneData.getSelected();
        this.selectedId = selected != null ? ((DocumentData)selected).getId() : null;
        this.documentIds = paneData.getDocumentIds();
    }

    public DocumentPaneState(SplitData splitData) {
        this.split = true;
        this.splitOrientation = splitData.getOrientation();
        this.dividerLocation = splitData.getDividerLocation();
        StructureData firstData = splitData.getFirst();
        DocumentPaneState firstState = firstData != null ? firstData.getDocumentPaneState() : null;
        StructureData lastData = splitData.getLast();
        DocumentPaneState lastState = lastData != null ? lastData.getDocumentPaneState() : null;
        this.splitState = new Pair<DocumentPaneState, DocumentPaneState>(firstState, lastState);
    }

    public Boolean isSplit() {
        return this.split != null && this.split != false;
    }

    public void setSplit(Boolean split) {
        this.split = split;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(String selectedId) {
        this.selectedId = selectedId;
    }

    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public void setDocumentIds(List<String> documentIds) {
        this.documentIds = documentIds;
    }

    public Integer getSplitOrientation() {
        return this.splitOrientation;
    }

    public void setSplitOrientation(Integer orientation) {
        this.splitOrientation = orientation;
    }

    public Double getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(Double location) {
        this.dividerLocation = location;
    }

    public Pair<DocumentPaneState, DocumentPaneState> getSplitState() {
        return this.splitState;
    }

    public void setSplitState(Pair<DocumentPaneState, DocumentPaneState> splitState) {
        this.splitState = splitState;
    }
}

