/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.PaneData;
import com.alee.laf.button.WebButton;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.tabbedpane.TabComponent;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.UIResource;

public class TabTitleComponent<T extends DocumentData>
extends WebPanel
implements TabComponent,
UIResource {
    @NotNull
    protected JComponent title;
    @Nullable
    protected AbstractButton closeButton;

    public TabTitleComponent(@NotNull PaneData<T> paneData, @NotNull T document, @NotNull MouseAdapter mouseAdapter) {
        super(StyleId.documentpaneTabPanel.at(paneData.getTabbedPane()), new BorderLayout(2, 0), new Component[0]);
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.title = this.createTitle(paneData, document, mouseAdapter);
        this.add((Component)this.title, (Object)"Center");
        if (paneData.getDocumentPane().isClosable() && ((DocumentData)document).isClosable()) {
            this.closeButton = this.createCloseButton(paneData, document);
            this.add((Component)this.closeButton, (Object)"After");
        }
    }

    @NotNull
    protected JComponent createTitle(@NotNull PaneData<T> paneData, @NotNull T document, @NotNull MouseAdapter mouseAdapter) {
        StyleId titleStyleId = StyleId.documentpaneTabTitle.at(this);
        WebStyledLabel titleLabel = new WebStyledLabel(titleStyleId, ((DocumentData)document).getTitle(), ((DocumentData)document).getIcon());
        if (((DocumentData)document).getForeground() != null) {
            titleLabel.setForeground(((DocumentData)document).getForeground());
        }
        titleLabel.addMouseListener(mouseAdapter);
        titleLabel.addMouseMotionListener(mouseAdapter);
        return titleLabel;
    }

    @NotNull
    protected AbstractButton createCloseButton(final @NotNull PaneData<T> paneData, @NotNull T document) {
        final WeakReference<T> weakDocument = new WeakReference<T>(document);
        StyleId closeButtonStyleId = StyleId.documentpaneTabCloseButton.at(this);
        WebButton closeButton = new WebButton(closeButtonStyleId, (Icon)Icons.crossSmall, (Icon)Icons.crossSmallHover);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                paneData.close((DocumentData)weakDocument.get());
            }
        });
        return closeButton;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.title instanceof JLabel ? ((JLabel)this.title).getIcon() : null;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title instanceof JLabel ? ((JLabel)this.title).getText() : null;
    }
}

