/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.AbstractAsyncTreeDataProvider;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.NodesLoadCallback;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.compare.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileTreeDataProvider
extends AbstractAsyncTreeDataProvider<FileTreeNode> {
    protected List<File> rootFiles;

    public FileTreeDataProvider(File ... rootFiles) {
        this(CollectionUtils.asList(rootFiles));
    }

    public FileTreeDataProvider(@NotNull List<File> rootFiles) {
        this.rootFiles = rootFiles;
    }

    @Override
    @NotNull
    public String getThreadGroupId() {
        return "FileSystem";
    }

    @Override
    @NotNull
    public FileTreeNode getRoot() {
        return this.rootFiles.size() == 1 ? new FileTreeNode(this.rootFiles.get(0)) : new FileTreeNode(null);
    }

    @Override
    public void loadChildren(@NotNull FileTreeNode parent, @NotNull NodesLoadCallback<FileTreeNode> listener) {
        try {
            listener.completed(parent.getFile() == null ? this.getRootChildren() : this.getFileChildren(parent));
        }
        catch (Exception cause) {
            listener.failed(cause);
        }
    }

    @NotNull
    protected List<FileTreeNode> getRootChildren() {
        ArrayList<FileTreeNode> children = new ArrayList<FileTreeNode>(this.rootFiles.size());
        for (File rootFile : this.rootFiles) {
            children.add(new FileTreeNode(rootFile));
        }
        return children;
    }

    @NotNull
    public List<FileTreeNode> getFileChildren(@NotNull FileTreeNode node) {
        ArrayList<FileTreeNode> children;
        File[] childrenArray;
        File file = node.getFile();
        File[] fileArray = childrenArray = file != null ? file.listFiles() : null;
        if (childrenArray == null || childrenArray.length == 0) {
            children = new ArrayList<FileTreeNode>(0);
        } else {
            children = new ArrayList(childrenArray.length);
            for (File f : childrenArray) {
                children.add(new FileTreeNode(f));
            }
        }
        return children;
    }

    @Override
    @Nullable
    public Filter<FileTreeNode> getChildrenFilter(@NotNull FileTreeNode parent, @NotNull List<FileTreeNode> children) {
        return parent.getFile() != null ? super.getChildrenFilter(parent, children) : null;
    }

    @Override
    public boolean isLeaf(@NotNull FileTreeNode node) {
        return node.getFile() != null && !FileUtils.isDirectory(node.getFile());
    }
}

