/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.ui.TextBridge;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.TreeNodeParameters;
import com.alee.utils.FileUtils;
import java.io.File;
import javax.swing.Icon;

public class FileTreeNode
extends AsyncUniqueNode<FileTreeNode, File>
implements TextBridge<TreeNodeParameters<FileTreeNode, WebAsyncTree<FileTreeNode>>> {
    public static final String rootId = "File.tree.root";
    @Nullable
    protected String title = null;

    public FileTreeNode(@Nullable File file) {
        super(file);
    }

    @Override
    @NotNull
    public String getId() {
        File file = (File)this.getUserObject();
        return file != null ? file.getAbsolutePath() : rootId;
    }

    @Nullable
    public File getFile() {
        return (File)this.getUserObject();
    }

    public void setFile(@Nullable File file) {
        this.setUserObject(file);
    }

    @Override
    @Nullable
    public Icon getNodeIcon(@NotNull TreeNodeParameters<FileTreeNode, WebAsyncTree<FileTreeNode>> parameters) {
        File file = (File)this.getUserObject();
        return file != null ? FileUtils.getFileIcon(file, false) : null;
    }

    @Override
    public String getText(@NotNull TreeNodeParameters<FileTreeNode, WebAsyncTree<FileTreeNode>> parameters) {
        return this.getTitle();
    }

    @NotNull
    public String getTitle() {
        String name;
        File file;
        String title = this.title != null ? this.title : ((file = (File)this.getUserObject()) != null ? ((name = FileUtils.getDisplayFileName(file)) != null && !name.trim().equals("") ? name : (!(name = file.getName()).trim().equals("") ? name : FileUtils.getFileDescription(file, null).getDescription())) : rootId);
        return title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public int indexOfFileChild(@Nullable File file) {
        int index = -1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!FileUtils.equals(((FileTreeNode)this.getChildAt(i)).getFile(), file)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getTitle();
    }
}

