/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Predicate;
import com.alee.extended.tree.CheckBoxTreeCellRenderer;
import com.alee.extended.tree.CheckStateChange;
import com.alee.extended.tree.CheckStateChangeListener;
import com.alee.extended.tree.DefaultTreeCheckingModel;
import com.alee.extended.tree.TreeCheckingModel;
import com.alee.extended.tree.WebCheckBoxTreeCellRenderer;
import com.alee.laf.checkbox.CheckState;
import com.alee.laf.tree.NodesAcceptPolicy;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import com.alee.utils.SwingUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebCheckBoxTree<N extends MutableTreeNode>
extends WebTree<N> {
    public static final String RECURSIVE_CHECKING_PROPERTY = "recursiveChecking";
    public static final String CHECK_BOX_RENDERER_GAP_PROPERTY = "checkBoxRendererGap";
    public static final String CHECK_BOX_VISIBLE_PROPERTY = "checkBoxVisible";
    public static final String CHECKING_ENABLED_PROPERTY = "checkingEnabled";
    public static final String CHECK_MIXED_ON_TOGGLE_PROPERTY = "checkMixedOnToggle";
    public static final String CHECKING_MODEL_PROPERTY = "checkingModel";
    public static final String CHECK_BOX_CELL_RENDERER_PROPERTY = "checkBoxCellRenderer";
    public static final String ENABLED_STATE_PROVIDER_PROPERTY = "enabledStateProvider";
    public static final String VISIBLE_STATE_PROVIDER_PROPERTY = "visibleStateProvider";
    @Nullable
    protected Boolean recursiveChecking;
    @Nullable
    protected Integer checkBoxRendererGap;
    @Nullable
    protected Boolean checkBoxVisible;
    @Nullable
    protected Boolean checkingEnabled;
    @Nullable
    protected Boolean checkMixedOnToggle;
    @Nullable
    protected TreeCheckingModel<N> checkingModel = this.createDefaultCheckingModel();
    @Nullable
    protected CheckBoxTreeCellRenderer checkBoxCellRenderer;
    @Nullable
    protected TreeCellRenderer actualCellRenderer;
    @Nullable
    protected Predicate<N> checkBoxEnabledStateProvider;
    @Nullable
    protected Predicate<N> checkBoxVisibleStateProvider;
    @NotNull
    protected Handler handler = new Handler();

    public WebCheckBoxTree() {
        this(StyleId.auto);
    }

    public WebCheckBoxTree(@NotNull Object[] data) {
        this(StyleId.auto, data);
    }

    public WebCheckBoxTree(@NotNull Vector<?> data) {
        this(StyleId.auto, data);
    }

    public WebCheckBoxTree(@NotNull Hashtable<?, ?> data) {
        this(StyleId.auto, data);
    }

    public WebCheckBoxTree(@Nullable N root) {
        this(StyleId.auto, root);
    }

    public WebCheckBoxTree(@Nullable N root, boolean asksAllowsChildren) {
        this(StyleId.auto, root, asksAllowsChildren);
    }

    public WebCheckBoxTree(@Nullable TreeModel newModel) {
        this(StyleId.auto, newModel);
    }

    public WebCheckBoxTree(@NotNull StyleId id) {
        this(id, WebCheckBoxTree.createDefaultTreeModel());
    }

    public WebCheckBoxTree(@NotNull StyleId id, @NotNull Object[] data) {
        this(id, WebCheckBoxTree.createTreeModel(data));
    }

    public WebCheckBoxTree(@NotNull StyleId id, @NotNull Vector<?> data) {
        this(id, WebCheckBoxTree.createTreeModel(data));
    }

    public WebCheckBoxTree(@NotNull StyleId id, @NotNull Hashtable<?, ?> data) {
        this(id, WebCheckBoxTree.createTreeModel(data));
    }

    public WebCheckBoxTree(@NotNull StyleId id, @Nullable N root) {
        this(id, new WebTreeModel<N>(root));
    }

    public WebCheckBoxTree(@NotNull StyleId id, @Nullable N root, boolean asksAllowsChildren) {
        this(id, new WebTreeModel<N>(root, asksAllowsChildren));
    }

    public WebCheckBoxTree(@NotNull StyleId id, @Nullable TreeModel newModel) {
        super(id, newModel);
        this.addMouseListener(this.handler);
        this.addKeyListener(this.handler);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.checkboxtree;
    }

    @Nullable
    public TreeCellRenderer getActualRenderer() {
        return this.actualCellRenderer;
    }

    @Override
    public void setCellRenderer(@Nullable TreeCellRenderer renderer) {
        this.actualCellRenderer = renderer;
        if (this.checkBoxCellRenderer == null) {
            this.checkBoxCellRenderer = this.createCheckBoxTreeCellRenderer();
        }
        super.setCellRenderer(this.checkBoxCellRenderer);
    }

    @Nullable
    public CheckBoxTreeCellRenderer getCheckBoxCellRenderer() {
        return this.checkBoxCellRenderer;
    }

    public void setCheckBoxTreeCellRenderer(@Nullable CheckBoxTreeCellRenderer renderer) {
        CheckBoxTreeCellRenderer old = this.checkBoxCellRenderer;
        this.checkBoxCellRenderer = renderer;
        super.setCellRenderer(this.checkBoxCellRenderer);
        this.firePropertyChange(CHECK_BOX_CELL_RENDERER_PROPERTY, old, renderer);
    }

    @NotNull
    protected WebCheckBoxTreeCellRenderer createCheckBoxTreeCellRenderer() {
        return new WebCheckBoxTreeCellRenderer.UIResource();
    }

    public int getCheckBoxRendererGap() {
        return this.checkBoxRendererGap != null ? this.checkBoxRendererGap : 0;
    }

    public void setCheckBoxRendererGap(int gap) {
        Integer old = this.checkBoxRendererGap;
        this.checkBoxRendererGap = gap;
        this.firePropertyChange(CHECK_BOX_RENDERER_GAP_PROPERTY, old, (Object)gap);
    }

    public CheckState getCheckState(@NotNull N node) {
        return this.checkingModel != null ? this.checkingModel.getCheckState(node) : CheckState.unchecked;
    }

    public boolean isUnchecked(@NotNull N node) {
        return this.checkingModel != null && this.checkingModel.getCheckState(node) == CheckState.unchecked;
    }

    public boolean isChecked(@NotNull N node) {
        return this.checkingModel != null && this.checkingModel.getCheckState(node) == CheckState.checked;
    }

    public boolean isMixed(@NotNull N node) {
        return this.checkingModel != null && this.checkingModel.getCheckState(node) == CheckState.mixed;
    }

    @NotNull
    public List<N> getNodes(@NotNull CheckState state) {
        return this.getNodes(state, NodesAcceptPolicy.all);
    }

    @NotNull
    public List<N> getNodes(@NotNull CheckState state, @NotNull NodesAcceptPolicy policy) {
        return this.checkingModel != null ? this.checkingModel.getNodes(state, policy) : new ArrayList();
    }

    public void setChecked(@NotNull N node, boolean checked) {
        if (this.checkingModel != null) {
            this.checkingModel.setChecked(node, checked);
        }
    }

    public void setChecked(@NotNull Collection<N> nodes, boolean checked) {
        if (this.checkingModel != null) {
            this.checkingModel.setChecked(nodes, checked);
        }
    }

    public void invertCheck(@NotNull N node) {
        if (this.checkingModel != null) {
            this.checkingModel.invertCheck(node);
        }
    }

    public void invertCheck(@NotNull List<N> nodes) {
        if (this.checkingModel != null) {
            this.checkingModel.invertCheck((Collection<N>)nodes);
        }
    }

    public void checkAll() {
        if (this.checkingModel != null) {
            this.checkingModel.checkAll();
        }
    }

    public void uncheckAll() {
        if (this.checkingModel != null) {
            this.checkingModel.uncheckAll();
        }
    }

    @Nullable
    public TreeCheckingModel<N> getCheckingModel() {
        return this.checkingModel;
    }

    public void setCheckingModel(@Nullable TreeCheckingModel<N> checkingModel) {
        if (this.checkingModel != null) {
            for (CheckStateChangeListener listener : (CheckStateChangeListener[])this.listenerList.getListeners(CheckStateChangeListener.class)) {
                this.checkingModel.removeCheckStateChangeListener(listener);
            }
        }
        this.checkingModel = checkingModel;
        this.updateVisibleNodes();
        if (checkingModel != null) {
            for (CheckStateChangeListener listener : (CheckStateChangeListener[])this.listenerList.getListeners(CheckStateChangeListener.class)) {
                checkingModel.addCheckStateChangeListener(listener);
            }
        }
    }

    @NotNull
    protected TreeCheckingModel<N> createDefaultCheckingModel() {
        return new DefaultTreeCheckingModel(this);
    }

    public boolean isCheckBoxEnabled(@NotNull N node) {
        return this.checkBoxEnabledStateProvider == null || this.checkBoxEnabledStateProvider.test(node);
    }

    @Nullable
    public Predicate<N> getCheckBoxEnabledStateProvider() {
        return this.checkBoxEnabledStateProvider;
    }

    public void setCheckBoxEnabledStateProvider(@Nullable Predicate<N> provider) {
        if (provider != this.getCheckBoxEnabledStateProvider()) {
            Predicate<N> old = this.checkBoxEnabledStateProvider;
            this.checkBoxEnabledStateProvider = provider;
            this.firePropertyChange(ENABLED_STATE_PROVIDER_PROPERTY, old, provider);
        }
    }

    public boolean isCheckBoxVisible(@NotNull N node) {
        return this.checkBoxVisibleStateProvider == null || this.checkBoxVisibleStateProvider.test(node);
    }

    @Nullable
    public Predicate<N> getCheckBoxVisibleStateProvider() {
        return this.checkBoxVisibleStateProvider;
    }

    public void setCheckBoxVisibleStateProvider(@Nullable Predicate<N> provider) {
        if (provider != this.getCheckBoxVisibleStateProvider()) {
            Predicate<N> old = this.checkBoxVisibleStateProvider;
            this.checkBoxVisibleStateProvider = provider;
            this.firePropertyChange(VISIBLE_STATE_PROVIDER_PROPERTY, old, provider);
        }
    }

    public boolean isRecursiveCheckingEnabled() {
        return this.recursiveChecking == null || this.recursiveChecking != false;
    }

    public void setRecursiveChecking(boolean recursive) {
        if (recursive != this.isRecursiveCheckingEnabled()) {
            Boolean old = this.recursiveChecking;
            this.recursiveChecking = recursive;
            if (this.checkingModel != null) {
                this.checkingModel.checkingModeChanged(this.recursiveChecking);
            }
            this.firePropertyChange(RECURSIVE_CHECKING_PROPERTY, old, (Object)recursive);
        }
    }

    public boolean isCheckBoxVisible() {
        return this.checkBoxVisible == null || this.checkBoxVisible != false;
    }

    public void setCheckBoxVisible(boolean visible) {
        if (visible != this.isCheckBoxVisible()) {
            Boolean old = this.checkBoxVisible;
            this.checkBoxVisible = visible;
            this.firePropertyChange(CHECK_BOX_VISIBLE_PROPERTY, old, (Object)visible);
            this.updateVisibleNodes();
        }
    }

    public boolean isCheckingEnabled() {
        return this.checkingEnabled == null || this.checkingEnabled != false;
    }

    public void setCheckingEnabled(boolean enabled) {
        if (enabled != this.isCheckingEnabled()) {
            Boolean old = this.checkingEnabled;
            this.checkingEnabled = enabled;
            this.firePropertyChange(CHECKING_ENABLED_PROPERTY, old, (Object)enabled);
            this.repaint();
        }
    }

    public boolean isCheckMixedOnToggle() {
        return this.checkMixedOnToggle == null || this.checkMixedOnToggle != false;
    }

    public void setCheckMixedOnToggle(boolean checkMixedOnToggle) {
        if (checkMixedOnToggle != this.isCheckMixedOnToggle()) {
            Boolean old = this.checkMixedOnToggle;
            this.checkMixedOnToggle = checkMixedOnToggle;
            this.firePropertyChange(CHECK_MIXED_ON_TOGGLE_PROPERTY, old, (Object)checkMixedOnToggle);
        }
    }

    @Nullable
    public Rectangle getCheckBoxBounds(@Nullable N node) {
        return this.getCheckBoxBounds(this.getPathForNode(node));
    }

    @Nullable
    public Rectangle getCheckBoxBounds(@Nullable TreePath treePath) {
        Rectangle pathBounds;
        Rectangle checkBoxBounds = null;
        if (this.checkBoxCellRenderer != null && (pathBounds = this.getPathBounds(treePath)) != null) {
            Dimension cbSize = this.checkBoxCellRenderer.getCheckBox().getPreferredSize();
            if (this.getComponentOrientation().isLeftToRight()) {
                pathBounds.width = cbSize.width;
            } else {
                pathBounds.x += pathBounds.width - cbSize.width;
                pathBounds.width = cbSize.width;
            }
            checkBoxBounds = pathBounds;
        }
        return checkBoxBounds;
    }

    public boolean isCheckingByUserEnabled() {
        return this.isEnabled() && this.isCheckBoxVisible() && this.isCheckingEnabled();
    }

    public void addCheckStateChangeListener(@NotNull CheckStateChangeListener<N> listener) {
        this.listenerList.add(CheckStateChangeListener.class, listener);
        if (this.checkingModel != null) {
            this.checkingModel.addCheckStateChangeListener(listener);
        }
    }

    public void removeCheckStateChangeListener(@NotNull CheckStateChangeListener listener) {
        this.listenerList.remove(CheckStateChangeListener.class, listener);
        if (this.checkingModel != null) {
            this.checkingModel.removeCheckStateChangeListener(listener);
        }
    }

    public void fireCheckStateChanged(@NotNull List<CheckStateChange<N>> stateChanges) {
        for (CheckStateChangeListener listener : (CheckStateChangeListener[])this.listenerList.getListeners(CheckStateChangeListener.class)) {
            listener.checkStateChanged(this, stateChanges);
        }
    }

    protected class Handler
    implements MouseListener,
    KeyListener,
    Serializable {
        protected Handler() {
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (WebCheckBoxTree.this.isCheckingByUserEnabled() && Hotkey.SPACE.isTriggered(e)) {
                List nodes = WebCheckBoxTree.this.getSelectedNodes();
                Iterator nodesIterator = nodes.iterator();
                while (nodesIterator.hasNext()) {
                    MutableTreeNode node = (MutableTreeNode)nodesIterator.next();
                    if (WebCheckBoxTree.this.isCheckBoxVisible(node) && WebCheckBoxTree.this.isCheckBoxEnabled(node)) continue;
                    nodesIterator.remove();
                }
                if (nodes.size() > 0) {
                    WebCheckBoxTree.this.invertCheck(nodes);
                }
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Rectangle checkBoxBounds;
            Object node;
            if (WebCheckBoxTree.this.isCheckingByUserEnabled() && SwingUtils.isLeftMouseButton(e) && (node = WebCheckBoxTree.this.getNodeForLocation(e.getPoint())) != null && WebCheckBoxTree.this.isCheckBoxVisible(node) && WebCheckBoxTree.this.isCheckBoxEnabled(node) && (checkBoxBounds = WebCheckBoxTree.this.getCheckBoxBounds(node)) != null && checkBoxBounds.contains(e.getPoint())) {
                WebCheckBoxTree.this.invertCheck(node);
            }
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
        }
    }
}

