/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.ui.ChildStyleIdBridge;
import com.alee.api.ui.StyleIdBridge;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.tree.CheckBoxTreeCellRenderer;
import com.alee.extended.tree.CheckBoxTreeNodeParameters;
import com.alee.extended.tree.WebCheckBoxTree;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.tree.TreeNodeParameters;
import com.alee.laf.tree.WTreeUI;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class WebCheckBoxTreeCellRenderer<N extends MutableTreeNode, C extends WebCheckBoxTree<N>, P extends CheckBoxTreeNodeParameters<N, C>>
extends WebPanel
implements CheckBoxTreeCellRenderer,
Stateful {
    @NotNull
    protected List<String> states;
    @NotNull
    protected WebTristateCheckBox checkBox;

    public WebCheckBoxTreeCellRenderer() {
        super((LayoutManager)null, new Component[0]);
        this.setName("Tree.cellRenderer");
        this.states = new ArrayList<String>(3);
        this.checkBox = new WebTristateCheckBox();
    }

    @Override
    @NotNull
    public List<String> getStates() {
        return this.states;
    }

    @Override
    @NotNull
    public WebTristateCheckBox getCheckBox() {
        return this.checkBox;
    }

    protected void updateStates(@NotNull P parameters) {
        WTreeUI ui;
        this.states.clear();
        this.states.add(((TreeNodeParameters)parameters).isSelected() ? "selected" : "unselected");
        this.states.add(((TreeNodeParameters)parameters).isExpanded() ? "expanded" : "collapsed");
        if (((TreeNodeParameters)parameters).isFocused()) {
            this.states.add("focused");
        }
        if (((TreeNodeParameters)parameters).isLeaf()) {
            this.states.add("leaf");
        }
        if ((ui = ((WebCheckBoxTree)((TreeNodeParameters)parameters).tree()).getUI()) != null && ui.getHoverRow() == ((TreeNodeParameters)parameters).row()) {
            this.states.add("hover");
        }
        this.states.add(((WebCheckBoxTree)((TreeNodeParameters)parameters).tree()).getCheckState((MutableTreeNode)((TreeNodeParameters)parameters).node()).name());
        this.states.add(((CheckBoxTreeNodeParameters)parameters).isCheckBoxVisible() ? "check-visible" : "check-hidden");
        this.states.addAll(DecorationUtils.getExtraStates(((TreeNodeParameters)parameters).node()));
    }

    protected void updateStyleId(@NotNull P parameters) {
        StyleIdBridge styleIdBridge;
        StyleId styleId;
        StyleId id = null;
        if (((TreeNodeParameters)parameters).node() instanceof ChildStyleIdBridge) {
            ChildStyleIdBridge childStyleIdBridge = (ChildStyleIdBridge)((TreeNodeParameters)parameters).node();
            ChildStyleId childStyleId = childStyleIdBridge.getChildStyleId(parameters);
            if (childStyleId != null) {
                id = childStyleId.at((JComponent)((TreeNodeParameters)parameters).tree());
            }
        } else if (((TreeNodeParameters)parameters).node() instanceof StyleIdBridge && (styleId = (styleIdBridge = (StyleIdBridge)((TreeNodeParameters)parameters).node()).getStyleId(parameters)) != null) {
            id = styleId;
        }
        if (id == null) {
            id = StyleId.checkboxtreeCellRenderer.at((JComponent)((TreeNodeParameters)parameters).tree());
        }
        this.setStyleId(id);
        this.checkBox.setStyleId(StyleId.checkboxtreeCheckBox.at(this));
    }

    protected void updateView(@NotNull P parameters) {
        TreeCellRenderer actual;
        this.removeAll();
        this.setLayout(new BorderLayout(((WebCheckBoxTree)((TreeNodeParameters)parameters).tree()).getCheckBoxRendererGap(), 0));
        this.setEnabled(((CheckBoxTreeNodeParameters)parameters).isCheckBoxEnabled());
        this.setComponentOrientation(this.orientationForValue(parameters));
        if (((CheckBoxTreeNodeParameters)parameters).isCheckBoxVisible()) {
            this.checkBox.setEnabled(((CheckBoxTreeNodeParameters)parameters).isCheckBoxEnabled());
            this.checkBox.setState(((WebCheckBoxTree)((TreeNodeParameters)parameters).tree()).getCheckState((MutableTreeNode)((TreeNodeParameters)parameters).node()));
            this.add((Component)this.checkBox, (Object)"Before");
        }
        if ((actual = ((WebCheckBoxTree)((TreeNodeParameters)parameters).tree()).getActualRenderer()) != null) {
            this.add(actual.getTreeCellRendererComponent((JTree)((TreeNodeParameters)parameters).tree(), ((TreeNodeParameters)parameters).node(), ((TreeNodeParameters)parameters).isSelected(), ((TreeNodeParameters)parameters).isExpanded(), ((TreeNodeParameters)parameters).isLeaf(), ((TreeNodeParameters)parameters).row(), ((TreeNodeParameters)parameters).isFocused()), (Object)"Center");
        }
    }

    @NotNull
    protected ComponentOrientation orientationForValue(@NotNull P parameters) {
        return ((WebCheckBoxTree)((TreeNodeParameters)parameters).tree()).getComponentOrientation();
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object node, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        P parameters = this.getRenderingParameters((WebCheckBoxTree)tree, (MutableTreeNode)node, isSelected, expanded, leaf, row, hasFocus);
        this.updateStates(parameters);
        this.updateStyleId(parameters);
        this.updateView(parameters);
        DecorationUtils.fireStatesChanged(this);
        return this;
    }

    @NotNull
    protected P getRenderingParameters(@NotNull C tree, @NotNull N node, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return (P)new CheckBoxTreeNodeParameters<N, C>(tree, node, row, leaf, isSelected, expanded, hasFocus);
    }

    @Override
    public final void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public final void repaint(@NotNull Rectangle r) {
    }

    @Override
    public final void repaint() {
    }

    public static final class UIResource<N extends MutableTreeNode, C extends WebCheckBoxTree<N>, P extends CheckBoxTreeNodeParameters<N, C>>
    extends WebCheckBoxTreeCellRenderer<N, C, P>
    implements javax.swing.plaf.UIResource {
    }
}

