/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Supplier;
import com.alee.extended.behavior.ComponentMoveBehavior;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.window.IPopOverPainter;
import com.alee.extended.window.PopOverAdapter;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.PopOverLocation;
import com.alee.extended.window.PopOverSourcePoint;
import com.alee.extended.window.WebPopOver;
import com.alee.extended.window.WindowFollowBehavior;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.AbstractPopupPainter;
import com.alee.laf.menu.PopupStyle;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;

@XStreamAlias(value="PopOverPainter")
public class PopOverPainter<C extends JRootPane, U extends WRootPaneUI>
extends AbstractPopupPainter<C, U>
implements IPopOverPainter<C, U> {
    protected transient ComponentMoveBehavior moveAdapter;
    protected transient WindowFocusListener focusListener;
    protected transient ComponentAdapter resizeAdapter;
    protected transient VisibilityBehavior<C> windowVisibilityBehavior;
    protected boolean popOverFocused = false;
    protected boolean attached = false;
    protected PopOverSourcePoint popOverSourcePoint = PopOverSourcePoint.componentSide;
    protected PopOverDirection preferredDirection = null;
    protected PopOverDirection currentDirection = null;
    protected PopOverAlignment preferredAlignment = null;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        final WebPopOver popOver = this.getPopOver((JRootPane)this.component);
        this.focusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                PopOverPainter.this.setPopOverFocused(true);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                PopOverPainter.this.setPopOverFocused(false);
            }
        };
        popOver.addWindowFocusListener(this.focusListener);
        this.moveAdapter = new ComponentMoveBehavior(this.component){

            @Override
            @Nullable
            protected Rectangle getDragStartBounds(@NotNull MouseEvent e) {
                Rectangle bounds;
                if (popOver.isMovable()) {
                    int sw = PopOverPainter.this.getShadeWidth();
                    bounds = new Rectangle(sw, sw, ((JRootPane)PopOverPainter.this.component).getWidth() - sw * 2, ((JRootPane)PopOverPainter.this.component).getHeight() - sw * 2);
                } else {
                    bounds = null;
                }
                return bounds;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.dragging && PopOverPainter.this.attached) {
                    PopOverPainter.this.attached = false;
                    PopOverPainter.this.preferredDirection = null;
                    PopOverPainter.this.setPopupStyle(PopupStyle.simple);
                    PopOverPainter.this.repaint();
                    popOver.fireDetached();
                }
                super.mouseDragged(e);
            }
        };
        this.moveAdapter.install();
        if (!ProprietaryUtils.isWindowTransparencyAllowed() && ProprietaryUtils.isWindowShapeAllowed()) {
            this.resizeAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Rectangle bounds = popOver.getBounds();
                    ++bounds.width;
                    ++bounds.height;
                    ProprietaryUtils.setWindowShape(popOver, PopOverPainter.this.provideShape(PopOverPainter.this.component, bounds));
                }
            };
            popOver.addComponentListener(this.resizeAdapter);
        }
        this.windowVisibilityBehavior = new VisibilityBehavior<C>((JRootPane)this.component){

            @Override
            protected void displayed(@NotNull C component2) {
                popOver.fireOpened();
                WebLookAndFeel.fireWindowDisplayed(popOver);
            }

            @Override
            protected void hidden(@NotNull C component2) {
                popOver.fireClosed();
                WebLookAndFeel.fireWindowHidden(popOver);
            }
        };
        this.windowVisibilityBehavior.install();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.windowVisibilityBehavior.uninstall();
        this.windowVisibilityBehavior = null;
        WebPopOver popOver = this.getPopOver((JRootPane)this.component);
        if (this.resizeAdapter != null) {
            popOver.removeComponentListener(this.resizeAdapter);
            this.resizeAdapter = null;
        }
        this.moveAdapter.uninstall();
        this.moveAdapter = null;
        popOver.removeWindowFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallPropertiesAndListeners();
    }

    @Override
    public boolean isDecorated() {
        return true;
    }

    public boolean isPopOverFocused() {
        return this.popOverFocused;
    }

    public void setPopOverFocused(boolean focused) {
        if (this.popOverFocused != focused) {
            this.popOverFocused = focused;
            this.repaint();
        }
    }

    @Override
    protected float getCurrentShadeOpacity() {
        return this.popOverFocused ? this.shadeOpacity : this.shadeOpacity * 0.7f;
    }

    public PopOverSourcePoint getPopOverSourcePoint() {
        return this.popOverSourcePoint;
    }

    public void setPopOverSourcePoint(PopOverSourcePoint popOverSourcePoint) {
        this.popOverSourcePoint = popOverSourcePoint;
    }

    public PopOverDirection getPreferredDirection() {
        return this.preferredDirection;
    }

    public void setPreferredDirection(PopOverDirection direction) {
        this.preferredDirection = direction;
    }

    public PopOverDirection getCurrentDirection() {
        return this.currentDirection;
    }

    public void setCurrentDirection(PopOverDirection direction) {
        this.currentDirection = direction;
    }

    @Override
    public void configure(WebPopOver popOver, PopOverLocation location) {
        this.attached = false;
        this.preferredDirection = null;
        this.setPopupStyle(PopupStyle.simple);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        popOver.pack();
        switch (location) {
            case center: {
                popOver.setLocation(ss.width / 2 - popOver.getWidth() / 2, ss.height / 2 - popOver.getHeight() / 2);
                break;
            }
            case topLeft: {
                popOver.setLocation(0, 0);
                break;
            }
            case topRight: {
                popOver.setLocation(ss.width - popOver.getWidth(), 0);
                break;
            }
            case bottomLeft: {
                popOver.setLocation(0, ss.height - popOver.getHeight());
                break;
            }
            case bottomRight: {
                popOver.setLocation(ss.width - popOver.getWidth(), ss.height - popOver.getHeight());
                break;
            }
            case topCenter: {
                popOver.setLocation(ss.width / 2 - popOver.getWidth() / 2, 0);
                break;
            }
            case bottomCenter: {
                popOver.setLocation(ss.width / 2 - popOver.getWidth() / 2, ss.height - popOver.getHeight());
                break;
            }
            case leftCenter: {
                popOver.setLocation(0, ss.height / 2 - popOver.getHeight() / 2);
                break;
            }
            case rightCenter: {
                popOver.setLocation(ss.width - popOver.getWidth(), ss.height / 2 - popOver.getHeight() / 2);
            }
        }
    }

    @Override
    public void configure(WebPopOver popOver, int x, int y) {
        this.attached = false;
        this.preferredDirection = null;
        this.setPopupStyle(PopupStyle.simple);
        popOver.pack();
        popOver.setLocation(x - this.getShadeWidth(), y - this.getShadeWidth());
    }

    @Override
    public void configure(WebPopOver popOver, final Component invoker, final Supplier<Rectangle> boundsSupplier, PopOverDirection direction, PopOverAlignment alignment) {
        Supplier<Rectangle> actualBoundsProvider = boundsSupplier == null ? null : new Supplier<Rectangle>(){
            private Rectangle lastBounds = new Rectangle();

            @Override
            public Rectangle get() {
                if (invoker.isShowing()) {
                    Rectangle bounds = (Rectangle)boundsSupplier.get();
                    Point los = CoreSwingUtils.locationOnScreen(invoker);
                    this.lastBounds = new Rectangle(los.x + bounds.x, los.y + bounds.y, bounds.width, bounds.height);
                }
                return this.lastBounds;
            }
        };
        this.attached = true;
        this.preferredDirection = direction != null ? direction : PopOverDirection.down;
        this.preferredAlignment = alignment;
        popOver.pack();
        this.updatePopOverLocation(popOver, invoker, actualBoundsProvider);
        this.installPopOverLocationUpdater(popOver, invoker, actualBoundsProvider);
    }

    protected void updatePopOverLocation(WebPopOver popOver, Component invoker, Supplier<Rectangle> boundsProvider) {
        if (boundsProvider != null) {
            this.updatePopOverLocation(popOver, invoker, boundsProvider.get());
        } else {
            this.updatePopOverLocation(popOver, invoker);
        }
    }

    protected void updatePopOverLocation(WebPopOver popOver, Component invoker) {
        if (invoker.isShowing()) {
            this.updatePopOverLocation(popOver, invoker, CoreSwingUtils.getBoundsOnScreen(invoker, false));
        }
    }

    protected void updatePopOverLocation(WebPopOver popOver, Component invoker, Rectangle invokerBounds) {
        this.setPopupStyle(PopupStyle.dropdown);
        Dimension size = popOver.getSize();
        int sw = this.getShadeWidth();
        int round = this.getRound();
        int cw = this.getCornerWidth();
        Dimension ps = new Dimension(size.width - sw * 2, size.height - sw * 2);
        Rectangle screenBounds = SystemUtils.getDeviceBounds(invoker, false);
        PopOverDirection actualDirection = this.getActualDirection(invokerBounds, this.ltr, cw, ps, screenBounds);
        this.setCornerSide(actualDirection.getCornerSide(this.ltr));
        this.currentDirection = actualDirection;
        Point actualLocation = this.getActualLocation(invokerBounds, this.ltr, round, cw, ps, screenBounds, actualDirection);
        actualLocation.x -= sw;
        actualLocation.y -= sw;
        this.setCornerAlignment(-1);
        this.setRelativeCorner(this.getRelativeCorner(invokerBounds, actualDirection, actualLocation));
        popOver.setLocation(actualLocation);
    }

    protected void installPopOverLocationUpdater(final WebPopOver popOver, final Component invoker, final Supplier<Rectangle> boundsProvider) {
        AncestorAdapter ancestorAdapter;
        final Window invokerWindow = CoreSwingUtils.getNonNullWindowAncestor(invoker);
        final WindowFollowBehavior windowFollowBehavior = new WindowFollowBehavior(popOver, invokerWindow){

            @Override
            public boolean isEnabled() {
                return !PopOverPainter.this.attached;
            }
        };
        windowFollowBehavior.install();
        WindowStateListener windowStateListener = new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (PopOverPainter.this.attached) {
                    if (e.getNewState() == 203) {
                        popOver.setVisible(false);
                    } else if (e.getOldState() == 203) {
                        popOver.setVisible(true);
                    }
                }
            }
        };
        invokerWindow.addWindowStateListener(windowStateListener);
        final ComponentAdapter invokerWindowAdapter = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PopOverPainter.this.attached) {
                    PopOverPainter.this.updatePopOverLocation(popOver, invoker, boundsProvider);
                    windowFollowBehavior.updateLastLocation();
                }
            }
        };
        invokerWindow.addComponentListener(invokerWindowAdapter);
        final ComponentAdapter invokerAdapter = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PopOverPainter.this.attached) {
                    PopOverPainter.this.updatePopOverLocation(popOver, invoker, boundsProvider);
                    windowFollowBehavior.updateLastLocation();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (PopOverPainter.this.attached) {
                    PopOverPainter.this.updatePopOverLocation(popOver, invoker, boundsProvider);
                    windowFollowBehavior.updateLastLocation();
                }
            }
        };
        invoker.addComponentListener(invokerAdapter);
        if (invoker instanceof JComponent) {
            ancestorAdapter = new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    if (PopOverPainter.this.attached) {
                        PopOverPainter.this.updatePopOverLocation(popOver, invoker, boundsProvider);
                        windowFollowBehavior.updateLastLocation();
                    }
                }
            };
            ((JComponent)invoker).addAncestorListener(ancestorAdapter);
        } else {
            ancestorAdapter = null;
        }
        final PropertyChangeListener orientationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PopOverPainter.this.updatePopOverLocation(popOver, invoker, boundsProvider);
                windowFollowBehavior.updateLastLocation();
            }
        };
        popOver.addPropertyChangeListener("componentOrientation", orientationListener);
        popOver.addPopOverListener(new PopOverAdapter(){

            @Override
            public void reopened(WebPopOver popOver2) {
                this.destroy();
            }

            @Override
            public void closed(WebPopOver popOver2) {
                this.destroy();
            }

            protected void destroy() {
                popOver.removePopOverListener(this);
                invokerWindow.removeComponentListener(invokerWindowAdapter);
                windowFollowBehavior.uninstall();
                invoker.removeComponentListener(invokerAdapter);
                if (invoker instanceof JComponent) {
                    ((JComponent)invoker).removeAncestorListener(ancestorAdapter);
                }
                popOver.removePropertyChangeListener("componentOrientation", orientationListener);
            }
        });
    }

    protected int getRelativeCorner(Rectangle ib, PopOverDirection actualDirection, Point actualLocation) {
        switch (actualDirection) {
            case up: 
            case down: {
                return ib.x + ib.width / 2 - actualLocation.x;
            }
            case left: 
            case right: {
                return ib.y + ib.height / 2 - actualLocation.y;
            }
        }
        return -1;
    }

    protected Point getActualLocation(Rectangle ib, boolean ltr, int round, int cw, Dimension ps, Rectangle screenBounds, PopOverDirection actualDirection) {
        Point sp2 = this.getActualSourcePoint(ib, ltr, actualDirection);
        if (actualDirection == PopOverDirection.up) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp2.x - ps.width / 2, sp2.y - cw - ps.height);
                return this.checkRightCollision(this.checkLeftCollision(location, screenBounds), ps, screenBounds);
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.leading : PopOverAlignment.trailing)) {
                return this.checkLeftCollision(new Point(sp2.x + cw * 2 + round - ps.width, sp2.y - cw - ps.height), screenBounds);
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.trailing : PopOverAlignment.leading)) {
                return this.checkRightCollision(new Point(sp2.x - cw * 2 - round, sp2.y - cw - ps.height), ps, screenBounds);
            }
        } else if (actualDirection == PopOverDirection.down) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp2.x - ps.width / 2, sp2.y + cw);
                return this.checkRightCollision(this.checkLeftCollision(location, screenBounds), ps, screenBounds);
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.leading : PopOverAlignment.trailing)) {
                return this.checkLeftCollision(new Point(sp2.x + cw * 2 + round - ps.width, sp2.y + cw), screenBounds);
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.trailing : PopOverAlignment.leading)) {
                return this.checkRightCollision(new Point(sp2.x - cw * 2 - round, sp2.y + cw), ps, screenBounds);
            }
        } else if (actualDirection == (ltr ? PopOverDirection.left : PopOverDirection.right)) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp2.x - cw - ps.width, sp2.y - ps.height / 2);
                return this.checkBottomCollision(this.checkTopCollision(location, screenBounds), ps, screenBounds);
            }
            if (this.preferredAlignment == PopOverAlignment.leading) {
                return this.checkTopCollision(new Point(sp2.x - cw - ps.width, sp2.y + cw * 2 + round - ps.height), screenBounds);
            }
            if (this.preferredAlignment == PopOverAlignment.trailing) {
                return this.checkBottomCollision(new Point(sp2.x - cw - ps.width, sp2.y - cw * 2 - round), ps, screenBounds);
            }
        } else if (actualDirection == (ltr ? PopOverDirection.right : PopOverDirection.left)) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp2.x + cw, sp2.y - ps.height / 2);
                return this.checkBottomCollision(this.checkTopCollision(location, screenBounds), ps, screenBounds);
            }
            if (this.preferredAlignment == PopOverAlignment.leading) {
                return this.checkTopCollision(new Point(sp2.x + cw, sp2.y + cw * 2 + round - ps.height), screenBounds);
            }
            if (this.preferredAlignment == PopOverAlignment.trailing) {
                return this.checkBottomCollision(new Point(sp2.x + cw, sp2.y - cw * 2 - round), ps, screenBounds);
            }
        }
        return null;
    }

    protected Point checkTopCollision(Point location, Rectangle screenBounds) {
        if (location.y < screenBounds.y) {
            location.y = screenBounds.y;
        }
        return location;
    }

    protected Point checkBottomCollision(Point location, Dimension ps, Rectangle screenBounds) {
        if (location.y + ps.height > screenBounds.y + screenBounds.height) {
            location.y = screenBounds.y + screenBounds.height - ps.height;
        }
        return location;
    }

    protected Point checkLeftCollision(Point location, Rectangle screenBounds) {
        if (location.x < screenBounds.x) {
            location.x = screenBounds.x;
        }
        return location;
    }

    protected Point checkRightCollision(Point location, Dimension ps, Rectangle screenBounds) {
        if (location.x + ps.width > screenBounds.x + screenBounds.width) {
            location.x = screenBounds.x + screenBounds.width - ps.width;
        }
        return location;
    }

    protected PopOverDirection getActualDirection(Rectangle ib, boolean ltr, int cw, Dimension ps, Rectangle screenBounds) {
        for (PopOverDirection checkedDirection : this.preferredDirection.getPriority()) {
            Point sp2 = this.getActualSourcePoint(ib, ltr, checkedDirection);
            if (!(checkedDirection == PopOverDirection.up ? sp2.y - cw - ps.height > screenBounds.y : (checkedDirection == PopOverDirection.down ? sp2.y + cw + ps.height < screenBounds.y + screenBounds.height : (checkedDirection == (ltr ? PopOverDirection.left : PopOverDirection.right) ? sp2.x - cw - ps.width > screenBounds.x : checkedDirection == (ltr ? PopOverDirection.right : PopOverDirection.left) && sp2.x + cw + ps.width < screenBounds.x + screenBounds.width)))) continue;
            return checkedDirection;
        }
        return this.preferredDirection;
    }

    protected Point getActualSourcePoint(Rectangle ib, boolean ltr, PopOverDirection direction) {
        if (this.popOverSourcePoint == PopOverSourcePoint.componentCenter) {
            return new Point(ib.x + ib.width / 2, ib.y + ib.height / 2);
        }
        if (direction == PopOverDirection.up) {
            return new Point(ib.x + ib.width / 2, ib.y);
        }
        if (direction == PopOverDirection.down) {
            return new Point(ib.x + ib.width / 2, ib.y + ib.height);
        }
        if (direction == (ltr ? PopOverDirection.left : PopOverDirection.right)) {
            return new Point(ib.x, ib.y + ib.height / 2);
        }
        if (direction == (ltr ? PopOverDirection.right : PopOverDirection.left)) {
            return new Point(ib.x + ib.width, ib.y + ib.height / 2);
        }
        return null;
    }

    protected final WebPopOver getPopOver(C c) {
        return (WebPopOver)((JComponent)c).getClientProperty("popover.instance");
    }
}

