/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.strokes;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class RandomStroke
implements Stroke {
    private float detail = 2.0f;
    private float amplitude = 2.0f;
    private static final float FLATNESS = 1.0f;

    public RandomStroke(float detail, float amplitude) {
        this.detail = detail;
        this.amplitude = amplitude;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath result2 = new GeneralPath();
        shape = new BasicStroke(10.0f).createStrokedShape(shape);
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float next = 0.0f;
        while (!it.isDone()) {
            int type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = this.randomize(points[0]);
                    moveY = lastY = this.randomize(points[1]);
                    result2.moveTo(moveX, moveY);
                    next = 0.0f;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    float thisX = this.randomize(points[0]);
                    float thisY = this.randomize(points[1]);
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        float r = 1.0f / distance;
                        while (distance >= next) {
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            result2.lineTo(this.randomize(x), this.randomize(y));
                            next += this.detail;
                        }
                    }
                    next -= distance;
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        return result2;
    }

    private float randomize(float x) {
        return x + (float)Math.random() * this.amplitude * 2.0f - 1.0f;
    }
}

