/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.strokes;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class ZigzagStroke
implements Stroke {
    private float amplitude = 10.0f;
    private float wavelength = 10.0f;
    private final Stroke stroke;
    private static final float FLATNESS = 1.0f;

    public ZigzagStroke(float amplitude, float wavelength) {
        this(new BasicStroke(1.0f), amplitude, wavelength);
    }

    public ZigzagStroke(Stroke stroke, float amplitude, float wavelength) {
        this.stroke = stroke;
        this.amplitude = amplitude;
        this.wavelength = wavelength;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath result2 = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float next = 0.0f;
        int phase = 0;
        while (!it.isDone()) {
            int type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    result2.moveTo(moveX, moveY);
                    next = this.wavelength / 2.0f;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    float thisX = points[0];
                    float thisY = points[1];
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        float r = 1.0f / distance;
                        while (distance >= next) {
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            if (!(phase & true)) {
                                result2.lineTo(x + this.amplitude * dy * r, y - this.amplitude * dx * r);
                            } else {
                                result2.lineTo(x - this.amplitude * dy * r, y + this.amplitude * dx * r);
                            }
                            next += this.wavelength;
                            ++phase;
                        }
                    }
                    next -= distance;
                    lastX = thisX;
                    lastY = thisY;
                    if (type != 4) break;
                    result2.closePath();
                }
            }
            it.next();
        }
        return this.stroke.createStrokedShape(result2);
    }
}

