/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.checkbox;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.button.AbstractButtonPainter;
import com.alee.laf.checkbox.ButtonStatePainter;
import com.alee.laf.checkbox.IButtonStatePainter;
import com.alee.laf.radiobutton.IAbstractStateButtonPainter;
import com.alee.painter.DefaultPainter;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;

public abstract class AbstractStateButtonPainter<C extends AbstractButton, U extends ButtonUI, D extends IDecoration<C, D>>
extends AbstractButtonPainter<C, U, D>
implements IAbstractStateButtonPainter<C, U> {
    @DefaultPainter(value=ButtonStatePainter.class)
    protected IButtonStatePainter stateIconPainter;
    @Nullable
    protected transient Rectangle iconBounds;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.stateIconPainter);
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installStateIcon();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallStateIcon();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"icon") && newValue == null) {
            this.installStateIcon();
        }
    }

    protected void installStateIcon() {
        if (((AbstractButton)this.component).getIcon() == null || ((AbstractButton)this.component).getIcon() instanceof UIResource) {
            ((AbstractButton)this.component).setIcon(this.createIcon());
        }
    }

    protected void uninstallStateIcon() {
        if (((AbstractButton)this.component).getIcon() instanceof UIResource) {
            ((AbstractButton)this.component).setIcon(null);
        }
    }

    @Override
    @Nullable
    public Rectangle getIconBounds() {
        return this.iconBounds != null ? new Rectangle(this.iconBounds) : null;
    }

    @NotNull
    protected Icon createIcon() {
        return new StateIcon();
    }

    protected class StateIcon
    implements Icon,
    UIResource {
        protected StateIcon() {
        }

        @Override
        public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
            AbstractStateButtonPainter.this.iconBounds = new Rectangle(new Point(x, y), this.getSize());
            if (AbstractStateButtonPainter.this.stateIconPainter != null) {
                Graphics2D g2d = (Graphics2D)g;
                Object aa = GraphicsUtils.setupAntialias(g2d);
                AbstractStateButtonPainter.this.paintSection(AbstractStateButtonPainter.this.stateIconPainter, g2d, AbstractStateButtonPainter.this.iconBounds);
                GraphicsUtils.restoreAntialias(g2d, aa);
            }
        }

        @NotNull
        protected Dimension getSize() {
            return AbstractStateButtonPainter.this.stateIconPainter != null ? AbstractStateButtonPainter.this.stateIconPainter.getPreferredSize() : new Dimension(16, 16);
        }

        @Override
        public int getIconWidth() {
            return this.getSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.getSize().height;
        }
    }
}

