/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.combobox.ComboBoxPaintParameters;
import com.alee.laf.combobox.IComboBoxPainter;
import com.alee.laf.combobox.WComboBoxUI;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageSensitive;
import com.alee.managers.language.UILanguageManager;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.swing.EditabilityListener;
import com.alee.utils.swing.VisibilityListener;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ComboBoxPainter<C extends JComboBox, U extends WComboBoxUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements IComboBoxPainter<C, U>,
EditabilityListener,
VisibilityListener {
    protected transient LanguageListener languageSensitive;
    protected transient ComboBoxPaintParameters paintParameters = null;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installComboBoxListeners();
        this.installLanguageListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallLanguageListeners();
        this.uninstallComboBoxListeners();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"enabled")) {
            ((WComboBoxUI)this.ui).getListBox().setEnabled(((JComboBox)this.component).isEnabled());
        }
    }

    protected void installComboBoxListeners() {
        ((WComboBoxUI)this.ui).addEditabilityListener(this);
        ((WComboBoxUI)this.ui).addPopupVisibilityListener(this);
    }

    @Override
    public void editabilityChanged(boolean editable) {
        this.updateDecorationState();
    }

    @Override
    public void visibilityChanged(boolean visible) {
        this.updateDecorationState();
    }

    protected void uninstallComboBoxListeners() {
        ((WComboBoxUI)this.ui).removePopupVisibilityListener(this);
        ((WComboBoxUI)this.ui).removeEditabilityListener(this);
    }

    protected void installLanguageListeners() {
        this.languageSensitive = new LanguageListener(){

            @Override
            public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                if (ComboBoxPainter.this.isLanguageSensitive()) {
                    ((WComboBoxUI)ComboBoxPainter.this.ui).updateRendererSize();
                }
            }
        };
        UILanguageManager.addLanguageListener(this.component, this.languageSensitive);
    }

    protected boolean isLanguageSensitive() {
        boolean sensitive = false;
        if (this.component instanceof LanguageSensitive || ((JComboBox)this.component).getRenderer() instanceof LanguageSensitive) {
            sensitive = true;
        } else {
            ComboBoxModel model = ((JComboBox)this.component).getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!(model.getElementAt(i) instanceof LanguageSensitive)) continue;
                sensitive = true;
                break;
            }
        }
        return sensitive;
    }

    protected void uninstallLanguageListeners() {
        UILanguageManager.removeLanguageListener(this.component, this.languageSensitive);
        this.languageSensitive = null;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (((JComboBox)this.component).isEditable()) {
            states.add("editable");
        }
        states.add(((WComboBoxUI)this.ui).isPopupVisible((JComboBox)this.component) ? "expanded" : "collapsed");
        return states;
    }

    @Override
    public void prepareToPaint(@NotNull ComboBoxPaintParameters parameters) {
        this.paintParameters = parameters;
    }

    @Override
    public void cleanupAfterPaint() {
        this.paintParameters = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.paintCurrentValue(g2d, ((WComboBoxUI)ui).getValueBounds());
        this.cleanupAfterPaint();
    }

    protected void paintCurrentValue(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (!((JComboBox)this.component).isEditable()) {
            JList list = ((WComboBoxUI)this.ui).getListBox();
            Object value = ((JComboBox)this.component).getSelectedItem();
            boolean selected = !((JComboBox)this.component).isPopupVisible();
            boolean isFocused = this.isFocused();
            ListCellRenderer<Object> renderer = ((JComboBox)this.component).getRenderer();
            Component c = renderer.getListCellRendererComponent(list, value, -1, selected, isFocused);
            c.setFont(((JComboBox)this.component).getFont());
            int x = bounds.x;
            int y = bounds.y;
            int w = bounds.width;
            int h = bounds.height;
            boolean shouldValidate = c instanceof JPanel;
            this.paintParameters.currentValuePane.paintComponent(g2d, c, this.component, x, y, w, h, shouldValidate);
        }
    }
}

