/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.combobox.ComboBoxState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public class ComboBoxSettingsProcessor
extends SettingsProcessor<JComboBox, ComboBoxState, Configuration<ComboBoxState>> {
    protected transient ActionListener actionListener;

    public ComboBoxSettingsProcessor(JComboBox comboBox, Configuration configuration) {
        super(comboBox, configuration);
    }

    @Override
    protected void register(@NotNull JComboBox comboBox) {
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxSettingsProcessor.this.save();
            }
        };
        comboBox.addActionListener(this.actionListener);
    }

    @Override
    protected void unregister(@NotNull JComboBox comboBox) {
        comboBox.removeActionListener(this.actionListener);
        this.actionListener = null;
    }

    @Override
    @Nullable
    protected ComboBoxState createDefaultValue() {
        return new ComboBoxState((JComboBox)this.component());
    }

    @Override
    protected void loadSettings(@NotNull JComboBox comboBox) {
        ((ComboBoxState)this.loadSettings()).apply(comboBox);
    }

    @Override
    protected void saveSettings(@NotNull JComboBox comboBox) {
        this.saveSettings(new ComboBoxState(comboBox));
    }
}

