/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.ComboBoxPaintParameters;
import com.alee.laf.combobox.WComboBoxUI;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.combobox.WebComboBoxEditor;
import com.alee.laf.combobox.WebComboBoxRenderer;
import com.alee.laf.list.WebList;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.ClientProperty;
import com.alee.utils.swing.EditabilityListener;
import com.alee.utils.swing.VisibilityListener;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WebComboBoxUI
extends WComboBoxUI {
    public static final ClientProperty<JComboBox> COMBOBOX_INSTANCE = new ClientProperty<Object>("JComboBox.instance", null);
    protected static ListCellRenderer DEFAULT_RENDERER;
    protected transient PropertyChangeListener visibilityListener;
    protected transient EventListenerList listenerList;
    protected transient PropertyChangeListener editorChangeListener;
    protected transient JSeparator separator;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.listenerList = new EventListenerList();
        super.installUI(c);
        if (this.popup instanceof JComponent) {
            this.visibilityListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (Objects.notEquals(evt.getOldValue(), evt.getNewValue())) {
                        WebComboBoxUI.this.firePopupVisibilityChanged((Boolean)evt.getNewValue());
                    }
                }
            };
            ((JComponent)((Object)this.popup)).addPropertyChangeListener("visible", this.visibilityListener);
        }
        this.editorChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Objects.equals((Object)evt.getPropertyName(), (Object)"editor")) {
                    WebComboBoxUI.this.updateEditor(WebComboBoxUI.this.comboBox.getEditor());
                }
            }
        };
        this.comboBox.addPropertyChangeListener(this.editorChangeListener);
        StyleManager.installSkin(this.comboBox);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.comboBox);
        this.comboBox.removePropertyChangeListener(this.editorChangeListener);
        if (this.popup instanceof JComponent) {
            ((JComponent)((Object)this.popup)).removePropertyChangeListener("visible", this.visibilityListener);
        }
        super.uninstallUI(c);
        this.listenerList = null;
    }

    @Override
    protected void installComponents() {
        this.comboBox.removeAll();
        this.comboBox.setLayout(this.createLayoutManager());
        this.addSeparator();
        this.addArrowButton();
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    @Override
    protected void uninstallComponents() {
        this.removeArrowButton();
        this.removeSeparator();
        this.removeEditor();
        this.comboBox.removeAll();
    }

    protected void addSeparator() {
        this.separator = this.createSeparator();
        if (this.separator instanceof ComboBoxSeparator) {
            ((ComboBoxSeparator)this.separator).install();
        }
        this.comboBox.add(this.separator);
    }

    protected void removeSeparator() {
        if (this.separator != null) {
            this.comboBox.remove(this.separator);
            if (this.separator instanceof ComboBoxSeparator) {
                ((ComboBoxSeparator)this.separator).uninstall();
            }
            this.separator = null;
        }
    }

    protected void addArrowButton() {
        this.arrowButton = this.createArrowButton();
        if (this.arrowButton instanceof ComboBoxButton) {
            ((ComboBoxButton)this.arrowButton).install();
        }
        this.configureArrowButton();
        this.comboBox.add(this.arrowButton);
    }

    protected void removeArrowButton() {
        if (this.arrowButton != null) {
            this.comboBox.remove(this.arrowButton);
            this.unconfigureArrowButton();
            if (this.arrowButton instanceof ComboBoxButton) {
                ((ComboBoxButton)this.arrowButton).uninstall();
            }
            this.arrowButton = null;
        }
    }

    @NotNull
    protected ListCellRenderer createRenderer() {
        return new WebComboBoxRenderer.UIResource();
    }

    @Override
    @NotNull
    protected ComboBoxEditor createEditor() {
        WebComboBoxEditor.UIResource editor = new WebComboBoxEditor.UIResource();
        this.updateEditor(editor);
        return editor;
    }

    private void updateEditor(@Nullable ComboBoxEditor editor) {
        if (editor != null) {
            Component editorComponent = editor.getEditorComponent();
            editorComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    WebComboBoxUI.this.comboBox.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    WebComboBoxUI.this.comboBox.repaint();
                }
            });
            if (editorComponent instanceof JTextField) {
                StyleId.comboboxEditor.at(this.comboBox).set((JTextField)editorComponent);
            }
        }
    }

    @NotNull
    protected JSeparator createSeparator() {
        return new ComboBoxSeparator();
    }

    @Override
    @NotNull
    protected JButton createArrowButton() {
        return new ComboBoxButton();
    }

    @Override
    @NotNull
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            @NotNull
            protected JList createList() {
                WebList list = new WebList(this.comboBox.getModel()){

                    @Override
                    public void processMouseEvent(MouseEvent e) {
                        if (CoreSwingUtils.isMenuShortcutKeyDown(e)) {
                            Toolkit toolkit = Toolkit.getDefaultToolkit();
                            e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ toolkit.getMenuShortcutKeyMask(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
                        }
                        super.processMouseEvent(e);
                    }
                };
                COMBOBOX_INSTANCE.set(list, this.comboBox);
                return list;
            }

            @Override
            protected void configureList() {
                this.list.setFocusable(false);
                this.list.setFont(this.comboBox.getFont());
                this.list.setCellRenderer(this.comboBox.getRenderer());
                this.list.setSelectionMode(0);
                this.setListSelection(this.comboBox.getSelectedIndex());
                this.installListListeners();
            }

            @Override
            @NotNull
            protected JScrollPane createScroller() {
                StyleId.comboboxPopup.at(this.comboBox).set(this);
                WebScrollPane scroll = new WebScrollPane(StyleId.comboboxPopupScrollPane.at(this), this.list);
                scroll.setHorizontalScrollBar(null);
                StyleId.comboboxPopupList.at(scroll).set(this.list);
                return scroll;
            }

            @Override
            protected void configureScroller() {
                this.scroller.setFocusable(false);
                this.scroller.getVerticalScrollBar().setFocusable(false);
            }

            @Override
            protected void configurePopup() {
                this.setOpaque(false);
                this.setDoubleBuffered(true);
                this.setFocusable(false);
                this.setLayout(new BorderLayout());
                this.add(this.scroller);
            }

            @Override
            public void show() {
                this.comboBox.firePopupMenuWillBecomeVisible();
                this.setListSelection(this.comboBox.getSelectedIndex());
                Point location = this.getPopupLocation();
                this.show(this.comboBox, location.x, location.y);
            }

            private void setListSelection(int index) {
                if (index == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectedIndex(index);
                    this.list.ensureIndexIsVisible(index);
                }
            }

            @NotNull
            private Point getPopupLocation() {
                this.setPreferredSize(null);
                SizeMethodsImpl.setPreferredWidth(this.list, -1);
                this.list.setVisibleRowCount(MathUtils.limit(1, this.list.getModel().getSize(), this.comboBox.getMaximumRowCount()));
                Dimension ps = this.getPreferredSize();
                Boolean widePopup = WebComboBox.WIDE_POPUP.get(this.comboBox);
                int width = widePopup != false ? Math.max(this.comboBox.getWidth(), ps.width) : this.comboBox.getWidth();
                int height = ps.height;
                Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getHeight(), width, height);
                SizeMethodsImpl.setPreferredWidth(this.list, 0);
                this.setPreferredSize(new Dimension(width, height));
                return popupBounds.getLocation();
            }

            @Override
            protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                Rectangle screenBounds;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
                Point p = new Point();
                SwingUtilities.convertPointFromScreen(p, this.comboBox);
                if (gc != null) {
                    Insets screenInsets = toolkit.getScreenInsets(gc);
                    screenBounds = gc.getBounds();
                    screenBounds.width -= screenInsets.left + screenInsets.right;
                    screenBounds.height -= screenInsets.top + screenInsets.bottom;
                    screenBounds.x += p.x + screenInsets.left;
                    screenBounds.y += p.y + screenInsets.top;
                } else {
                    screenBounds = new Rectangle(p, toolkit.getScreenSize());
                }
                Rectangle rect = new Rectangle(px, py, pw, ph);
                if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
                    rect.y = -rect.height;
                }
                return rect;
            }
        };
    }

    @Override
    public JList getListBox() {
        return this.listBox;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this, new ComboBoxPaintParameters(this.currentValuePane));
    }

    @Override
    @NotNull
    protected LayoutManager createLayoutManager() {
        return new WebComboBoxLayout();
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@NotNull JComponent c) {
        Dimension minimumSize;
        if (this.isMinimumSizeDirty) {
            Dimension size = this.getDisplaySize();
            Insets insets = this.getInsets();
            size.height += insets.top + insets.bottom;
            size.width += insets.left + insets.right;
            if (this.arrowButton != null && this.arrowButton.isVisible()) {
                size.width += this.arrowButton.getPreferredSize().width;
                if (this.separator != null && this.separator.isVisible()) {
                    size.width += this.separator.getPreferredSize().width;
                }
            }
            this.cachedMinimumSize.setSize(size.width, size.height);
            this.isMinimumSizeDirty = false;
            minimumSize = new Dimension(size);
        } else {
            minimumSize = new Dimension(this.cachedMinimumSize);
        }
        return minimumSize;
    }

    @Override
    @NotNull
    protected Dimension getDefaultSize() {
        return this.getSizeForComponent(WebComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false));
    }

    @Override
    @NotNull
    protected Dimension getSizeForComponent(@NotNull Component c) {
        this.currentValuePane.add(c);
        c.setFont(this.comboBox.getFont());
        Dimension d = c.getPreferredSize();
        this.currentValuePane.remove(c);
        return d;
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), true);
    }

    @Override
    @NotNull
    protected Rectangle rectangleForCurrentValue() {
        return this.getValueBounds();
    }

    @Override
    @NotNull
    public Rectangle getValueBounds() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
        int side = 0;
        if (this.arrowButton != null && this.arrowButton.isVisible()) {
            side += this.arrowButton.getPreferredSize().width;
            if (this.separator != null && this.separator.isVisible()) {
                side += this.separator.getPreferredSize().width;
            }
        }
        return new Rectangle(ltr ? i.left : i.left + side, i.top, width - i.left - i.right - side, height - i.top - i.bottom);
    }

    @NotNull
    public Rectangle getSeparatorBounds() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
        int sep = this.separator.getPreferredSize().width;
        int button = 0;
        if (this.arrowButton != null && this.arrowButton.isVisible()) {
            button += this.arrowButton.getPreferredSize().width;
        }
        return new Rectangle(ltr ? width - i.right - button - sep : i.left + button, i.top, sep, height - i.top - i.bottom);
    }

    @NotNull
    public Rectangle getArrowButtonBounds() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
        int button = this.arrowButton.getPreferredSize().width;
        return new Rectangle(ltr ? width - i.right - button : i.left, i.top, button, height - i.top - i.bottom);
    }

    @Override
    public void addEditor() {
        super.addEditor();
        this.fireEditabilityChanged(true);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        this.editor.applyComponentOrientation(this.comboBox.getComponentOrientation());
    }

    @Override
    public void removeEditor() {
        super.removeEditor();
        this.fireEditabilityChanged(false);
    }

    @Override
    public void addEditabilityListener(@NotNull EditabilityListener listener) {
        this.listenerList.add(EditabilityListener.class, listener);
    }

    @Override
    public void removeEditabilityListener(@NotNull EditabilityListener listener) {
        this.listenerList.remove(EditabilityListener.class, listener);
    }

    public void fireEditabilityChanged(boolean editable) {
        for (EditabilityListener listener : (EditabilityListener[])this.listenerList.getListeners(EditabilityListener.class)) {
            listener.editabilityChanged(editable);
        }
    }

    @Override
    public void addPopupVisibilityListener(@NotNull VisibilityListener listener) {
        this.listenerList.add(VisibilityListener.class, listener);
    }

    @Override
    public void removePopupVisibilityListener(@NotNull VisibilityListener listener) {
        this.listenerList.remove(VisibilityListener.class, listener);
    }

    public void firePopupVisibilityChanged(boolean visible) {
        for (VisibilityListener listener : (VisibilityListener[])this.listenerList.getListeners(VisibilityListener.class)) {
            listener.visibilityChanged(visible);
        }
    }

    @NotNull
    protected static ListCellRenderer getDefaultListCellRenderer() {
        if (DEFAULT_RENDERER == null) {
            DEFAULT_RENDERER = new WebComboBoxRenderer.UIResource();
        }
        return DEFAULT_RENDERER;
    }

    public class ComboBoxButton
    extends WebButton
    implements Stateful,
    EditabilityListener,
    VisibilityListener {
        public ComboBoxButton() {
            super(StyleId.comboboxArrowButton.at(WebComboBoxUI.this.comboBox));
            this.setName("ComboBox.arrowButton");
        }

        public void install() {
            WebComboBoxUI.this.addEditabilityListener(this);
            WebComboBoxUI.this.addPopupVisibilityListener(this);
        }

        public void uninstall() {
            WebComboBoxUI.this.removePopupVisibilityListener(this);
            WebComboBoxUI.this.removeEditabilityListener(this);
        }

        @Override
        public void setFocusable(boolean focusable) {
            super.setFocusable(false);
        }

        @Override
        public void visibilityChanged(boolean visible) {
            DecorationUtils.fireStatesChanged(this);
        }

        @Override
        public void editabilityChanged(boolean editable) {
            DecorationUtils.fireStatesChanged(this);
        }

        @Override
        @NotNull
        public List<String> getStates() {
            ArrayList<String> states = new ArrayList<String>(1);
            if (WebComboBoxUI.this.comboBox.isEditable()) {
                states.add("editable");
            }
            states.add(WebComboBoxUI.this.isPopupVisible(WebComboBoxUI.this.comboBox) ? "expanded" : "collapsed");
            return states;
        }
    }

    public class ComboBoxSeparator
    extends WebSeparator
    implements Stateful,
    EditabilityListener,
    VisibilityListener {
        public ComboBoxSeparator() {
            super(StyleId.comboboxSeparator.at(WebComboBoxUI.this.comboBox), 0);
        }

        public void install() {
            WebComboBoxUI.this.addEditabilityListener(this);
            WebComboBoxUI.this.addPopupVisibilityListener(this);
        }

        public void uninstall() {
            WebComboBoxUI.this.removePopupVisibilityListener(this);
            WebComboBoxUI.this.removeEditabilityListener(this);
        }

        @Override
        public void visibilityChanged(boolean visible) {
            DecorationUtils.fireStatesChanged(this);
        }

        @Override
        public void editabilityChanged(boolean editable) {
            DecorationUtils.fireStatesChanged(this);
        }

        @Override
        @Nullable
        public List<String> getStates() {
            ArrayList<String> states = new ArrayList<String>(1);
            if (WebComboBoxUI.this.comboBox.isEditable()) {
                states.add("editable");
            }
            states.add(WebComboBoxUI.this.isPopupVisible(WebComboBoxUI.this.comboBox) ? "expanded" : "collapsed");
            return states;
        }
    }

    protected class WebComboBoxLayout
    extends AbstractLayoutManager {
        protected WebComboBoxLayout() {
        }

        @Override
        public void layoutContainer(@NotNull Container container) {
            if (WebComboBoxUI.this.arrowButton != null && WebComboBoxUI.this.arrowButton.isVisible()) {
                WebComboBoxUI.this.arrowButton.setBounds(WebComboBoxUI.this.getArrowButtonBounds());
                if (WebComboBoxUI.this.separator != null && WebComboBoxUI.this.separator.isVisible()) {
                    WebComboBoxUI.this.separator.setBounds(WebComboBoxUI.this.getSeparatorBounds());
                }
            }
            if (WebComboBoxUI.this.editor != null) {
                WebComboBoxUI.this.editor.setBounds(WebComboBoxUI.this.getValueBounds());
            }
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@NotNull Container container) {
            return container.getMinimumSize();
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container container) {
            return container.getPreferredSize();
        }
    }
}

