/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.desktoppane.DesktopIconInputListener;
import com.alee.laf.desktoppane.WDesktopIconUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class WDesktopIconInputListener<C extends JInternalFrame.JDesktopIcon, U extends WDesktopIconUI<C>>
extends AbstractUIInputListener<C, U>
implements DesktopIconInputListener<C>,
MouseListener,
MouseMotionListener {
    protected int absX;
    protected int absY;
    protected int relX;
    protected int relY;
    protected Rectangle startingBounds;

    @Override
    public void install(@NotNull C component2) {
        super.install(component2);
        ((Component)component2).addMouseListener(this);
        ((Component)component2).addMouseMotionListener(this);
    }

    @Override
    public void uninstall(@NotNull C component2) {
        ((Component)component2).removeMouseMotionListener(this);
        ((Component)component2).removeMouseListener(this);
        super.uninstall(component2);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JInternalFrame internalFrame;
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        this.relX = e.getX();
        this.relY = e.getY();
        this.absX = p.x;
        this.absY = p.y;
        this.startingBounds = ((JInternalFrame.JDesktopIcon)this.component).getBounds();
        JDesktopPane desktop = ((JInternalFrame.JDesktopIcon)this.component).getDesktopPane();
        if (desktop != null) {
            DesktopManager dm = desktop.getDesktopManager();
            dm.beginDraggingFrame(this.component);
        }
        try {
            ((JInternalFrame.JDesktopIcon)this.component).getInternalFrame().setSelected(true);
        }
        catch (PropertyVetoException dm) {
            // empty catch block
        }
        if (((JInternalFrame.JDesktopIcon)this.component).getParent() instanceof JLayeredPane) {
            JLayeredPane layeredPane = (JLayeredPane)((JInternalFrame.JDesktopIcon)this.component).getParent();
            layeredPane.moveToFront(this.component);
        }
        if (e.getClickCount() > 1 && (internalFrame = ((JInternalFrame.JDesktopIcon)this.component).getInternalFrame()).isIconifiable() && internalFrame.isIcon()) {
            try {
                internalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.absX = 0;
        this.absY = 0;
        this.relX = 0;
        this.relY = 0;
        this.startingBounds = null;
        JDesktopPane desktop = ((JInternalFrame.JDesktopIcon)this.component).getDesktopPane();
        if (desktop != null) {
            DesktopManager dm = desktop.getDesktopManager();
            dm.endDraggingFrame(this.component);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startingBounds != null) {
            JDesktopPane desktop;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            Insets i = ((JInternalFrame.JDesktopIcon)this.component).getInsets();
            int pWidth = ((JInternalFrame.JDesktopIcon)this.component).getParent().getWidth();
            int pHeight = ((JInternalFrame.JDesktopIcon)this.component).getParent().getHeight();
            int newX = this.startingBounds.x - (this.absX - p.x);
            int newY = this.startingBounds.y - (this.absY - p.y);
            if (newX + i.left <= -this.relX) {
                newX = -this.relX - i.left;
            }
            if (newY + i.top <= -this.relY) {
                newY = -this.relY - i.top;
            }
            if (newX + this.relX + i.right > pWidth) {
                newX = pWidth - this.relX - i.right;
            }
            if (newY + this.relY + i.bottom > pHeight) {
                newY = pHeight - this.relY - i.bottom;
            }
            if ((desktop = ((JInternalFrame.JDesktopIcon)this.component).getDesktopPane()) != null) {
                DesktopManager dm = desktop.getDesktopManager();
                dm.dragFrame(this.component, newX, newY);
            } else {
                int newWidth = ((JInternalFrame.JDesktopIcon)this.component).getWidth();
                int newHeight = ((JInternalFrame.JDesktopIcon)this.component).getHeight();
                Rectangle bounds = ((JInternalFrame.JDesktopIcon)this.component).getBounds();
                ((JInternalFrame.JDesktopIcon)this.component).setBounds(newX, newY, newWidth, newHeight);
                SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, bounds);
                ((JInternalFrame.JDesktopIcon)this.component).getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

