/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.edt;

import com.alee.api.annotations.NotNull;
import com.alee.laf.edt.NonEventThreadHandler;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PackageFilteringNonEventThreadHandler
implements NonEventThreadHandler {
    @NotNull
    protected final List<String> packages;
    @NotNull
    protected final Map<String, Long> occurred;

    public PackageFilteringNonEventThreadHandler(String ... packages2) {
        this.packages = CollectionUtils.asList(packages2);
        this.occurred = new HashMap<String, Long>(1);
    }

    @Override
    public void handle(@NotNull RuntimeException e) {
        String key = this.getKey(e);
        long count = !this.occurred.containsKey(key) ? 1L : this.occurred.get(key) + 1L;
        this.occurred.put(key, count);
        this.handle(e, count);
    }

    @NotNull
    protected String getKey(@NotNull RuntimeException e) {
        String result2;
        if (this.packages.size() > 0) {
            ArrayList<StackTraceElement> stackTrace = CollectionUtils.asList(e.getStackTrace());
            Iterator iterator = stackTrace.iterator();
            while (iterator.hasNext()) {
                StackTraceElement element = (StackTraceElement)iterator.next();
                boolean accepted = false;
                for (String pkg : this.packages) {
                    if (!element.getClassName().startsWith(pkg)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) continue;
                iterator.remove();
            }
            StringBuilder key = new StringBuilder();
            for (StackTraceElement element : stackTrace) {
                key.append(element.toString());
            }
            result2 = FileUtils.computeMD5(key.toString());
        } else {
            result2 = "none";
        }
        return result2;
    }

    protected abstract void handle(@NotNull RuntimeException var1, long var2);
}

