/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.filechooser.WFileChooserUI;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.Customizer;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class WebFileChooser
extends JFileChooser
implements Styleable,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebFileChooser>,
SizeMethods<WebFileChooser> {
    @Nullable
    protected List<Image> customIcons = null;

    public WebFileChooser() {
        this(StyleId.auto);
    }

    public WebFileChooser(String dirPath) {
        this(StyleId.auto, dirPath);
    }

    public WebFileChooser(File dir) {
        this(StyleId.auto, dir);
    }

    public WebFileChooser(FileSystemView fsv) {
        this(StyleId.auto, fsv);
    }

    public WebFileChooser(File dir, FileSystemView fsv) {
        this(StyleId.auto, dir, fsv);
    }

    public WebFileChooser(String dirPath, FileSystemView fsv) {
        this(StyleId.auto, dirPath, fsv);
    }

    public WebFileChooser(StyleId id) {
        this(id, FileUtils.getUserHomePath(), null);
    }

    public WebFileChooser(StyleId id, String dirPath) {
        this(id, dirPath, null);
    }

    public WebFileChooser(StyleId id, File dir) {
        this(id, dir, null);
    }

    public WebFileChooser(StyleId id, FileSystemView fsv) {
        this(id, (File)null, fsv);
    }

    public WebFileChooser(StyleId id, File dir, FileSystemView fsv) {
        super(dir, fsv);
        this.setStyleId(id);
    }

    public WebFileChooser(StyleId id, String dirPath, FileSystemView fsv) {
        super(dirPath, fsv);
        this.setStyleId(id);
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        if (this.customIcons != null) {
            dialog.setIconImages(this.customIcons);
        }
        return dialog;
    }

    @Nullable
    public Image getDialogIcon() {
        return this.customIcons != null && this.customIcons.size() > 0 ? this.customIcons.get(0) : null;
    }

    @Nullable
    public List<Image> getDialogIcons() {
        return this.customIcons;
    }

    public void setDialogIcon(@Nullable Icon icon) {
        this.setDialogImage(ImageUtils.toBufferedImage(icon));
    }

    public void setDialogImage(@Nullable Image icon) {
        this.setDialogImages(CollectionUtils.asList(icon));
    }

    public void setDialogIcons(@NotNull List<? extends Icon> customIcons) {
        this.customIcons = new ArrayList<Image>(customIcons.size());
        for (Icon icon : customIcons) {
            BufferedImage image = ImageUtils.toBufferedImage(icon);
            this.customIcons.add(image);
        }
        this.updateWindowIcons();
    }

    public void setDialogImages(@NotNull List<? extends Image> customIcons) {
        this.customIcons = new ArrayList<Image>(customIcons);
        this.updateWindowIcons();
    }

    protected void updateWindowIcons() {
        Window window = CoreSwingUtils.getWindowAncestor(this);
        if (window != null && window instanceof JDialog) {
            window.setIconImages(this.customIcons);
        }
    }

    public void setDialogTitleKey(String dialogTitle) {
        this.setLanguage(dialogTitle, new Object[0]);
    }

    public void setCurrentDirectory(String path) {
        this.setCurrentDirectory(path != null ? new File(path) : null);
    }

    public void setSelectedFile(String path) {
        this.setSelectedFile(path != null ? new File(path) : null);
    }

    public WebFileChooserPanel getFileChooserPanel() {
        return this.getUI().getFileChooserPanel();
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.filechooser;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this);
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebFileChooser setPlainFont() {
        return (WebFileChooser)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebFileChooser setPlainFont(boolean apply2) {
        return (WebFileChooser)FontMethodsImpl.setPlainFont(this, apply2);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebFileChooser setBoldFont() {
        return (WebFileChooser)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebFileChooser setBoldFont(boolean apply2) {
        return (WebFileChooser)FontMethodsImpl.setBoldFont(this, apply2);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebFileChooser setItalicFont() {
        return (WebFileChooser)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebFileChooser setItalicFont(boolean apply2) {
        return (WebFileChooser)FontMethodsImpl.setItalicFont(this, apply2);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebFileChooser setFontStyle(boolean bold, boolean italic) {
        return (WebFileChooser)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebFileChooser setFontStyle(int style) {
        return (WebFileChooser)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebFileChooser setFontSize(int fontSize) {
        return (WebFileChooser)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebFileChooser changeFontSize(int change) {
        return (WebFileChooser)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebFileChooser setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebFileChooser)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebFileChooser setFontSizeAndStyle(int fontSize, int style) {
        return (WebFileChooser)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebFileChooser setFontName(String fontName) {
        return (WebFileChooser)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebFileChooser setPreferredWidth(int preferredWidth) {
        return (WebFileChooser)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebFileChooser setPreferredHeight(int preferredHeight) {
        return (WebFileChooser)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebFileChooser setPreferredSize(int width, int height) {
        return (WebFileChooser)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebFileChooser setMaximumWidth(int maximumWidth) {
        return (WebFileChooser)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebFileChooser setMaximumHeight(int maximumHeight) {
        return (WebFileChooser)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebFileChooser setMaximumSize(int width, int height) {
        return (WebFileChooser)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebFileChooser setMinimumWidth(int minimumWidth) {
        return (WebFileChooser)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebFileChooser setMinimumHeight(int minimumHeight) {
        return (WebFileChooser)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebFileChooser setMinimumSize(int width, int height) {
        return (WebFileChooser)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WFileChooserUI getUI() {
        return (WFileChooserUI)super.getUI();
    }

    public void setUI(WFileChooserUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }

    public static File showOpenDialog() {
        return WebFileChooser.showOpenDialog(null, null, null);
    }

    public static File showOpenDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(null, null, customizer);
    }

    public static File showOpenDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(parent, null, customizer);
    }

    public static File showOpenDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(null, currentDirectory, customizer);
    }

    public static File showOpenDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showOpenDialog(parent, currentDirectory, null);
    }

    public static File showOpenDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(false);
        if (customizer != null) {
            customizer.customize(fileChooser);
        }
        return fileChooser.showOpenDialog(parent) == 0 ? fileChooser.getSelectedFile() : null;
    }

    public static List<File> showMultiOpenDialog() {
        return WebFileChooser.showMultiOpenDialog(null, null, null);
    }

    public static List<File> showMultiOpenDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(null, null, customizer);
    }

    public static List<File> showMultiOpenDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(parent, null, customizer);
    }

    public static List<File> showMultiOpenDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(null, currentDirectory, customizer);
    }

    public static List<File> showMultiOpenDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showMultiOpenDialog(parent, currentDirectory, null);
    }

    public static List<File> showMultiOpenDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        if (customizer != null) {
            customizer.customize(fileChooser);
        }
        return fileChooser.showOpenDialog(parent) == 0 ? CollectionUtils.toList(fileChooser.getSelectedFiles()) : null;
    }

    public static File showSaveDialog() {
        return WebFileChooser.showSaveDialog(null, null, null);
    }

    public static File showSaveDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(null, null, customizer);
    }

    public static File showSaveDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(parent, null, customizer);
    }

    public static File showSaveDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(null, currentDirectory, customizer);
    }

    public static File showSaveDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showSaveDialog(parent, currentDirectory, null);
    }

    public static File showSaveDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        if (customizer != null) {
            customizer.customize(fileChooser);
        }
        return fileChooser.showSaveDialog(parent) == 0 ? fileChooser.getSelectedFile() : null;
    }
}

