/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.laf.label.LabelInputListener;
import com.alee.laf.label.WLabelUI;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;

public class WLabelInputListener<C extends JLabel, U extends WLabelUI<C>>
extends AbstractUIInputListener<C, U>
implements LabelInputListener<C>,
PropertyChangeListener {
    @Override
    public void install(@NotNull C component2) {
        super.install(component2);
        ((Container)component2).addPropertyChangeListener(this);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Action<C>(component2, "press"));
        actionMap.put(new Action<C>(component2, "release"));
        SwingUtilities.replaceUIActionMap(component2, actionMap);
        this.installInputMap(component2);
    }

    @Override
    public void uninstall(@NotNull C component2) {
        SwingUtilities.replaceUIInputMap(component2, 2, null);
        SwingUtilities.replaceUIInputMap(component2, 0, null);
        SwingUtilities.replaceUIActionMap(component2, null);
        ((Component)component2).removePropertyChangeListener(this);
        super.uninstall(component2);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (Objects.equals((Object)prop, "displayedMnemonic", "labelFor")) {
            this.installInputMap((JLabel)e.getSource());
        }
    }

    protected void installInputMap(@NotNull C label) {
        int mnemonic = ((JLabel)label).getDisplayedMnemonic();
        Component labelFor = ((JLabel)label).getLabelFor();
        if (mnemonic != 0 && labelFor != null) {
            InputMap inputMap = SwingUtilities.getUIInputMap(label, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource((JComponent)label);
                SwingUtilities.replaceUIInputMap(label, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(mnemonic, 8, false), "press");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(label, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    public static class Action<L extends JLabel>
    extends UIAction<L> {
        public static final String PRESS = "press";
        public static final String RELEASE = "release";

        public Action(@NotNull L label, @NotNull String name) {
            super(label, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JLabel label = (JLabel)e.getSource();
            String key = this.getName();
            if (Objects.equals((Object)key, (Object)PRESS)) {
                this.doPress(label);
            } else if (Objects.equals((Object)key, (Object)RELEASE)) {
                this.doRelease(label);
            }
        }

        protected void doPress(L label) {
            Component labelFor = ((JLabel)label).getLabelFor();
            if (labelFor != null && labelFor.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(label, 0);
                if (inputMap == null) {
                    inputMap = new InputMapUIResource();
                    SwingUtilities.replaceUIInputMap(label, 0, inputMap);
                }
                int mnemonic = ((JLabel)label).getDisplayedMnemonic();
                inputMap.put(KeyStroke.getKeyStroke(mnemonic, 8, true), RELEASE);
                inputMap.put(KeyStroke.getKeyStroke(18, 0, true), RELEASE);
                ((JComponent)label).requestFocus();
            }
        }

        protected void doRelease(L label) {
            Component labelFor = ((JLabel)label).getLabelFor();
            if (labelFor != null && labelFor.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(label, 0);
                if (inputMap != null) {
                    inputMap.remove(KeyStroke.getKeyStroke(((JLabel)label).getDisplayedMnemonic(), 8, true));
                    inputMap.remove(KeyStroke.getKeyStroke(18, 0, true));
                }
                if (labelFor instanceof Container && ((Container)labelFor).isFocusCycleRoot()) {
                    labelFor.requestFocus();
                } else {
                    SwingUtils.compositeRequestFocus(labelFor);
                }
            }
        }
    }
}

