/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.label;

import com.alee.api.annotations.NotNull;
import com.alee.laf.WebUI;
import com.alee.laf.label.LabelInputListener;
import com.alee.laf.label.WLabelInputListener;
import com.alee.utils.LafUtils;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;

public abstract class WLabelUI<C extends JLabel>
extends LabelUI
implements WebUI<C> {
    protected LabelInputListener<C> inputListener;
    protected C label;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "Label.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.label = (JLabel)c;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.label = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.label, this.getPropertyPrefix());
    }

    protected void uninstallDefaults() {
        LafUtils.uninstallDefaults(this.label);
    }

    protected void installListeners() {
        this.inputListener = this.createLabelInputListener();
        this.inputListener.install(this.label);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.label);
        this.inputListener = null;
    }

    protected LabelInputListener<C> createLabelInputListener() {
        return new WLabelInputListener();
    }
}

