/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.list.IListItemPainter;
import com.alee.laf.list.IListPainter;
import com.alee.laf.list.IListSelectionPainter;
import com.alee.laf.list.ListItemPainter;
import com.alee.laf.list.ListPaintParameters;
import com.alee.laf.list.ListSelectionPainter;
import com.alee.laf.list.ListSelectionStyle;
import com.alee.laf.list.WListUI;
import com.alee.laf.list.WebListModel;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageSensitive;
import com.alee.managers.language.UILanguageManager;
import com.alee.painter.DefaultPainter;
import com.alee.painter.PainterException;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.IDecorationPainter;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.CellRendererPane;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListPainter<C extends JList, U extends WListUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements IListPainter<C, U> {
    @DefaultPainter(value=ListItemPainter.class)
    protected IListItemPainter itemPainter;
    @DefaultPainter(value=ListSelectionPainter.class)
    protected IListSelectionPainter selectionPainter;
    protected transient ListSelectionListener listSelectionListener;
    protected transient LanguageListener languageSensitive;
    protected transient ListPaintParameters paintParameters;
    protected transient CellRendererPane rendererPane;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.itemPainter, this.selectionPainter);
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installListSelectionListeners();
        this.installLanguageListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallLanguageListeners();
        this.uninstallListSelectionListeners();
        this.uninstallRuntimeVariables();
        super.uninstallPropertiesAndListeners();
    }

    protected void installListSelectionListeners() {
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ListPainter.this.component != null) {
                    ListPainter.this.repaintSelection();
                }
            }
        };
        ((JList)this.component).addListSelectionListener(this.listSelectionListener);
    }

    protected void uninstallListSelectionListeners() {
        ((JList)this.component).removeListSelectionListener(this.listSelectionListener);
        this.listSelectionListener = null;
    }

    protected void installLanguageListeners() {
        this.languageSensitive = new LanguageListener(){

            @Override
            public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                ListModel model;
                if (ListPainter.this.isLanguageSensitive() && (model = ((JList)ListPainter.this.component).getModel()).getSize() > 0) {
                    if (model instanceof WebListModel) {
                        ((WebListModel)model).fireContentsChanged(ListPainter.this, 0, model.getSize());
                    } else if (model instanceof AbstractListModel) {
                        try {
                            ReflectUtils.callMethod(model, "fireContentsChanged", ListPainter.this, 0, model.getSize());
                        }
                        catch (Exception e) {
                            throw new PainterException("Unable to fire list content changes", e);
                        }
                    } else {
                        ((JList)ListPainter.this.component).repaint();
                    }
                }
            }
        };
        UILanguageManager.addLanguageListener(this.component, this.languageSensitive);
    }

    protected boolean isLanguageSensitive() {
        boolean sensitive = false;
        if (this.component instanceof LanguageSensitive || ((JList)this.component).getCellRenderer() instanceof LanguageSensitive || ((JList)this.component).getModel() instanceof LanguageSensitive) {
            sensitive = true;
        } else {
            ListModel model = ((JList)this.component).getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!(model.getElementAt(i) instanceof LanguageSensitive)) continue;
                sensitive = true;
                break;
            }
        }
        return sensitive;
    }

    protected void uninstallLanguageListeners() {
        UILanguageManager.removeLanguageListener(this.component, this.languageSensitive);
        this.languageSensitive = null;
    }

    protected void uninstallRuntimeVariables() {
        this.paintParameters = null;
    }

    @Override
    public boolean isItemHoverDecorationSupported() {
        boolean supported = false;
        if (this.component != null && ((JList)this.component).isEnabled() && this.itemPainter != null && this.itemPainter instanceof IDecorationPainter) {
            supported = ((IDecorationPainter)((Object)this.itemPainter)).usesState("hover");
        }
        return supported;
    }

    @Override
    public void prepareToPaint(@NotNull ListPaintParameters parameters) {
        this.paintParameters = parameters;
    }

    @Override
    public void cleanupAfterPaint() {
        this.paintParameters = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.paintBackground(g2d);
        this.paintSelectedCellsBackground(g2d);
        this.paintList(g2d);
        this.paintDropLocation(g2d);
    }

    protected void paintBackground(@NotNull Graphics2D g2d) {
        if (this.itemPainter != null) {
            Shape clip = g2d.getClip();
            ListModel dataModel = ((JList)this.component).getModel();
            int size = dataModel.getSize();
            if (size > 0) {
                int endColumn;
                int startColumn;
                Rectangle paintBounds = g2d.getClipBounds();
                if (this.ltr) {
                    startColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
                    endColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
                } else {
                    startColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
                    endColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
                }
                int maxY = paintBounds.y + paintBounds.height;
                int rowIncrement = ((JList)this.component).getLayoutOrientation() == 2 ? this.paintParameters.columnCount : 1;
                for (int colCounter = startColumn; colCounter <= endColumn; ++colCounter) {
                    int row;
                    int rowCount = this.getRowCount(colCounter);
                    int index = this.getModelIndex(colCounter, row);
                    Rectangle rowBounds = ((WListUI)this.ui).getCellBounds((JList)this.component, index, index);
                    if (rowBounds == null) break;
                    for (row = this.convertLocationToRowInColumn(paintBounds.y, colCounter); row < rowCount && rowBounds.y < maxY && index < size; index += rowIncrement, ++row) {
                        rowBounds.height = this.getHeight(colCounter, row);
                        g2d.setClip(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
                        g2d.clipRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                        this.itemPainter.prepareToPaint(index);
                        this.paintSection(this.itemPainter, g2d, rowBounds);
                        rowBounds.y += rowBounds.height;
                    }
                }
            }
            g2d.setClip(clip);
        }
    }

    protected void paintSelectedCellsBackground(Graphics2D g2d) {
        if (this.selectionPainter != null && ((JList)this.component).getSelectedIndex() != -1 && ((WListUI)this.ui).getSelectionStyle() != ListSelectionStyle.none) {
            List<Rectangle> selections = this.getSelectionRects();
            for (Rectangle bounds : selections) {
                this.paintSection(this.selectionPainter, g2d, bounds);
            }
        }
    }

    protected void paintList(@NotNull Graphics2D g2d) {
        this.rendererPane = ((WListUI)this.ui).getCellRendererPane();
        ListCellRenderer renderer = ((JList)this.component).getCellRenderer();
        ListModel dataModel = ((JList)this.component).getModel();
        int size = dataModel.getSize();
        if (renderer != null && size > 0) {
            int endColumn;
            int startColumn;
            Shape clip = g2d.getClip();
            Rectangle paintBounds = g2d.getClipBounds();
            if (this.ltr) {
                startColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
                endColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
            } else {
                startColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
                endColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
            }
            int maxY = paintBounds.y + paintBounds.height;
            int leadIndex = this.adjustIndex(((JList)this.component).getLeadSelectionIndex(), (JList)this.component);
            int rowIncrement = ((JList)this.component).getLayoutOrientation() == 2 ? this.paintParameters.columnCount : 1;
            ListSelectionModel selModel = ((JList)this.component).getSelectionModel();
            for (int colCounter = startColumn; colCounter <= endColumn; ++colCounter) {
                int row;
                int rowCount = this.getRowCount(colCounter);
                int index = this.getModelIndex(colCounter, row);
                Rectangle rowBounds = ((WListUI)this.ui).getCellBounds((JList)this.component, index, index);
                if (rowBounds == null) break;
                for (row = this.convertLocationToRowInColumn(paintBounds.y, colCounter); row < rowCount && rowBounds.y < maxY && index < size; index += rowIncrement, ++row) {
                    rowBounds.height = this.getHeight(colCounter, row);
                    g2d.setClip(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
                    g2d.clipRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                    this.paintCell(g2d, index, rowBounds, renderer, dataModel, selModel, leadIndex);
                    rowBounds.y += rowBounds.height;
                }
            }
            g2d.setClip(clip);
        }
        this.rendererPane.removeAll();
        this.rendererPane = null;
    }

    protected void paintCell(Graphics2D g2d, int index, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(index);
        boolean isSelected = selModel.isSelectedIndex(index);
        boolean cellHasFocus = ((JList)this.component).hasFocus() && index == leadIndex;
        Component renderer = cellRenderer.getListCellRendererComponent((JList)this.component, value, index, isSelected, cellHasFocus);
        this.rendererPane.paintComponent(g2d, renderer, this.component, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
    }

    protected int getHeight(int column, int row) {
        if (column < 0 || column > this.paintParameters.columnCount || row < 0) {
            return -1;
        }
        if (((JList)this.component).getLayoutOrientation() != 0) {
            return this.paintParameters.cellHeight;
        }
        if (row >= ((JList)this.component).getModel().getSize()) {
            return -1;
        }
        return this.paintParameters.cellHeights == null ? this.paintParameters.cellHeight : (row < this.paintParameters.cellHeights.length ? this.paintParameters.cellHeights[row] : -1);
    }

    protected int getModelIndex(int column, int row) {
        switch (((JList)this.component).getLayoutOrientation()) {
            case 1: {
                return Math.min(((JList)this.component).getModel().getSize() - 1, this.paintParameters.rowsPerColumn * column + Math.min(row, this.paintParameters.rowsPerColumn - 1));
            }
            case 2: {
                return Math.min(((JList)this.component).getModel().getSize() - 1, row * this.paintParameters.columnCount + column);
            }
        }
        return row;
    }

    protected int getRowCount(int column) {
        if (column < 0 || column >= this.paintParameters.columnCount) {
            return -1;
        }
        if (((JList)this.component).getLayoutOrientation() == 0 || column == 0 && this.paintParameters.columnCount == 1) {
            return ((JList)this.component).getModel().getSize();
        }
        if (column >= this.paintParameters.columnCount) {
            return -1;
        }
        if (((JList)this.component).getLayoutOrientation() == 1) {
            if (column < this.paintParameters.columnCount - 1) {
                return this.paintParameters.rowsPerColumn;
            }
            return ((JList)this.component).getModel().getSize() - (this.paintParameters.columnCount - 1) * this.paintParameters.rowsPerColumn;
        }
        int diff = this.paintParameters.columnCount - (this.paintParameters.columnCount * this.paintParameters.rowsPerColumn - ((JList)this.component).getModel().getSize());
        if (column >= diff) {
            return Math.max(0, this.paintParameters.rowsPerColumn - 1);
        }
        return this.paintParameters.rowsPerColumn;
    }

    protected int convertLocationToRowInColumn(int y, int column) {
        int x = 0;
        if (((JList)this.component).getLayoutOrientation() != 0) {
            x = this.ltr ? column * this.paintParameters.cellWidth : ((JList)this.component).getWidth() - (column + 1) * this.paintParameters.cellWidth - ((JList)this.component).getInsets().right;
        }
        return this.convertLocationToRow(x, y, true);
    }

    protected int convertLocationToRow(int x, int y0, boolean closest) {
        int i;
        int size = ((JList)this.component).getModel().getSize();
        if (size <= 0) {
            return -1;
        }
        Insets insets = ((JList)this.component).getInsets();
        if (this.paintParameters.cellHeights == null) {
            int row;
            int n = row = this.paintParameters.cellHeight == 0 ? 0 : (y0 - insets.top) / this.paintParameters.cellHeight;
            if (closest) {
                if (row < 0) {
                    row = 0;
                } else if (row >= size) {
                    row = size - 1;
                }
            }
            return row;
        }
        if (size > this.paintParameters.cellHeights.length) {
            return -1;
        }
        int y = insets.top;
        int row = 0;
        if (closest && y0 < y) {
            return 0;
        }
        for (i = 0; i < size; ++i) {
            if (y0 >= y && y0 < y + this.paintParameters.cellHeights[i]) {
                return row;
            }
            y += this.paintParameters.cellHeights[i];
            ++row;
        }
        return i - 1;
    }

    protected int convertLocationToColumn(int x, int y) {
        if (this.paintParameters.cellWidth > 0) {
            if (((JList)this.component).getLayoutOrientation() == 0) {
                return 0;
            }
            Insets insets = ((JList)this.component).getInsets();
            int col = this.ltr ? (x - insets.left) / this.paintParameters.cellWidth : (((JList)this.component).getWidth() - x - insets.right - 1) / this.paintParameters.cellWidth;
            if (col < 0) {
                return 0;
            }
            if (col >= this.paintParameters.columnCount) {
                return this.paintParameters.columnCount - 1;
            }
            return col;
        }
        return 0;
    }

    protected int adjustIndex(int index, C list) {
        return index < ((JList)list).getModel().getSize() ? index : -1;
    }

    protected void paintDropLocation(Graphics2D g2d) {
        JList.DropLocation loc = ((JList)this.component).getDropLocation();
        if (loc == null || loc.isInsert()) {
            // empty if block
        }
    }

    protected List<Rectangle> getSelectionRects() {
        if (((WListUI)this.ui).getSelectionStyle() == ListSelectionStyle.none) {
            return Collections.emptyList();
        }
        int[] indices = ((JList)this.component).getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(indices);
        ArrayList<Rectangle> selections = new ArrayList<Rectangle>(indices.length);
        Rectangle maxRect = null;
        int lastRow = -1;
        for (int index : indices) {
            if (((WListUI)this.ui).getSelectionStyle() == ListSelectionStyle.single) {
                selections.add(((JList)this.component).getCellBounds(index, index));
                continue;
            }
            if (lastRow != -1 && lastRow + 1 != index) {
                selections.add(maxRect);
                maxRect = null;
                lastRow = -1;
            }
            if (lastRow != -1 && lastRow + 1 != index) continue;
            Rectangle b = ((JList)this.component).getCellBounds(index, index);
            maxRect = lastRow == -1 ? b : GeometryUtils.getContainingRect(maxRect, b);
            lastRow = index;
        }
        if (maxRect != null) {
            selections.add(maxRect);
        }
        return selections;
    }

    protected void repaintSelection() {
        if (((JList)this.component).getSelectedIndex() != -1) {
            for (Rectangle rect : this.getSelectionRects()) {
                ((JList)this.component).repaint(rect);
            }
        }
    }
}

