/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.list.ListSelectionStyle;
import com.alee.laf.list.ListToolTipProvider;
import com.alee.laf.list.UnselectableListModel;
import com.alee.laf.list.WListUI;
import com.alee.laf.list.WebListModel;
import com.alee.laf.list.behavior.ListHoverSelectionBehavior;
import com.alee.laf.list.behavior.ListSelectionScrollBehavior;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.laf.list.editor.ListEditListener;
import com.alee.laf.list.editor.TextListCellEditor;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.HoverListener;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class WebList
extends JList
implements Styleable,
EventMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebList>,
SizeMethods<WebList> {
    public static final String TOOLTIP_PROVIDER_PROPERTY = "tooltipProvider";
    protected boolean editable = false;
    protected int editedCell = -1;
    protected boolean emptySelectionAllowed = true;
    protected transient ListCellEditor listCellEditor = null;

    public WebList() {
        this(StyleId.auto);
    }

    public WebList(List data) {
        this(StyleId.auto, data);
    }

    public WebList(Vector data) {
        this(StyleId.auto, data);
    }

    public WebList(Object[] data) {
        this(StyleId.auto, data);
    }

    public WebList(ListModel model) {
        this(StyleId.auto, model);
    }

    public WebList(StyleId id) {
        this(id, new WebListModel());
    }

    public WebList(StyleId id, List data) {
        this(id, new WebListModel(data));
    }

    public WebList(StyleId id, Vector data) {
        this(id, new WebListModel(data));
    }

    public WebList(StyleId id, Object[] data) {
        this(id, new WebListModel<Object>(data));
    }

    public WebList(StyleId id, ListModel model) {
        super(model);
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.list;
    }

    public boolean isMultipleSelectionAllowed() {
        return Objects.equals((Object)this.getSelectionMode(), 1, 2);
    }

    public void setMultipleSelectionAllowed(boolean allowed) {
        this.setSelectionMode(allowed ? 2 : 0);
    }

    public void setSelectedValue(Object element) {
        this.setSelectedValue(element, true);
    }

    public void setSelectedValues(Object[] values2) {
        this.setSelectedValues(CollectionUtils.toList(values2));
    }

    public void setSelectedValues(Collection values2) {
        this.setSelectedValues(new ArrayList(values2));
    }

    public void setSelectedValues(List values2) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!values2.contains(model.getElementAt(i))) continue;
            indices.add(i);
        }
        this.setSelectedIndices(CollectionUtils.toIntArray(indices));
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (editable && this.listCellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
    }

    public void setCellEditor(ListCellEditor listCellEditor) {
        this.removeCellEditor();
        this.listCellEditor = listCellEditor;
        listCellEditor.install(this);
    }

    protected ListCellEditor createDefaultCellEditor() {
        return new TextListCellEditor<String>(){

            @Override
            protected String valueToText(JList list, int index, String value) {
                return value;
            }

            @Override
            protected String textToValue(JList list, int index, String oldValue, String text) {
                return text;
            }
        };
    }

    public ListCellEditor getCellEditor() {
        return this.listCellEditor;
    }

    public void removeCellEditor() {
        if (this.listCellEditor != null) {
            this.listCellEditor.uninstall(this);
            this.listCellEditor = null;
        }
    }

    public void editSelectedCell() {
        this.editCell(this.getSelectedIndex());
    }

    public void editCell(int index) {
        ListCellEditor cellEditor = this.getCellEditor();
        if (index != -1 && cellEditor != null) {
            this.setSelectedIndex(index);
            cellEditor.startEdit(this, index);
        }
    }

    public boolean stopCellEditing() {
        ListCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.isEditing() && cellEditor.stopEdit(this);
    }

    public boolean isEditing() {
        ListCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.isEditing();
    }

    public ListToolTipProvider getToolTipProvider() {
        return (ListToolTipProvider)this.getClientProperty(TOOLTIP_PROVIDER_PROPERTY);
    }

    public void setToolTipProvider(ListToolTipProvider provider) {
        this.putClientProperty(TOOLTIP_PROVIDER_PROPERTY, provider);
    }

    public boolean isEmptySelectionAllowed() {
        return this.emptySelectionAllowed;
    }

    public void setEmptySelectionAllowed(boolean emptySelectionAllowed) {
        this.emptySelectionAllowed = emptySelectionAllowed;
        int lead = this.getLeadSelectionIndex();
        int[] selected = this.getSelectedIndices();
        this.setSelectionModel(emptySelectionAllowed ? new DefaultListSelectionModel() : new UnselectableListModel());
        this.setSelectedIndices(selected);
        this.getSelectionModel().setLeadSelectionIndex(lead);
    }

    public int getModelSize() {
        return this.getModel().getSize();
    }

    public <T> T getValueAt(int index) {
        return (T)this.getModel().getElementAt(index);
    }

    public void addListDataListener(ListDataListener listener) {
        this.getModel().addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.getModel().removeListDataListener(listener);
    }

    public void scrollToCell(int index) {
        Rectangle cellBounds;
        if (index != -1 && (cellBounds = this.getCellBounds(index, index)) != null) {
            this.scrollRectToVisible(cellBounds);
        }
    }

    public ListSelectionStyle getSelectionStyle() {
        return this.getUI().getSelectionStyle();
    }

    public void setSelectionStyle(ListSelectionStyle style) {
        this.getUI().setSelectionStyle(style);
    }

    public boolean isSelectOnHover() {
        return ListHoverSelectionBehavior.isInstalled(this);
    }

    public void setSelectOnHover(boolean select) {
        if (select) {
            if (!this.isSelectOnHover()) {
                ListHoverSelectionBehavior.install(this);
            }
        } else if (this.isSelectOnHover()) {
            ListHoverSelectionBehavior.uninstall(this);
        }
    }

    public boolean isScrollToSelection() {
        return ListSelectionScrollBehavior.isInstalled(this);
    }

    public void setScrollToSelection(boolean scroll) {
        if (scroll) {
            if (!this.isScrollToSelection()) {
                ListSelectionScrollBehavior.install(this);
            }
        } else if (this.isScrollToSelection()) {
            ListSelectionScrollBehavior.uninstall(this);
        }
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    public void addHoverListener(HoverListener listener) {
        this.listenerList.add(HoverListener.class, listener);
    }

    public void removeHoverListener(HoverListener listener) {
        this.listenerList.remove(HoverListener.class, listener);
    }

    public HoverListener[] getHoverListeners() {
        return (HoverListener[])this.listenerList.getListeners(HoverListener.class);
    }

    public void fireHoverChanged(Object previous, Object current) {
        for (HoverListener listener : this.getHoverListeners()) {
            listener.hoverChanged(previous, current);
        }
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    public void repaint(Object value) {
        ListModel model = this.getModel();
        if (model instanceof WebListModel) {
            this.repaint(((WebListModel)model).indexOf(value));
        } else {
            for (int i = 0; i < model.getSize(); ++i) {
                if (model.getElementAt(i) != value) continue;
                this.repaint(i);
                break;
            }
        }
    }

    public void repaint(int index) {
        this.repaint(index, index);
    }

    public void repaint(int from, int to) {
        Rectangle cellBounds = this.getCellBounds(from, to);
        if (cellBounds != null) {
            this.repaint(cellBounds);
        }
    }

    public int getEditedCell() {
        return this.editedCell;
    }

    public void addListEditListener(ListEditListener listener) {
        this.listenerList.add(ListEditListener.class, listener);
    }

    public void removeListEditListener(ListEditListener listener) {
        this.listenerList.remove(ListEditListener.class, listener);
    }

    public void fireEditStarted(int index) {
        this.editedCell = index;
        for (ListEditListener listener : (ListEditListener[])this.listenerList.getListeners(ListEditListener.class)) {
            listener.editStarted(index);
        }
    }

    public void fireEditFinished(int index, Object oldValue, Object newValue) {
        this.editedCell = -1;
        for (ListEditListener listener : (ListEditListener[])this.listenerList.getListeners(ListEditListener.class)) {
            listener.editFinished(index, oldValue, newValue);
        }
    }

    public void fireEditCancelled(int index) {
        this.editedCell = -1;
        for (ListEditListener listener : (ListEditListener[])this.listenerList.getListeners(ListEditListener.class)) {
            listener.editCancelled(index);
        }
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain(this, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, mouseButton, runnable);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this);
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this, listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this, listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this);
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this, listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this, listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this);
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebList setPlainFont() {
        return (WebList)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebList setPlainFont(boolean apply2) {
        return (WebList)FontMethodsImpl.setPlainFont(this, apply2);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebList setBoldFont() {
        return (WebList)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebList setBoldFont(boolean apply2) {
        return (WebList)FontMethodsImpl.setBoldFont(this, apply2);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebList setItalicFont() {
        return (WebList)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebList setItalicFont(boolean apply2) {
        return (WebList)FontMethodsImpl.setItalicFont(this, apply2);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebList setFontStyle(boolean bold, boolean italic) {
        return (WebList)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebList setFontStyle(int style) {
        return (WebList)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebList setFontSize(int fontSize) {
        return (WebList)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebList changeFontSize(int change) {
        return (WebList)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebList setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebList)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebList setFontSizeAndStyle(int fontSize, int style) {
        return (WebList)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebList setFontName(String fontName) {
        return (WebList)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebList setPreferredWidth(int preferredWidth) {
        return (WebList)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebList setPreferredHeight(int preferredHeight) {
        return (WebList)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebList setPreferredSize(int width, int height) {
        return (WebList)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebList setMaximumWidth(int maximumWidth) {
        return (WebList)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebList setMaximumHeight(int maximumHeight) {
        return (WebList)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebList setMaximumSize(int width, int height) {
        return (WebList)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebList setMinimumWidth(int minimumWidth) {
        return (WebList)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebList setMinimumHeight(int minimumHeight) {
        return (WebList)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebList setMinimumSize(int width, int height) {
        return (WebList)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WListUI getUI() {
        return (WListUI)super.getUI();
    }

    public void setUI(WListUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

