/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.layout.AbstractContentLayout;
import com.alee.painter.decoration.layout.ContentLayoutData;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class AbstractMenuItemLayout<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractMenuItemLayout<C, D, I>>
extends AbstractContentLayout<C, D, I> {
    protected static final String STATE_ICON = "state-icon";
    protected static final String ICON = "icon";
    protected static final String TEXT = "text";
    protected static final String ACCELERATOR = "accelerator";
    protected static final String ARROW = "arrow";
    @XStreamAsAttribute
    @Nullable
    protected Integer stateIconGap;
    @XStreamAsAttribute
    @Nullable
    protected Integer iconTextGap;
    @XStreamAsAttribute
    @Nullable
    protected Integer textAcceleratorGap;
    @XStreamAsAttribute
    @Nullable
    protected Integer textArrowGap;

    protected abstract boolean isAlignTextByIcons(@NotNull C var1, @NotNull D var2);

    @NotNull
    protected abstract PopupMenuIcons getPopupMenuIcons(@NotNull C var1, @NotNull D var2);

    protected int getStateIconGap(@NotNull C c, @NotNull D d) {
        return this.stateIconGap != null ? this.stateIconGap.intValue() : this.getIconTextGap(c, d);
    }

    protected int getIconTextGap(@NotNull C c, @NotNull D d) {
        return this.iconTextGap != null ? this.iconTextGap : 0;
    }

    protected int getTextAcceleratorGap(@NotNull C c, @NotNull D d) {
        return this.textAcceleratorGap != null ? this.textAcceleratorGap : 0;
    }

    protected int getTextArrowGap(@NotNull C c, @NotNull D d) {
        return this.textArrowGap != null ? this.textArrowGap : 0;
    }

    @Override
    @NotNull
    public ContentLayoutData layoutContent(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        int ax;
        Dimension ips;
        ContentLayoutData layoutData = new ContentLayoutData(4);
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        Dimension available = new Dimension(bounds.width, bounds.height);
        int x = ltr ? bounds.x : bounds.x + bounds.width;
        boolean alignTextByIcons = this.isAlignTextByIcons(c, d);
        boolean hasStateIcon = !this.isEmpty(c, d, STATE_ICON);
        boolean hasIcon = !this.isEmpty(c, d, ICON);
        PopupMenuIcons popupMenuIcons = this.getPopupMenuIcons(c, d);
        if (hasStateIcon || alignTextByIcons && popupMenuIcons.hasBothIcons) {
            ips = this.getPreferredSize(c, d, available, STATE_ICON);
            if (alignTextByIcons) {
                ips.width = Math.max(ips.width, popupMenuIcons.maxStateIconWidth);
                if (!popupMenuIcons.hasBothIcons) {
                    ips.width = Math.max(ips.width, popupMenuIcons.maxIconWidth);
                }
            }
            x += ltr ? 0 : -ips.width;
            if (hasStateIcon) {
                layoutData.put(STATE_ICON, new Rectangle(x, bounds.y, ips.width, bounds.height));
            }
            int stateIconGap = this.getStateIconGap(c, d);
            x += ltr ? ips.width + stateIconGap : -stateIconGap;
            available.width -= ips.width + stateIconGap;
        }
        if (hasIcon || alignTextByIcons && popupMenuIcons.hasBothIcons) {
            ips = this.getPreferredSize(c, d, available, ICON);
            if (alignTextByIcons) {
                ips.width = Math.max(ips.width, popupMenuIcons.maxIconWidth);
                if (!popupMenuIcons.hasBothIcons) {
                    ips.width = Math.max(ips.width, popupMenuIcons.maxStateIconWidth);
                }
            }
            x += ltr ? 0 : -ips.width;
            if (hasIcon) {
                layoutData.put(ICON, new Rectangle(x, bounds.y, ips.width, bounds.height));
            }
            int iconTextGap = this.getIconTextGap(c, d);
            x += ltr ? ips.width + iconTextGap : -iconTextGap;
            available.width -= ips.width + iconTextGap;
        }
        if (!hasStateIcon && !hasIcon && alignTextByIcons && popupMenuIcons.hasAnyIcons && !popupMenuIcons.hasBothIcons) {
            int iconTextGap = this.getIconTextGap(c, d);
            int maxIcon = Math.max(popupMenuIcons.maxStateIconWidth, popupMenuIcons.maxIconWidth);
            x += ltr ? maxIcon + iconTextGap : -iconTextGap;
            available.width -= maxIcon + iconTextGap;
        }
        if (!this.isEmpty(c, d, ARROW)) {
            Dimension aps = this.getPreferredSize(c, d, available, ARROW);
            ax = ltr ? x + available.width - aps.width : x - available.width;
            layoutData.put(ARROW, new Rectangle(ax, bounds.y, aps.width, bounds.height));
            available.width -= aps.width + this.getTextArrowGap(c, d);
        }
        if (!this.isEmpty(c, d, ACCELERATOR)) {
            Dimension aps = this.getPreferredSize(c, d, available, ACCELERATOR);
            ax = ltr ? x + available.width - aps.width : x - available.width;
            layoutData.put(ACCELERATOR, new Rectangle(ax, bounds.y, aps.width, bounds.height));
            available.width -= aps.width + this.getTextAcceleratorGap(c, d);
        }
        if (!this.isEmpty(c, d, TEXT)) {
            layoutData.put(TEXT, new Rectangle(x += ltr ? 0 : -available.width, bounds.y, available.width, bounds.height));
        }
        return layoutData;
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Dimension ips;
        Dimension ps = new Dimension();
        boolean alignTextByIcons = this.isAlignTextByIcons(c, d);
        boolean hasStateIcon = !this.isEmpty(c, d, STATE_ICON);
        boolean hasIcon = !this.isEmpty(c, d, ICON);
        PopupMenuIcons popupMenuIcons = this.getPopupMenuIcons(c, d);
        if (hasStateIcon || alignTextByIcons && popupMenuIcons.hasBothIcons) {
            ips = this.getPreferredSize(c, d, available, STATE_ICON);
            if (alignTextByIcons) {
                ips.width = Math.max(ips.width, popupMenuIcons.maxStateIconWidth);
                if (!popupMenuIcons.hasBothIcons) {
                    ips.width = Math.max(ips.width, popupMenuIcons.maxIconWidth);
                }
            }
            ps.width += ips.width + this.getStateIconGap(c, d);
            ps.height = Math.max(ps.height, ips.height);
        }
        if (hasIcon || alignTextByIcons && popupMenuIcons.hasBothIcons) {
            ips = this.getPreferredSize(c, d, available, ICON);
            if (alignTextByIcons) {
                ips.width = Math.max(ips.width, popupMenuIcons.maxIconWidth);
                if (!popupMenuIcons.hasBothIcons) {
                    ips.width = Math.max(ips.width, popupMenuIcons.maxStateIconWidth);
                }
            }
            ps.width += ips.width + this.getIconTextGap(c, d);
            ps.height = Math.max(ps.height, ips.height);
        }
        if (!hasStateIcon && !hasIcon && alignTextByIcons && popupMenuIcons.hasAnyIcons && !popupMenuIcons.hasBothIcons) {
            int maxIcon = Math.max(popupMenuIcons.maxStateIconWidth, popupMenuIcons.maxIconWidth);
            ps.width += maxIcon + this.getIconTextGap(c, d);
        }
        if (!this.isEmpty(c, d, TEXT)) {
            Dimension tps = this.getPreferredSize(c, d, available, TEXT);
            ps.width += tps.width;
            ps.height = Math.max(ps.height, tps.height);
        }
        if (!this.isEmpty(c, d, ACCELERATOR)) {
            Dimension aps = this.getPreferredSize(c, d, available, ACCELERATOR);
            ps.width += aps.width + this.getTextAcceleratorGap(c, d);
            ps.height = Math.max(ps.height, aps.height);
        }
        if (!this.isEmpty(c, d, ARROW)) {
            Dimension aps = this.getPreferredSize(c, d, available, ARROW);
            ps.width += aps.width + this.getTextArrowGap(c, d);
            ps.height = Math.max(ps.height, aps.height);
        }
        return ps;
    }

    protected static class PopupMenuIcons {
        public boolean hasAnyIcons;
        public boolean hasBothIcons;
        public int maxStateIconWidth;
        public int maxIconWidth;

        public PopupMenuIcons(boolean hasAnyIcons, boolean hasBothIcons, int maxStateIconWidth, int maxIconWidth) {
            this.hasAnyIcons = hasAnyIcons;
            this.hasBothIcons = hasBothIcons;
            this.maxStateIconWidth = maxStateIconWidth;
            this.maxIconWidth = maxIconWidth;
        }
    }
}

