/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.menu.AbstractMenuItemLayout;
import com.alee.painter.decoration.IDecoration;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

@XStreamAlias(value="MenuItemLayout")
public class MenuItemLayout<C extends JMenuItem, D extends IDecoration<C, D>, I extends MenuItemLayout<C, D, I>>
extends AbstractMenuItemLayout<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Boolean alignTextByIcons;

    @Override
    protected boolean isAlignTextByIcons(@NotNull C c, @NotNull D d) {
        return this.alignTextByIcons == null || this.alignTextByIcons != false;
    }

    @Override
    @NotNull
    protected AbstractMenuItemLayout.PopupMenuIcons getPopupMenuIcons(@NotNull C c, @NotNull D d) {
        AbstractMenuItemLayout.PopupMenuIcons popupMenuIcons = new AbstractMenuItemLayout.PopupMenuIcons(false, false, 0, 0);
        if (this.isAlignTextByIcons(c, d) && ((Component)c).getParent() instanceof JPopupMenu) {
            JPopupMenu popupMenu = (JPopupMenu)((Component)c).getParent();
            for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
                Component component2 = popupMenu.getComponent(i);
                if (!(component2 instanceof JMenuItem)) continue;
                JMenuItem item = (JMenuItem)component2;
                this.adjustForMenuItem(popupMenuIcons, item);
            }
        } else {
            this.adjustForMenuItem(popupMenuIcons, (JMenuItem)c);
        }
        return popupMenuIcons;
    }

    protected void adjustForMenuItem(@NotNull AbstractMenuItemLayout.PopupMenuIcons popupMenuIcons, @NotNull JMenuItem menuItem) {
        Icon icon;
        boolean hasIcon;
        Object stateIcon = menuItem.getClientProperty("menuItemStateIcon");
        boolean hasStateIcon = stateIcon instanceof Icon;
        if (hasStateIcon) {
            popupMenuIcons.maxStateIconWidth = Math.max(popupMenuIcons.maxStateIconWidth, ((Icon)stateIcon).getIconWidth());
        }
        boolean bl = hasIcon = (icon = menuItem.getIcon()) != null;
        if (hasIcon) {
            popupMenuIcons.maxIconWidth = Math.max(popupMenuIcons.maxIconWidth, icon.getIconWidth());
        }
        popupMenuIcons.hasAnyIcons = popupMenuIcons.hasAnyIcons || hasStateIcon || hasIcon;
        popupMenuIcons.hasBothIcons = popupMenuIcons.hasBothIcons || hasStateIcon && hasIcon;
    }

    @Override
    protected int getStateIconGap(@NotNull C c, @NotNull D d) {
        return this.stateIconGap != null ? this.stateIconGap.intValue() : this.getIconTextGap(c, d);
    }

    @Override
    protected int getIconTextGap(@NotNull C c, @NotNull D d) {
        return this.iconTextGap != null ? this.iconTextGap.intValue() : ((AbstractButton)c).getIconTextGap();
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d, String constraints) {
        boolean empty = super.isEmpty(c, d, constraints);
        if (!empty) {
            if (Objects.equals((Object)constraints, (Object)"state-icon")) {
                empty = !(c instanceof JCheckBoxMenuItem) && !(c instanceof JRadioButtonMenuItem);
            } else if (Objects.equals((Object)constraints, (Object)"accelerator")) {
                empty = !this.isInPopupMenu(c, d) || ((JMenuItem)c).getAccelerator() == null;
            } else if (Objects.equals((Object)constraints, (Object)"arrow")) {
                empty = !this.isInPopupMenu(c, d);
            }
        }
        return empty;
    }

    protected boolean isInPopupMenu(@NotNull C c, @NotNull D d) {
        return ((Component)c).getParent() != null && ((Component)c).getParent() instanceof JPopupMenu;
    }
}

