/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.rootpane.IRootPanePainter;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.AbstractContainerPainter;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ProprietaryUtils;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.util.List;
import javax.swing.JRootPane;

public class RootPanePainter<C extends JRootPane, U extends WRootPaneUI, D extends IDecoration<C, D>>
extends AbstractContainerPainter<C, U, D>
implements IRootPanePainter<C, U> {
    protected transient WindowFocusListener windowFocusListener;
    protected transient WindowStateListener frameStateListener;
    protected transient VisibilityBehavior<C> windowVisibilityBehavior;
    protected transient boolean maximized = false;

    @Override
    protected void afterInstall() {
        super.afterInstall();
        this.installWindowDecoration();
    }

    @Override
    protected void beforeUninstall() {
        this.uninstallWindowDecoration();
        super.beforeUninstall();
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installWindowStateListener();
        this.installVisibilityListener();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallVisibilityListener();
        this.uninstallWindowStateListener();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected boolean usesFocusedView() {
        Window window = this.getWindow();
        boolean usesFocusedView = window != null ? window.isFocusableWindow() && this.usesState("focused") : super.usesFocusedView();
        return usesFocusedView;
    }

    @Override
    protected void installFocusListeners() {
        Window window = this.getWindow();
        if (window != null && this.usesFocusedView()) {
            this.focused = window.isFocused();
            this.windowFocusListener = new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    RootPanePainter.this.focusChanged(true);
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    RootPanePainter.this.focusChanged(false);
                }
            };
            window.addWindowFocusListener(this.windowFocusListener);
        } else {
            super.installFocusListeners();
        }
    }

    @Override
    protected void uninstallFocusListeners() {
        Window window = this.getWindow();
        if (window != null && this.windowFocusListener != null) {
            window.removeWindowFocusListener(this.windowFocusListener);
            this.windowFocusListener = null;
            this.focused = false;
        } else {
            super.uninstallFocusListeners();
        }
    }

    @Override
    protected Boolean isOpaqueUndecorated() {
        return true;
    }

    @Override
    public boolean isDecorated() {
        Object decoration = this.getDecoration();
        return decoration != null && decoration.isVisible();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"focusableWindowState")) {
            this.updateFocusListeners();
        }
        if (Objects.equals((Object)property, (Object)"windowDecorationStyle")) {
            Window window;
            this.updateDecorationState();
            if (Objects.notEquals(oldValue, (Object)0) && Objects.equals(newValue, (Object)0) && Objects.notEquals((Object)StyleId.get(this.component), StyleId.rootpane, StyleId.dialog, StyleId.frame)) {
                window = this.getWindow();
                if (window != null) {
                    if (window instanceof Frame) {
                        StyleId.frame.set(this.component);
                    } else if (window instanceof Dialog) {
                        StyleId.dialog.set(this.component);
                    } else {
                        StyleId.rootpane.set(this.component);
                    }
                } else {
                    StyleId.rootpane.set(this.component);
                }
            }
            if (Objects.equals(oldValue, (Object)0) && Objects.notEquals(newValue, (Object)0) && Objects.equals((Object)StyleId.get(this.component), StyleId.rootpane, StyleId.dialog, StyleId.frame) && (window = this.getWindow()) != null) {
                if (window instanceof Frame) {
                    StyleId.frameDecorated.set(this.component);
                } else if (window instanceof Dialog) {
                    switch (((JRootPane)this.component).getWindowDecorationStyle()) {
                        case 5: {
                            StyleId.colorchooserDialog.set(this.component);
                            break;
                        }
                        case 6: {
                            StyleId.filechooserDialog.set(this.component);
                            break;
                        }
                        case 3: {
                            StyleId.optionpaneInformationDialog.set(this.component);
                            break;
                        }
                        case 4: {
                            StyleId.optionpaneErrorDialog.set(this.component);
                            break;
                        }
                        case 7: {
                            StyleId.optionpaneQuestionDialog.set(this.component);
                            break;
                        }
                        case 8: {
                            StyleId.optionpaneWarningDialog.set(this.component);
                            break;
                        }
                        default: {
                            StyleId.dialogDecorated.set(this.component);
                        }
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(this.getWindowDecorationState());
        if (((WRootPaneUI)this.ui).isIconified()) {
            states.add("iconified");
        }
        if (((WRootPaneUI)this.ui).isMaximized()) {
            states.add("maximized");
        }
        if (CoreSwingUtils.isFullScreen(this.component)) {
            states.add("fullscreen");
        }
        states.addAll(DecorationUtils.getExtraStates(this.getWindow()));
        return states;
    }

    @NotNull
    protected String getWindowDecorationState() {
        String state;
        switch (((JRootPane)this.component).getWindowDecorationStyle()) {
            case 0: {
                state = "native-window";
                break;
            }
            case 1: {
                state = "frame";
                break;
            }
            case 2: {
                state = "dialog";
                break;
            }
            case 5: {
                state = "colorchooser-dialog";
                break;
            }
            case 6: {
                state = "filechooser-dialog";
                break;
            }
            case 3: {
                state = "information-dialog";
                break;
            }
            case 4: {
                state = "error-dialog";
                break;
            }
            case 7: {
                state = "question-dialog";
                break;
            }
            case 8: {
                state = "warning-dialog";
                break;
            }
            default: {
                throw new StyleException("Unknown window decoration style: " + ((JRootPane)this.component).getWindowDecorationStyle());
            }
        }
        return state;
    }

    protected void installWindowDecoration() {
        Window window = this.getWindow();
        if (window != null && this.isDecorated()) {
            if (window instanceof Frame) {
                if (!window.isDisplayable()) {
                    ((JRootPane)this.component).setOpaque(false);
                    ProprietaryUtils.setWindowShape(window, null);
                    ((Frame)window).setUndecorated(true);
                    ProprietaryUtils.setWindowOpaque(window, false);
                }
                if (((JRootPane)this.component).getWindowDecorationStyle() == 0) {
                    ((JRootPane)this.component).setWindowDecorationStyle(1);
                }
            } else if (window instanceof Dialog) {
                if (!window.isDisplayable()) {
                    ((JRootPane)this.component).setOpaque(false);
                    ProprietaryUtils.setWindowShape(window, null);
                    ((Dialog)window).setUndecorated(true);
                    ProprietaryUtils.setWindowOpaque(window, false);
                }
                if (((JRootPane)this.component).getWindowDecorationStyle() == 0) {
                    ((JRootPane)this.component).setWindowDecorationStyle(2);
                }
            }
            ((WRootPaneUI)this.ui).installWindowDecorations();
        }
    }

    protected void uninstallWindowDecoration() {
        Window window = this.getWindow();
        if (window != null && this.isDecorated()) {
            ((WRootPaneUI)this.ui).uninstallWindowDecorations();
            if (window instanceof Frame) {
                if (!window.isDisplayable()) {
                    ProprietaryUtils.setWindowOpaque(window, true);
                    ((Frame)window).setUndecorated(false);
                    ((JRootPane)this.component).setOpaque(true);
                }
            } else if (window instanceof Dialog && !window.isDisplayable()) {
                ProprietaryUtils.setWindowOpaque(window, true);
                ((Dialog)window).setUndecorated(false);
                ((JRootPane)this.component).setOpaque(true);
            }
        }
    }

    protected void installWindowStateListener() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            this.frameStateListener = new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    RootPanePainter.this.updateDecorationState();
                }
            };
            window.addWindowStateListener(this.frameStateListener);
        }
    }

    protected void uninstallWindowStateListener() {
        Window window = this.getWindow();
        if (window != null && this.frameStateListener != null) {
            window.removeWindowStateListener(this.frameStateListener);
            this.frameStateListener = null;
        }
    }

    protected void installVisibilityListener() {
        this.windowVisibilityBehavior = new VisibilityBehavior<C>((JRootPane)this.component){

            @Override
            protected void displayed(@NotNull C component2) {
                Window window = RootPanePainter.this.getWindow();
                if (window != null) {
                    WebLookAndFeel.fireWindowDisplayed(window);
                }
            }

            @Override
            protected void hidden(@NotNull C component2) {
                Window window = RootPanePainter.this.getWindow();
                if (window != null) {
                    WebLookAndFeel.fireWindowHidden(window);
                }
            }
        };
        this.windowVisibilityBehavior.install();
    }

    protected void uninstallVisibilityListener() {
        this.windowVisibilityBehavior.uninstall();
        this.windowVisibilityBehavior = null;
    }

    @Nullable
    protected Window getWindow() {
        Container parent = ((JRootPane)this.component).getParent();
        return parent instanceof Window ? (Window)parent : null;
    }
}

