/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.laf.rootpane.WindowState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.CoreSwingUtils;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JRootPane;

public class RootPaneSettingsProcessor
extends SettingsProcessor<JRootPane, WindowState, Configuration<WindowState>> {
    protected transient ComponentListener componentListener;
    protected transient WindowStateListener windowStateListener;
    protected transient VisibilityBehavior<Window> windowVisibilityBehavior;

    public RootPaneSettingsProcessor(@NotNull JRootPane rootPane, @NotNull Configuration configuration) {
        super(rootPane, configuration);
    }

    @Override
    protected void register(@NotNull JRootPane rootPane) {
        Window window = CoreSwingUtils.getNonNullWindowAncestor(rootPane);
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                RootPaneSettingsProcessor.this.save();
            }

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                RootPaneSettingsProcessor.this.save();
            }
        };
        this.windowStateListener = new WindowStateListener(){

            @Override
            public void windowStateChanged(@NotNull WindowEvent e) {
                RootPaneSettingsProcessor.this.save();
            }
        };
        this.windowVisibilityBehavior = new VisibilityBehavior<Window>(window, true){

            @Override
            protected void displayed(@NotNull Window window) {
                window.addComponentListener(RootPaneSettingsProcessor.this.componentListener);
                window.addWindowStateListener(RootPaneSettingsProcessor.this.windowStateListener);
            }

            @Override
            protected void hidden(@NotNull Window window) {
                window.removeWindowStateListener(RootPaneSettingsProcessor.this.windowStateListener);
                window.removeComponentListener(RootPaneSettingsProcessor.this.componentListener);
            }
        };
        this.windowVisibilityBehavior.install();
    }

    @Override
    protected void unregister(@NotNull JRootPane rootPane) {
        this.windowVisibilityBehavior.uninstall();
        this.windowVisibilityBehavior = null;
        this.windowStateListener = null;
        this.componentListener = null;
    }

    @Override
    @Nullable
    protected WindowState createDefaultValue() {
        return new WindowState((JRootPane)this.component());
    }

    @Override
    protected void loadSettings(@NotNull JRootPane rootPane) {
        ((WindowState)this.loadSettings()).apply(rootPane);
    }

    @Override
    protected void saveSettings(@NotNull JRootPane rootPane) {
        this.saveSettings(((WindowState)this.loadSettings()).retrieve(rootPane));
    }
}

