/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.utils.MathUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

public class WebRootPaneLayout
extends AbstractLayoutManager {
    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.calculateSize(container, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.calculateSize(container, false);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Component glassPane;
        Dimension ps;
        JRootPane root = (JRootPane)container;
        WebRootPaneUI rootUI = (WebRootPaneUI)root.getUI();
        Insets i = container.getInsets();
        Dimension s = container.getSize();
        int w = s.width - i.right - i.left;
        int h = s.height - i.top - i.bottom;
        boolean ltr = root.getComponentOrientation().isLeftToRight();
        JComponent windowButtons = rootUI.getButtonsPanel();
        JComponent titleComponent = rootUI.getTitleComponent();
        JMenuBar menuBar = root.getJMenuBar();
        boolean showWindowButtons = windowButtons != null && rootUI.isDisplayWindowButtons() && (rootUI.isDisplayMinimizeButton() || rootUI.isDisplayMaximizeButton() || rootUI.isDisplayCloseButton());
        boolean showTitleComponent = titleComponent != null && rootUI.isDisplayTitleComponent();
        boolean showMenuBar = menuBar != null && rootUI.isDisplayMenuBar();
        int extraHeight = 0;
        int buttonsWidth = 0;
        if (showWindowButtons) {
            container.setComponentZOrder(windowButtons, 0);
            ps = windowButtons.getPreferredSize();
            int x = ltr ? s.width - i.right - ps.width : i.left;
            windowButtons.setVisible(true);
            windowButtons.setBounds(x, i.top, ps.width, ps.height);
            buttonsWidth = ps.width;
        } else if (windowButtons != null) {
            windowButtons.setVisible(false);
        }
        if (showTitleComponent) {
            ps = titleComponent.getPreferredSize();
            titleComponent.setVisible(true);
            titleComponent.setBounds(ltr ? i.left : i.left + buttonsWidth, i.top, w - buttonsWidth, ps.height);
            extraHeight += ps.height;
        } else if (titleComponent != null) {
            titleComponent.setVisible(false);
        }
        JLayeredPane layeredPane = root.getLayeredPane();
        if (layeredPane != null) {
            layeredPane.setBounds(0, 0, s.width, s.height);
        }
        if (showMenuBar) {
            Dimension mbd = menuBar.getPreferredSize();
            menuBar.setVisible(true);
            menuBar.setBounds(i.left, i.top + extraHeight, w, mbd.height);
            extraHeight += mbd.height;
        } else if (menuBar != null) {
            menuBar.setVisible(false);
        }
        Container contentPane = root.getContentPane();
        if (contentPane != null) {
            int contentHeight = h > extraHeight ? h - extraHeight : 0;
            contentPane.setBounds(i.left, i.top + extraHeight, w, contentHeight);
        }
        if ((glassPane = root.getGlassPane()) != null) {
            glassPane.setBounds(i.left, i.top, w, h);
        }
    }

    private Dimension calculateSize(Container container, boolean preferred) {
        int tpHeight;
        int tpWidth;
        Insets i = container.getInsets();
        JRootPane root = (JRootPane)container;
        WebRootPaneUI rootUI = (WebRootPaneUI)root.getUI();
        JComponent windowButtons = rootUI.getButtonsPanel();
        JComponent titleComponent = rootUI.getTitleComponent();
        JMenuBar menuBar = root.getJMenuBar();
        boolean showWindowButtons = windowButtons != null && rootUI.isDisplayWindowButtons() && (rootUI.isDisplayMinimizeButton() || rootUI.isDisplayMaximizeButton() || rootUI.isDisplayCloseButton());
        boolean showTitleComponent = titleComponent != null && rootUI.isDisplayTitleComponent();
        boolean showMenuBar = menuBar != null && rootUI.isDisplayMenuBar();
        Dimension titleDim = showTitleComponent ? titleComponent.getPreferredSize() : new Dimension(0, 0);
        Dimension buttonsDim = showWindowButtons ? windowButtons.getPreferredSize() : new Dimension(0, 0);
        Dimension menuDim = showMenuBar ? menuBar.getPreferredSize() : new Dimension(0, 0);
        if (preferred) {
            if (showWindowButtons) {
                if (showTitleComponent) {
                    if (showMenuBar) {
                        tpWidth = Math.max(titleDim.width + buttonsDim.width, menuDim.width);
                        tpHeight = Math.max(titleDim.height, buttonsDim.height) + menuDim.height;
                    } else {
                        tpWidth = titleDim.width + buttonsDim.width;
                        tpHeight = Math.max(titleDim.height, buttonsDim.height);
                    }
                } else if (showMenuBar) {
                    tpWidth = menuDim.width + buttonsDim.width;
                    tpHeight = Math.max(menuDim.height, buttonsDim.height);
                } else {
                    tpWidth = buttonsDim.width;
                    tpHeight = 0;
                }
            } else if (showTitleComponent && showMenuBar) {
                tpWidth = Math.max(titleDim.width, menuDim.width);
                tpHeight = titleDim.height + menuDim.height;
            } else if (showTitleComponent) {
                tpWidth = titleDim.width;
                tpHeight = titleDim.height;
            } else if (showMenuBar) {
                tpWidth = menuDim.width;
                tpHeight = menuDim.height;
            } else {
                tpWidth = 0;
                tpHeight = 0;
            }
        } else if (showWindowButtons) {
            if (showTitleComponent) {
                tpWidth = titleDim.width + buttonsDim.width;
                tpHeight = Math.max(titleDim.height, buttonsDim.height);
            } else {
                tpWidth = buttonsDim.width;
                tpHeight = buttonsDim.height;
            }
        } else if (showTitleComponent) {
            tpWidth = titleDim.width;
            tpHeight = titleDim.height;
        } else {
            tpWidth = 0;
            tpHeight = 0;
        }
        int cpWidth = 0;
        int cpHeight = 0;
        Dimension cpd = preferred ? (root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize()) : new Dimension(0, 0);
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        int width = i.left + MathUtils.max(tpWidth, cpWidth) + i.right;
        int height = i.top + tpHeight + cpHeight + i.bottom;
        return new Dimension(width, height);
    }
}

