/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Function;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.ComponentResizeBehavior;
import com.alee.extended.image.WebImage;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.grouping.GroupPane;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.laf.rootpane.WebRootPaneLayout;
import com.alee.laf.rootpane.WindowDecorationBehavior;
import com.alee.managers.language.LM;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;

public class WebRootPaneUI
extends WRootPaneUI
implements SwingConstants {
    public static ImageIcon minimizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize.png"));
    public static ImageIcon minimizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize_active.png"));
    public static ImageIcon maximizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize.png"));
    public static ImageIcon maximizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize_active.png"));
    public static ImageIcon restoreIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore.png"));
    public static ImageIcon restoreActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore_active.png"));
    public static ImageIcon closeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close.png"));
    public static ImageIcon closeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close_active.png"));
    protected boolean installComponents;
    protected int iconSize;
    protected String emptyTitleText;
    protected boolean setupButtonIcons;
    protected boolean displayTitleComponent;
    protected boolean displayWindowButtons;
    protected boolean displayMinimizeButton;
    protected boolean displayMaximizeButton;
    protected boolean displayCloseButton;
    protected boolean displayMenuBar;
    protected transient PropertyChangeListener resizableChangeListener;
    protected transient ComponentResizeBehavior resizeBehavior;
    protected transient PropertyChangeListener windowTitleListener;
    protected transient JComponent titleComponent;
    protected transient WindowDecorationBehavior decorationBehavior;
    protected transient WebImage titleIcon;
    protected transient WebLabel titleLabel;
    protected transient GroupPane buttonsPanel;
    protected transient WebButton minimizeButton;
    protected transient WebButton maximizeButton;
    protected transient WebButton closeButton;
    protected transient JRootPane root;
    protected transient boolean decorated;
    protected transient Window window;
    protected transient Frame frame;
    protected transient Dialog dialog;
    protected transient LayoutManager previousLayoutManager;
    protected transient LayoutManager layoutManager;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebRootPaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        JComponent jContentPane;
        super.installUI(c);
        this.root = (JRootPane)c;
        StyleManager.installSkin(this.root);
        Container contentPane = this.root.getContentPane();
        if (contentPane instanceof JComponent && LafUtils.hasWebLafUI(jContentPane = (JComponent)contentPane)) {
            StyleId.rootpaneContent.at(this.root).set(jContentPane);
        }
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.root);
        this.root = null;
        super.uninstallUI(c);
    }

    @Override
    public boolean isDecorated() {
        return this.decorated;
    }

    @Override
    public void installWindowDecorations() {
        if (this.root.getWindowDecorationStyle() != 0) {
            this.decorated = true;
            this.window = this.getWindow();
            this.frame = this.window instanceof Frame ? (Frame)this.window : null;
            this.dialog = this.window instanceof Dialog ? (Dialog)this.window : null;
            this.installSettings();
            this.installListeners();
            this.installLayout();
            this.installDecorationComponents();
        }
    }

    @Override
    public void uninstallWindowDecorations() {
        if (this.window != null) {
            this.uninstallDecorationComponents();
            this.uninstallLayout();
            this.uninstallListeners();
            this.uninstallSettings();
            this.dialog = null;
            this.frame = null;
            this.window = null;
            this.decorated = false;
        }
    }

    @Override
    public boolean isDisplayTitleComponent() {
        return this.displayTitleComponent;
    }

    @Override
    public void setDisplayTitleComponent(boolean display) {
        this.displayTitleComponent = display;
        this.root.revalidate();
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    @Override
    public void setTitleComponent(JComponent title) {
        boolean decorated;
        boolean bl = decorated = this.titleComponent != null;
        if (decorated) {
            this.root.remove(this.titleComponent);
        }
        this.titleComponent = title;
        if (decorated) {
            this.root.add(this.titleComponent);
            this.root.revalidate();
        }
    }

    @Override
    public boolean isDisplayWindowButtons() {
        return this.displayWindowButtons;
    }

    @Override
    public void setDisplayWindowButtons(boolean display) {
        this.displayWindowButtons = display;
        this.root.revalidate();
    }

    @Override
    public boolean isDisplayMinimizeButton() {
        return this.displayMinimizeButton;
    }

    @Override
    public void setDisplayMinimizeButton(boolean display) {
        this.displayMinimizeButton = display;
        this.updateButtons();
        this.root.revalidate();
    }

    @Override
    public boolean isDisplayMaximizeButton() {
        return this.displayMaximizeButton;
    }

    @Override
    public void setDisplayMaximizeButton(boolean display) {
        this.displayMaximizeButton = display;
        this.updateButtons();
        this.root.revalidate();
    }

    @Override
    public boolean isDisplayCloseButton() {
        return this.displayCloseButton;
    }

    @Override
    public void setDisplayCloseButton(boolean display) {
        this.displayCloseButton = display;
        this.updateButtons();
        this.root.revalidate();
    }

    @Override
    public JComponent getButtonsPanel() {
        return this.buttonsPanel;
    }

    @Override
    public boolean isDisplayMenuBar() {
        return this.displayMenuBar;
    }

    @Override
    public void setDisplayMenuBar(boolean display) {
        this.displayMenuBar = display;
        this.root.revalidate();
    }

    protected void installSettings() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(SystemUtils.getMaximizedBounds(this.frame));
        }
    }

    protected void uninstallSettings() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(null);
        }
    }

    protected void installListeners() {
        this.resizableChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                WebRootPaneUI.this.updateButtons();
            }
        };
        this.window.addPropertyChangeListener("resizable", this.resizableChangeListener);
        this.resizeBehavior = new ComponentResizeBehavior((Component)this.root, new Function<Point, CompassDirection>(){

            @Override
            public CompassDirection apply(@NotNull Point p) {
                Rectangle outer;
                Rectangle bounds;
                Rectangle inner;
                CompassDirection direction = WebRootPaneUI.this.dialog != null && WebRootPaneUI.this.dialog.isResizable() || WebRootPaneUI.this.frame != null && WebRootPaneUI.this.frame.isResizable() ? (!(inner = GeometryUtils.expand(bounds = BoundsType.padding.bounds(WebRootPaneUI.this.root), -5, -5, -10, -10)).contains(p) ? ((outer = GeometryUtils.expand(inner, 10, 10, 20, 20)).contains(p) ? (p.y < inner.y ? (p.x < inner.x ? CompassDirection.northWest : (p.x > inner.x + inner.width ? CompassDirection.northEast : CompassDirection.north)) : (p.y > inner.y + inner.height ? (p.x < inner.x ? CompassDirection.southWest : (p.x > inner.x + inner.width ? CompassDirection.southEast : CompassDirection.south)) : (p.x < inner.x ? CompassDirection.west : (p.x > inner.x + inner.width ? CompassDirection.east : null)))) : null) : null) : null;
                return direction;
            }
        });
        this.resizeBehavior.install();
    }

    protected void uninstallListeners() {
        this.resizeBehavior.uninstall();
        this.resizeBehavior = null;
        this.window.removePropertyChangeListener("resizable", this.resizableChangeListener);
        this.resizableChangeListener = null;
    }

    protected void installLayout() {
        if (this.layoutManager == null) {
            this.layoutManager = new WebRootPaneLayout();
        }
        this.previousLayoutManager = this.root.getLayout();
        this.root.setLayout(this.layoutManager);
    }

    protected void uninstallLayout() {
        if (this.previousLayoutManager != null) {
            this.root.setLayout(this.previousLayoutManager);
            this.previousLayoutManager = null;
            this.layoutManager = null;
        }
    }

    protected boolean isComponentInstallAllowed() {
        return this.installComponents && (this.isFrame() || this.isDialog());
    }

    protected void installDecorationComponents() {
        if (this.isComponentInstallAllowed()) {
            this.createTitleComponent();
            this.updateButtons();
        }
    }

    protected void uninstallDecorationComponents() {
        if (this.isComponentInstallAllowed()) {
            this.destroyTitleComponent();
            this.destroyButtons();
        }
    }

    protected void createTitleComponent() {
        if (this.titleComponent == null) {
            StyleId titlePanelId = StyleId.rootpaneTitlePanel.at(this.root);
            this.titleComponent = new WebPanel(titlePanelId, new BorderLayout(0, 0), new Component[0]);
            this.titleIcon = new WebImage(StyleId.rootpaneTitleIcon.at(this.titleComponent), this.getWindowImage());
            this.titleComponent.add((Component)this.titleIcon, "Before");
            this.titleLabel = new WebLabel(StyleId.rootpaneTitleLabel.at(this.titleComponent), this.getWindowTitle());
            this.titleLabel.setFont(WebLookAndFeel.globalWindowFont);
            this.titleLabel.setFontSize(13);
            this.titleLabel.addComponentListener(new ComponentAdapter(){
                private final int initialAlignment;
                {
                    this.initialAlignment = WebRootPaneUI.this.titleLabel.getHorizontalAlignment();
                }

                @Override
                public void componentResized(@NotNull ComponentEvent e) {
                    boolean trimmed = WebRootPaneUI.this.titleLabel.getOriginalPreferredSize().width > WebRootPaneUI.this.titleLabel.getWidth();
                    boolean ltr = WebRootPaneUI.this.titleLabel.getComponentOrientation().isLeftToRight();
                    int alignment = trimmed ? (ltr ? 10 : 11) : this.initialAlignment;
                    WebRootPaneUI.this.titleLabel.setHorizontalAlignment(alignment);
                }
            });
            this.titleComponent.add((Component)this.titleLabel, "Center");
            this.windowTitleListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    String property = evt.getPropertyName();
                    if (Objects.equals((Object)property, (Object)"iconImage")) {
                        WebRootPaneUI.this.titleIcon.setImage(WebRootPaneUI.this.getWindowImage());
                    } else if (Objects.equals((Object)property, (Object)"title")) {
                        WebRootPaneUI.this.titleLabel.setText(WebRootPaneUI.this.getWindowTitle());
                    }
                }
            };
            this.window.addPropertyChangeListener(this.windowTitleListener);
            this.decorationBehavior = new WindowDecorationBehavior(this);
            this.decorationBehavior.install();
        }
        this.root.add(this.titleComponent);
    }

    protected void destroyTitleComponent() {
        if (this.titleComponent != null) {
            this.decorationBehavior.uninstall();
            this.decorationBehavior = null;
            this.window.removePropertyChangeListener(this.windowTitleListener);
            this.root.remove(this.titleComponent);
            StyleManager.resetStyleId(this.titleComponent);
            this.titleComponent = null;
            this.titleIcon = null;
            this.titleLabel = null;
        }
    }

    protected void updateButtons() {
        if (this.isDecorated() && this.isComponentInstallAllowed()) {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new GroupPane(StyleId.rootpaneButtonsPanel.at(this.root), new Component[0]);
                this.buttonsPanel.setPaintSides(false, true, true, true);
                this.root.add(this.buttonsPanel);
            }
            if (this.displayMinimizeButton && this.isFrame()) {
                if (this.minimizeButton == null) {
                    StyleId minimizeId = StyleId.rootpaneMinimizeButton.at(this.buttonsPanel);
                    this.minimizeButton = new WebButton(minimizeId){

                        @Override
                        @Nullable
                        public Icon getIcon() {
                            return WebRootPaneUI.this.setupButtonIcons ? minimizeIcon : null;
                        }

                        @Override
                        @Nullable
                        public Icon getRolloverIcon() {
                            return WebRootPaneUI.this.setupButtonIcons ? minimizeActiveIcon : null;
                        }
                    };
                    this.minimizeButton.setName("minimize");
                    this.minimizeButton.setRolloverEnabled(true);
                    this.minimizeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(@NotNull ActionEvent e) {
                            WebRootPaneUI.this.iconify();
                        }
                    });
                }
                this.buttonsPanel.add((Component)this.minimizeButton);
            } else if (this.minimizeButton != null) {
                this.buttonsPanel.remove((Component)this.minimizeButton);
            }
            if (this.displayMaximizeButton && this.isResizable() && this.isFrame()) {
                if (this.maximizeButton == null) {
                    StyleId maximizeId = StyleId.rootpaneMaximizeButton.at(this.buttonsPanel);
                    this.maximizeButton = new WebButton(maximizeId){

                        @Override
                        @Nullable
                        public Icon getIcon() {
                            return WebRootPaneUI.this.setupButtonIcons ? (WebRootPaneUI.this.isMaximized() ? restoreIcon : maximizeIcon) : null;
                        }

                        @Override
                        @Nullable
                        public Icon getRolloverIcon() {
                            return WebRootPaneUI.this.setupButtonIcons ? (WebRootPaneUI.this.isMaximized() ? restoreActiveIcon : maximizeActiveIcon) : null;
                        }
                    };
                    this.maximizeButton.setName("maximize");
                    this.maximizeButton.setRolloverEnabled(true);
                    this.maximizeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(@NotNull ActionEvent e) {
                            if (WebRootPaneUI.this.isFrame()) {
                                if (WebRootPaneUI.this.isMaximized()) {
                                    WebRootPaneUI.this.restore();
                                } else {
                                    WebRootPaneUI.this.maximize();
                                }
                            }
                        }
                    });
                }
                this.buttonsPanel.add((Component)this.maximizeButton);
            } else if (this.maximizeButton != null) {
                this.buttonsPanel.remove((Component)this.maximizeButton);
            }
            if (this.displayCloseButton) {
                if (this.closeButton == null) {
                    StyleId closeId = StyleId.rootpaneCloseButton.at(this.buttonsPanel);
                    this.closeButton = new WebButton(closeId){

                        @Override
                        @Nullable
                        public Icon getIcon() {
                            return WebRootPaneUI.this.setupButtonIcons ? closeIcon : null;
                        }

                        @Override
                        @Nullable
                        public Icon getRolloverIcon() {
                            return WebRootPaneUI.this.setupButtonIcons ? closeActiveIcon : null;
                        }
                    };
                    this.closeButton.setName("close");
                    this.closeButton.setRolloverEnabled(true);
                    this.closeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(@NotNull ActionEvent e) {
                            WebRootPaneUI.this.close();
                        }
                    });
                }
                this.buttonsPanel.add((Component)this.closeButton);
            } else if (this.closeButton != null) {
                this.buttonsPanel.remove((Component)this.closeButton);
            }
        }
    }

    protected void destroyButtons() {
        if (this.buttonsPanel != null) {
            this.root.remove(this.buttonsPanel);
            this.buttonsPanel.resetStyleId();
            this.buttonsPanel = null;
            this.minimizeButton = null;
            this.maximizeButton = null;
            this.closeButton = null;
        }
    }

    @NotNull
    protected String getWindowTitle() {
        String title;
        String string = this.isDialog() ? this.dialog.getTitle() : (title = this.isFrame() ? this.frame.getTitle() : null);
        String t = !TextUtils.isBlank(title) ? title : (this.emptyTitleText != null ? LM.get(this.emptyTitleText, new Object[0]) : null);
        return TextUtils.notEmpty(t) ? t : " ";
    }

    @Nullable
    protected Image getWindowImage() {
        Image image;
        List<Image> images;
        List<Image> list = images = this.window != null ? this.window.getIconImages() : null;
        if (CollectionUtils.notEmpty(images)) {
            if (images.size() > 1) {
                int bestIndex = 0;
                int bestDiff = Math.abs(images.get(bestIndex).getWidth(null) - this.iconSize);
                for (int i = 1; i < images.size() && bestDiff != 0; ++i) {
                    int diff = Math.abs(images.get(i).getWidth(null) - this.iconSize);
                    if (diff >= bestDiff) continue;
                    bestIndex = i;
                    bestDiff = diff;
                }
                image = images.get(bestIndex);
            } else {
                image = images.get(0);
            }
        } else {
            image = null;
        }
        return image;
    }

    @Override
    @Nullable
    public Window getWindow() {
        return CoreSwingUtils.getWindowAncestor(this.root);
    }

    @Override
    public boolean isFrame() {
        return this.frame != null;
    }

    @Override
    public boolean isDialog() {
        return this.dialog != null;
    }

    @Override
    public void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    @Override
    public void iconify() {
        if (this.frame != null) {
            this.frame.setExtendedState(1);
        }
    }

    @Override
    public void maximize() {
        if (this.frame != null) {
            this.frame.setMaximizedBounds(SystemUtils.getMaximizedBounds(this.frame));
            this.frame.setExtendedState(6);
        }
    }

    @Override
    public void maximizeWest() {
        if (this.frame != null) {
            this.frame.setMaximizedBounds(SystemUtils.getMaximizedWestBounds(this.frame));
            this.frame.setExtendedState(4);
        }
    }

    @Override
    public void maximizeEast() {
        if (this.frame != null) {
            this.frame.setMaximizedBounds(SystemUtils.getMaximizedEastBounds(this.frame));
            this.frame.setExtendedState(4);
        }
    }

    @Override
    public void restore() {
        if (this.frame != null) {
            this.frame.setExtendedState(0);
        }
    }

    @Override
    protected boolean isResizable() {
        return this.isDialog() ? this.dialog.isResizable() : this.isFrame() && this.frame.isResizable();
    }

    @Override
    public boolean isIconified() {
        return this.isFrame() && (this.frame.getExtendedState() & 1) == 1;
    }

    @Override
    public boolean isMaximized() {
        return this.isFrame() && ((this.frame.getExtendedState() & 6) == 6 || (this.frame.getExtendedState() & 2) == 2 || (this.frame.getExtendedState() & 4) == 4);
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }
}

