/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.button.WebButton;
import com.alee.laf.scroll.ScrollBarPaintParameters;
import com.alee.laf.scroll.WScrollBarUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebScrollBarUI
extends WScrollBarUI {
    protected boolean displayButtons;
    protected boolean displayTrack;
    protected Dimension minimumThumbSize;
    private transient PropertyChangeListener buttonsStateUpdater;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebScrollBarUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        SwingUtils.setHandlesEnableStateMark(this.scrollbar);
        StyleManager.installSkin(this.scrollbar);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.scrollbar);
        SwingUtils.removeHandlesEnableStateMark(this.scrollbar);
        super.uninstallUI(c);
    }

    @Override
    public boolean isDisplayButtons() {
        return this.displayButtons;
    }

    @Override
    public void setDisplayButtons(boolean displayButtons) {
        this.displayButtons = displayButtons;
        this.scrollbar.revalidate();
        this.scrollbar.repaint();
    }

    @Override
    public boolean isDisplayTrack() {
        return this.displayTrack;
    }

    @Override
    public void setDisplayTrack(boolean displayTrack) {
        this.displayTrack = displayTrack;
        this.scrollbar.revalidate();
        this.scrollbar.repaint();
    }

    @Override
    protected void installComponents() {
        this.decrButton = new ScrollBarButton(StyleId.scrollbarDecreaseButton.at(this.scrollbar));
        this.scrollbar.add(this.decrButton);
        this.incrButton = new ScrollBarButton(StyleId.scrollbarIncreaseButton.at(this.scrollbar));
        this.scrollbar.add(this.incrButton);
        this.buttonsStateUpdater = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DecorationUtils.fireStatesChanged(WebScrollBarUI.this.decrButton);
                DecorationUtils.fireStatesChanged(WebScrollBarUI.this.incrButton);
            }
        };
        this.scrollbar.addPropertyChangeListener("orientation", this.buttonsStateUpdater);
    }

    @Override
    protected void uninstallComponents() {
        this.scrollbar.removePropertyChangeListener("orientation", this.buttonsStateUpdater);
        this.scrollbar.remove(this.incrButton);
        this.scrollbar.remove(this.decrButton);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this, new ScrollBarPaintParameters(this.isDragging, this.trackRect, this.thumbRect));
    }

    @Override
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Dimension ps;
        boolean ver = this.scrollbar.getOrientation() == 1;
        Painter painter = PainterSupport.getPainter(c);
        Dimension dimension = painter != null ? painter.getPreferredSize() : (ps = new Dimension(ver ? 0 : 48, ver ? 48 : 0));
        if (painter != null && this.displayButtons && this.decrButton != null && this.incrButton != null) {
            Dimension dps = this.decrButton.getPreferredSize();
            Dimension ips = this.incrButton.getPreferredSize();
            if (ver) {
                ps.width = Math.max(ps.width, Math.max(dps.width, ips.width));
                ps.height += dps.height + ips.height;
            } else {
                ps.width += dps.width + ips.width;
                ps.height = Math.max(ps.height, Math.max(dps.height, ips.height));
            }
        }
        return ps;
    }

    public class ScrollBarButton
    extends WebButton
    implements Stateful {
        public ScrollBarButton(StyleId id) {
            super(id);
            this.setFocusable(false);
            this.setEnabled(WebScrollBarUI.this.scrollbar != null && WebScrollBarUI.this.scrollbar.isEnabled());
        }

        @Override
        @Nullable
        public List<String> getStates() {
            ArrayList<String> states = null;
            if (WebScrollBarUI.this.scrollbar != null) {
                boolean ver = WebScrollBarUI.this.scrollbar.getOrientation() == 1;
                states = CollectionUtils.asList(ver ? "vertical" : "horizontal");
            }
            return states;
        }

        @Override
        public void setFocusable(boolean focusable) {
            super.setFocusable(false);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return WebScrollBarUI.this.displayButtons ? super.getPreferredSize() : new Dimension(0, 0);
        }
    }
}

