/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.extended.label.WebStyledLabel;
import com.alee.laf.tabbedpane.TabContainer;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.FontUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;

public class Tab
extends WebStyledLabel
implements Stateful,
UIResource {
    protected final JTabbedPane tabbedPane;

    public Tab(@NotNull JTabbedPane tabbedPane, @NotNull TabContainer tabContainer, int index) {
        super(StyleId.tabbedpaneTabTitle.at(tabContainer), tabbedPane.getTitleAt(index), tabbedPane.getIconAt(index));
        this.tabbedPane = tabbedPane;
        this.setDisplayedMnemonicIndex(tabbedPane.getDisplayedMnemonicIndexAt(index));
        this.setEnabled(tabbedPane.isEnabledAt(index));
        this.applyComponentOrientation(tabbedPane.getComponentOrientation());
        FontUtils.replaceFontUIResource(this, FontUtils.getFontUIResource(tabbedPane.getFont()));
    }

    @NotNull
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setComponent(@Nullable Component component2) {
        if (component2 != null) {
            if (this.getComponentCount() > 0) {
                this.removeAll();
            }
            this.setLayout(new BorderLayout());
            this.add(component2);
        } else {
            this.removeAll();
            this.setLayout(null);
        }
    }

    @Nullable
    public Component getComponent() {
        return this.getComponentCount() > 0 ? this.getComponent(0) : null;
    }

    @Override
    @Nullable
    public List<String> getStates() {
        ArrayList<String> states;
        if (this.tabbedPane != null) {
            states = new ArrayList<String>(2);
            int index = this.getIndex();
            if (index != -1 && index == this.tabbedPane.getSelectedIndex()) {
                states.add("selected");
            }
            states.add(BoxOrientation.get(this.tabbedPane.getTabPlacement()).name());
        } else {
            states = null;
        }
        return states;
    }

    protected int getIndex() {
        Container parent;
        int index = -1;
        if (this.tabbedPane != null && (parent = this.getParent()) != null) {
            int parentIndex = parent.getComponentZOrder(this);
            Integer removedIndex = (Integer)this.tabbedPane.getClientProperty("__index_to_remove__");
            index = removedIndex != null ? (removedIndex > parentIndex ? parentIndex : (removedIndex < parentIndex ? parentIndex - 1 : -1)) : parentIndex;
        }
        return index;
    }
}

