/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.Mergeable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.TabContainer;
import com.alee.laf.tabbedpane.TabSize;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.SizeCache;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;

@XStreamAlias(value="TabContainerLayout")
public class TabContainerLayout
extends AbstractLayoutManager
implements Mergeable,
Cloneable,
Serializable {
    @XStreamAlias(value="tabStretchType")
    @Nullable
    protected TabStretchType tabStretchType;
    @XStreamAlias(value="tabSize")
    @Nullable
    protected TabSize tabSize;
    protected transient int runCount = 1;

    @NotNull
    public TabStretchType getTabStretchType() {
        return this.tabStretchType != null ? this.tabStretchType : TabStretchType.multiline;
    }

    @Nullable
    public TabSize getTabSize() {
        return this.tabSize != null ? this.tabSize : TabSize.preferred;
    }

    public int getRunCount() {
        return this.runCount;
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        TabContainer tabContainer = (TabContainer)parent;
        SizeCache sizeCache = new SizeCache(tabContainer);
        Insets insets = tabContainer.getInsets();
        int tabPlacement = tabContainer.getTabbedPane().getTabPlacement();
        boolean horizontal = tabPlacement == 1 || tabPlacement == 3;
        int tabCount = tabContainer.getComponentCount();
        TabStretchType tabStretchType = this.getTabStretchType();
        int width = tabContainer.getWidth() - insets.left - insets.right;
        int height = tabContainer.getHeight() - insets.top - insets.bottom;
        int runWidth = 0;
        int runHeight = 0;
        int runLength = 0;
        int runStartIndex = 0;
        int x = insets.left;
        int y = insets.top;
        if (tabCount > 0) {
            int runCount = 0;
            boolean ltr = tabContainer.getTabbedPane().getComponentOrientation().isLeftToRight();
            for (int i = 0; i < tabCount; ++i) {
                Dimension cps = this.getTabPreferredSize(tabContainer, i, sizeCache);
                runWidth = horizontal ? runWidth + cps.width : Math.max(runWidth, cps.width);
                runHeight = horizontal ? Math.max(runHeight, cps.height) : runHeight + cps.height;
                runLength += horizontal ? cps.width : cps.height;
                if (i != tabCount - 1 && (!horizontal || runWidth + this.getTabPreferredSize((TabContainer)tabContainer, (int)(i + 1), (SizeCache)sizeCache).width <= width) && (horizontal || runHeight + this.getTabPreferredSize((TabContainer)tabContainer, (int)(i + 1), (SizeCache)sizeCache).height <= height)) continue;
                int runComponentCount = 1 + i - runStartIndex;
                for (int j = runStartIndex; j <= i; ++j) {
                    int h;
                    int bonus;
                    Tab tab = (Tab)tabContainer.getComponent(j);
                    Dimension tps = this.getTabPreferredSize(tabContainer, j, sizeCache);
                    if (horizontal) {
                        int w;
                        if (i == tabCount - 1) {
                            runHeight = insets.top + height - y;
                        }
                        if (tabStretchType == TabStretchType.always || tabStretchType == TabStretchType.multiline && (i < tabCount - 1 || runCount > 0)) {
                            int freeWidth = width - runLength;
                            bonus = j - runStartIndex < freeWidth % runComponentCount ? 1 : 0;
                            w = tps.width + freeWidth / runComponentCount + bonus;
                        } else {
                            w = tps.width;
                        }
                        tab.setBounds(ltr ? x : insets.left + width - (x - insets.left) - w, y, w, runHeight);
                        x += w;
                        continue;
                    }
                    if (i == tabCount - 1) {
                        runWidth = insets.left + width - x;
                    }
                    if (tabStretchType == TabStretchType.always || tabStretchType == TabStretchType.multiline && (i < tabCount - 1 || runCount > 0)) {
                        int freeHeight = height - runLength;
                        bonus = j - runStartIndex < freeHeight % runComponentCount ? 1 : 0;
                        h = tps.height + freeHeight / runComponentCount + bonus;
                    } else {
                        h = tps.height;
                    }
                    tab.setBounds(x, y, runWidth, h);
                    y += h;
                }
                x = horizontal ? insets.left : x + runWidth;
                y = horizontal ? y + runHeight : insets.top;
                runWidth = 0;
                runHeight = 0;
                runLength = 0;
                runStartIndex = i + 1;
                ++runCount;
            }
            this.runCount = runCount;
        } else {
            this.runCount = 1;
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        boolean horizontal;
        Dimension ps = new Dimension(0, 0);
        TabContainer tabContainer = (TabContainer)parent;
        SizeCache sizeCache = new SizeCache(tabContainer);
        Insets insets = tabContainer.getInsets();
        int tabLayoutPolicy = tabContainer.getTabbedPane().getTabLayoutPolicy();
        int tabPlacement = tabContainer.getTabbedPane().getTabPlacement();
        boolean bl = horizontal = tabPlacement == 1 || tabPlacement == 3;
        if (tabContainer.getWidth() == 0 || tabLayoutPolicy == 1) {
            for (int i = 0; i < tabContainer.getComponentCount(); ++i) {
                Dimension cps = this.getTabPreferredSize(tabContainer, i, sizeCache);
                ps.width = horizontal ? ps.width + cps.width : Math.max(ps.width, cps.width);
                ps.height = horizontal ? Math.max(ps.height, cps.height) : ps.height + cps.height;
            }
        } else {
            int width = tabContainer.getWidth() - insets.left - insets.right;
            int height = tabContainer.getHeight() - insets.top - insets.bottom;
            int runWidth = 0;
            int runHeight = 0;
            for (int i = 0; i < tabContainer.getComponentCount(); ++i) {
                Dimension cps = this.getTabPreferredSize(tabContainer, i, sizeCache);
                runWidth = horizontal ? runWidth + cps.width : Math.max(runWidth, cps.width);
                int n = runHeight = horizontal ? Math.max(runHeight, cps.height) : runHeight + cps.height;
                if (i != tabContainer.getComponentCount() - 1 && (!horizontal || runWidth + this.getTabPreferredSize((TabContainer)tabContainer, (int)(i + 1), (SizeCache)sizeCache).width <= width) && (horizontal || runHeight + this.getTabPreferredSize((TabContainer)tabContainer, (int)(i + 1), (SizeCache)sizeCache).height <= height)) continue;
                ps.width = horizontal ? Math.min(Math.max(ps.width, runWidth), width) : ps.width + runWidth;
                ps.height = horizontal ? ps.height + runHeight : Math.min(Math.min(ps.height, runHeight), height);
                runWidth = 0;
                runHeight = 0;
            }
        }
        SwingUtils.increase(ps, insets);
        return ps;
    }

    @NotNull
    private Dimension getTabPreferredSize(@NotNull TabContainer tabContainer, int index, @NotNull SizeCache sizeCache) {
        return this.getTabSize() == TabSize.preferred ? sizeCache.preferred(tabContainer, index) : sizeCache.maxPreferred(tabContainer);
    }

    @XStreamAlias(value="TabContainerLayout$UIResource")
    public static final class UIResource
    extends TabContainerLayout
    implements javax.swing.plaf.UIResource {
    }
}

