/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.TabbedPaneToolTipProvider;
import com.alee.laf.tabbedpane.WTabbedPaneUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.ClientProperty;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.NullableClientProperty;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class WebTabbedPane
extends JTabbedPane
implements Styleable,
EventMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebTabbedPane>,
SizeMethods<WebTabbedPane> {
    public static final String TAB_LAYOUT_POLICY_PROPERTY = "tabLayoutPolicy";
    public static final String TAB_PLACEMENT_PROPERTY = "tabPlacement";
    public static final String INDEX_FOR_TITLE_PROPERTY = "indexForTitle";
    public static final String INDEX_FOR_TAB_COMPONENT_PROPERTY = "indexForTabComponent";
    public static final String INDEX_FOR_NULL_COMPONENT_PROPERTY = "indexForNullComponent";
    public static final String FOREGROUND_AT_PROPERTY = "foregroundAt";
    public static final String BACKGROUND_AT_PROPERTY = "backgroundAt";
    public static final String ENABLED_AT_PROPERTY = "enabledAt";
    public static final String ICON_AT_PROPERTY = "iconAt";
    public static final String DISABLED_ICON_AT_PROPERTY = "disabledIconAt";
    public static final String MNEMONIC_AT_PROPERTY = "mnemonicAt";
    public static final String DISPLAYED_MNEMONIC_INDEX_AT_PROPERTY = "displayedMnemonicIndexAt";
    public static final String STYLE_ID_AT_PROPERTY = "styleIdAt";
    public static final String CHILD_STYLE_ID_AT_PROPERTY = "childStyleIdAt";
    public static final String REMOVED_TAB_INDEX = "__index_to_remove__";
    public static final ClientProperty<Boolean> HIDE_SINGLE_TAB_PROPERTY = new ClientProperty<Boolean>("hideSingleTab", false);
    public static final NullableClientProperty<TabbedPaneToolTipProvider> TOOLTIP_PROVIDER_PROPERTY = new NullableClientProperty<Object>("tooltipProvider", null);
    public static final NullableClientProperty<JComponent> LEADING_TAB_AREA_COMPONENT_PROPERTY = new NullableClientProperty<Object>("leadingTabAreaComponent", null);
    public static final NullableClientProperty<JComponent> TRAILING_TAB_AREA_COMPONENT_PROPERTY = new NullableClientProperty<Object>("trailingTabAreaComponent", null);

    public WebTabbedPane() {
        this(StyleId.auto, 1, 0);
    }

    public WebTabbedPane(int tabPlacement) {
        this(StyleId.auto, tabPlacement, 0);
    }

    public WebTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        this(StyleId.auto, tabPlacement, tabLayoutPolicy);
    }

    public WebTabbedPane(@NotNull StyleId id) {
        this(id, 1, 0);
    }

    public WebTabbedPane(@NotNull StyleId id, int tabPlacement) {
        this(id, tabPlacement, 0);
    }

    public WebTabbedPane(@NotNull StyleId id, int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.setStyleId(id);
    }

    @NotNull
    public Tab getTab(int index) {
        return this.getUI().getTab(index);
    }

    @Override
    public void setForegroundAt(int index, @Nullable Color foreground) {
        if (this.getForegroundAt(index) != foreground) {
            super.setForegroundAt(index, foreground);
            this.firePropertyChange(FOREGROUND_AT_PROPERTY, null, (Object)index);
        }
    }

    @Override
    public void setBackgroundAt(int index, @Nullable Color background) {
        if (this.getBackgroundAt(index) != background) {
            super.setBackgroundAt(index, background);
            this.firePropertyChange(BACKGROUND_AT_PROPERTY, null, (Object)index);
        }
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        if (this.isEnabledAt(index) != enabled) {
            super.setEnabledAt(index, enabled);
            this.firePropertyChange(ENABLED_AT_PROPERTY, null, (Object)index);
        }
    }

    @Override
    public void setIconAt(int index, @Nullable Icon icon) {
        if (this.getIconAt(index) != icon) {
            super.setIconAt(index, icon);
            this.firePropertyChange(ICON_AT_PROPERTY, null, (Object)index);
        }
    }

    @Override
    public void setDisabledIconAt(int index, @Nullable Icon disabledIcon) {
        if (this.getDisabledIconAt(index) != disabledIcon) {
            super.setDisabledIconAt(index, disabledIcon);
            this.firePropertyChange(DISABLED_ICON_AT_PROPERTY, null, (Object)index);
        }
    }

    @NotNull
    public StyleId getStyleIdAt(int index) {
        return this.getUI().getStyleIdAt(index);
    }

    public void setStyleIdAt(int index, @NotNull StyleId styleId) {
        this.firePropertyChange(STYLE_ID_AT_PROPERTY, null, new Object[]{index, styleId});
    }

    public void setStyleIdAt(int index, @NotNull ChildStyleId styleId) {
        this.firePropertyChange(CHILD_STYLE_ID_AT_PROPERTY, null, new Object[]{index, styleId});
    }

    public int getTabAt(@NotNull Point point) {
        return this.getTabAt(point.x, point.y);
    }

    public int getTabAt(int x, int y) {
        return this.indexAtLocation(x, y);
    }

    @Nullable
    public Rectangle getBoundsAt(@NotNull Point point) {
        return this.getBoundsAt(point.x, point.y);
    }

    @Nullable
    public Rectangle getBoundsAt(int x, int y) {
        int index = this.getTabAt(x, y);
        return index != -1 ? this.getBoundsAt(index) : null;
    }

    public boolean isHideSingleTab() {
        return HIDE_SINGLE_TAB_PROPERTY.get(this);
    }

    public void setHideSingleTab(boolean hide) {
        HIDE_SINGLE_TAB_PROPERTY.set(this, hide);
    }

    @Nullable
    public TabbedPaneToolTipProvider getToolTipProvider() {
        return TOOLTIP_PROVIDER_PROPERTY.get(this);
    }

    public void setToolTipProvider(@Nullable TabbedPaneToolTipProvider provider) {
        TOOLTIP_PROVIDER_PROPERTY.set(this, provider);
    }

    @Nullable
    public JComponent getLeadingTabAreaComponent() {
        return LEADING_TAB_AREA_COMPONENT_PROPERTY.get(this);
    }

    @Nullable
    public JComponent setLeadingTabAreaComponent(@Nullable JComponent component2) {
        JComponent old = LEADING_TAB_AREA_COMPONENT_PROPERTY.get(this);
        LEADING_TAB_AREA_COMPONENT_PROPERTY.set(this, component2);
        return old;
    }

    @Nullable
    public JComponent getTrailingTabAreaComponent() {
        return TRAILING_TAB_AREA_COMPONENT_PROPERTY.get(this);
    }

    @Nullable
    public JComponent setTrailingTabAreaComponent(@Nullable JComponent component2) {
        JComponent old = TRAILING_TAB_AREA_COMPONENT_PROPERTY.get(this);
        TRAILING_TAB_AREA_COMPONENT_PROPERTY.set(this, component2);
        return old;
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.tabbedpane;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain(this, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, mouseButton, runnable);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this);
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebTabbedPane setPlainFont() {
        return (WebTabbedPane)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebTabbedPane setPlainFont(boolean apply2) {
        return (WebTabbedPane)FontMethodsImpl.setPlainFont(this, apply2);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebTabbedPane setBoldFont() {
        return (WebTabbedPane)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebTabbedPane setBoldFont(boolean apply2) {
        return (WebTabbedPane)FontMethodsImpl.setBoldFont(this, apply2);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebTabbedPane setItalicFont() {
        return (WebTabbedPane)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebTabbedPane setItalicFont(boolean apply2) {
        return (WebTabbedPane)FontMethodsImpl.setItalicFont(this, apply2);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebTabbedPane setFontStyle(boolean bold, boolean italic) {
        return (WebTabbedPane)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTabbedPane setFontStyle(int style) {
        return (WebTabbedPane)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebTabbedPane setFontSize(int fontSize) {
        return (WebTabbedPane)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebTabbedPane changeFontSize(int change) {
        return (WebTabbedPane)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebTabbedPane setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebTabbedPane)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTabbedPane setFontSizeAndStyle(int fontSize, int style) {
        return (WebTabbedPane)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTabbedPane setFontName(String fontName) {
        return (WebTabbedPane)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebTabbedPane setPreferredWidth(int preferredWidth) {
        return (WebTabbedPane)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebTabbedPane setPreferredHeight(int preferredHeight) {
        return (WebTabbedPane)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebTabbedPane setPreferredSize(int width, int height) {
        return (WebTabbedPane)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebTabbedPane setMaximumWidth(int maximumWidth) {
        return (WebTabbedPane)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebTabbedPane setMaximumHeight(int maximumHeight) {
        return (WebTabbedPane)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebTabbedPane setMaximumSize(int width, int height) {
        return (WebTabbedPane)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebTabbedPane setMinimumWidth(int minimumWidth) {
        return (WebTabbedPane)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebTabbedPane setMinimumHeight(int minimumHeight) {
        return (WebTabbedPane)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebTabbedPane setMinimumSize(int width, int height) {
        return (WebTabbedPane)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WTabbedPaneUI getUI() {
        return (WTabbedPaneUI)super.getUI();
    }

    public void setUI(WTabbedPaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

