/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.table.ITableHeaderPainter;
import com.alee.laf.table.TableHeaderCellArea;
import com.alee.laf.table.TableHeaderToolTipProvider;
import com.alee.laf.table.WTableHeaderUI;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageSensitive;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.style.Bounds;
import com.alee.painter.AbstractPainter;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableHeaderPainter<C extends JTableHeader, U extends WTableHeaderUI>
extends AbstractPainter<C, U>
implements ITableHeaderPainter<C, U> {
    protected transient MouseAdapter mouseAdapter;
    protected transient LanguageListener languageSensitive;
    protected transient TableHeaderCellArea rolloverCell;
    protected Integer headerHeight;
    protected Color topBgColor;
    protected Color bottomBgColor;
    protected Color gridColor;
    protected transient CellRendererPane rendererPane = null;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installTableMouseListeners();
        this.installLanguageListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallLanguageListeners();
        this.uninstallTableMouseListeners();
        super.uninstallPropertiesAndListeners();
    }

    protected void installTableMouseListeners() {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TableHeaderPainter.this.component != null) {
                    this.updateMouseover(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TableHeaderPainter.this.component != null) {
                    this.updateMouseover(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (TableHeaderPainter.this.component != null) {
                    this.clearMouseover();
                }
            }

            private void updateMouseover(MouseEvent e) {
                Point point = e.getPoint();
                int column = ((JTableHeader)TableHeaderPainter.this.component).columnAtPoint(point);
                if (column != -1) {
                    TableHeaderCellArea cell = new TableHeaderCellArea(0, column);
                    if (Objects.notEquals((Object)TableHeaderPainter.this.rolloverCell, cell)) {
                        this.updateRolloverCell(TableHeaderPainter.this.rolloverCell, cell);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                if (TableHeaderPainter.this.rolloverCell != null) {
                    this.updateRolloverCell(TableHeaderPainter.this.rolloverCell, null);
                }
            }

            private void updateRolloverCell(TableHeaderCellArea oldCell, TableHeaderCellArea newCell) {
                TableHeaderPainter.this.rolloverCell = newCell;
                TableHeaderToolTipProvider tableProvider = TableHeaderPainter.this.getTableToolTipProvider();
                if (tableProvider != null) {
                    tableProvider.hoverAreaChanged(TableHeaderPainter.this.component, oldCell, newCell);
                } else {
                    TableHeaderToolTipProvider headerProvider = TableHeaderPainter.this.getHeaderToolTipProvider();
                    if (headerProvider != null) {
                        headerProvider.hoverAreaChanged(TableHeaderPainter.this.component, oldCell, newCell);
                    }
                }
            }
        };
        ((JTableHeader)this.component).addMouseListener(this.mouseAdapter);
        ((JTableHeader)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    protected void uninstallTableMouseListeners() {
        ((JTableHeader)this.component).removeMouseListener(this.mouseAdapter);
        ((JTableHeader)this.component).removeMouseMotionListener(this.mouseAdapter);
        this.mouseAdapter = null;
    }

    @Nullable
    protected TableHeaderToolTipProvider getTableToolTipProvider() {
        return this.component != null && ((JTableHeader)this.component).getTable() != null ? (TableHeaderToolTipProvider)((JTableHeader)this.component).getTable().getClientProperty("headerTooltipProvider") : null;
    }

    @Nullable
    protected TableHeaderToolTipProvider getHeaderToolTipProvider() {
        return this.component != null ? (TableHeaderToolTipProvider)((JTableHeader)this.component).getClientProperty("tooltipProvider") : null;
    }

    protected void installLanguageListeners() {
        this.languageSensitive = new LanguageListener(){

            @Override
            public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                if (TableHeaderPainter.this.isLanguageSensitive()) {
                    JTable table2 = ((JTableHeader)TableHeaderPainter.this.component).getTable();
                    if (table2 != null && table2.getModel() instanceof AbstractTableModel) {
                        AbstractTableModel tableModel = (AbstractTableModel)table2.getModel();
                        tableModel.fireTableRowsUpdated(-1, -1);
                    } else {
                        ((JTableHeader)TableHeaderPainter.this.component).repaint();
                    }
                }
            }
        };
        UILanguageManager.addLanguageListener(this.component, this.languageSensitive);
    }

    protected boolean isLanguageSensitive() {
        boolean sensitive = false;
        if (this.component instanceof LanguageSensitive || ((JTableHeader)this.component).getDefaultRenderer() instanceof LanguageSensitive || ((JTableHeader)this.component).getTable() instanceof LanguageSensitive || ((JTableHeader)this.component).getTable() != null && ((JTableHeader)this.component).getTable().getModel() instanceof LanguageSensitive) {
            sensitive = true;
        } else {
            int i;
            TableColumnModel columnModel = ((JTableHeader)this.component).getColumnModel();
            for (i = 0; i < columnModel.getColumnCount(); ++i) {
                if (!(this.getHeaderRenderer(i) instanceof LanguageSensitive)) continue;
                sensitive = true;
                break;
            }
            if (!sensitive) {
                for (i = 0; i < columnModel.getColumnCount(); ++i) {
                    if (!(columnModel.getColumn(i).getHeaderValue() instanceof LanguageSensitive)) continue;
                    sensitive = true;
                    break;
                }
            }
        }
        return sensitive;
    }

    protected void uninstallLanguageListeners() {
        UILanguageManager.removeLanguageListener(this.component, this.languageSensitive);
        this.languageSensitive = null;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        this.rendererPane = ((WTableHeaderUI)ui).getCellRendererPane();
        Paint bgPaint = this.getBackgroundPaint(0, 0, 0, ((JTableHeader)this.component).getHeight() - 1);
        g2d.setPaint(bgPaint);
        g2d.fillRect(0, 0, ((JTableHeader)this.component).getWidth(), ((JTableHeader)this.component).getHeight() - 1);
        g2d.setPaint(this.gridColor);
        g2d.drawLine(0, ((JTableHeader)this.component).getHeight() - 1, ((JTableHeader)this.component).getWidth() - 1, ((JTableHeader)this.component).getHeight() - 1);
        if (((JTableHeader)this.component).getColumnModel().getColumnCount() > 0) {
            int column;
            Rectangle clip = g2d.getClipBounds();
            Point left = clip.getLocation();
            Point right = new Point(clip.x + clip.width - 1, clip.y);
            TableColumnModel cm = ((JTableHeader)this.component).getColumnModel();
            int cMin = ((JTableHeader)this.component).columnAtPoint(this.ltr ? left : right);
            int cMax = ((JTableHeader)this.component).columnAtPoint(this.ltr ? right : left);
            if (cMin == -1) {
                cMin = 0;
            }
            if (cMax == -1) {
                cMax = cm.getColumnCount() - 1;
            }
            TableColumn draggedColumn = ((JTableHeader)this.component).getDraggedColumn();
            Rectangle cellRect = ((JTableHeader)this.component).getHeaderRect(this.ltr ? cMin : cMax);
            if (this.ltr) {
                for (column = cMin; column <= cMax; ++column) {
                    int columnWidth;
                    TableColumn aColumn = cm.getColumn(column);
                    cellRect.width = columnWidth = aColumn.getWidth();
                    if (aColumn != draggedColumn) {
                        this.paintCell(g2d, c, cellRect, column, aColumn, draggedColumn, cm);
                    }
                    cellRect.x += columnWidth;
                }
            } else {
                for (column = cMax; column >= cMin; --column) {
                    int columnWidth;
                    TableColumn aColumn = cm.getColumn(column);
                    cellRect.width = columnWidth = aColumn.getWidth();
                    if (aColumn != draggedColumn) {
                        this.paintCell(g2d, c, cellRect, column, aColumn, draggedColumn, cm);
                    }
                    cellRect.x += columnWidth;
                }
            }
            if (draggedColumn != null) {
                int draggedColumnIndex = this.getViewIndexForColumn(draggedColumn);
                Rectangle draggedCellRect = ((JTableHeader)this.component).getHeaderRect(draggedColumnIndex);
                draggedCellRect.x += ((JTableHeader)this.component).getDraggedDistance();
                g2d.setPaint(bgPaint);
                g2d.fillRect(draggedCellRect.x - 1, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height - 1);
                this.paintCell(g2d, c, draggedCellRect, draggedColumnIndex, draggedColumn, draggedColumn, cm);
            }
            this.rendererPane.removeAll();
        }
        this.rendererPane = null;
    }

    protected void paintCell(Graphics2D g2d, C c, Rectangle rect, int columnIndex, TableColumn column, TableColumn draggedColumn, TableColumnModel columnModel) {
        boolean paintTrailingBorder;
        JTable table2 = ((JTableHeader)c).getTable();
        JScrollPane scrollPane = SwingUtils.getScrollPane(table2);
        boolean bl = scrollPane != null && (column == draggedColumn || table2.getAutoResizeMode() == 0 && scrollPane.getViewport().getWidth() > table2.getWidth() || (this.ltr ? columnIndex != columnModel.getColumnCount() - 1 : columnIndex != 0)) ? true : (paintTrailingBorder = false);
        if (this.ltr || paintTrailingBorder) {
            g2d.setColor(this.gridColor);
            g2d.drawLine(rect.x - 1, rect.y + 2, rect.x - 1, rect.y + rect.height - 4);
        }
        JComponent headerRenderer = (JComponent)this.getHeaderRenderer(columnIndex);
        headerRenderer.setOpaque(false);
        headerRenderer.setEnabled(table2 == null || table2.isEnabled());
        this.rendererPane.paintComponent(g2d, headerRenderer, this.component, rect.x, rect.y, rect.width, rect.height, true);
        if (!this.ltr || paintTrailingBorder) {
            g2d.setColor(this.gridColor);
            g2d.drawLine(rect.x + rect.width - 1, rect.y + 2, rect.x + rect.width - 1, rect.y + rect.height - 4);
        }
    }

    protected Paint getBackgroundPaint(int x1, int y1, int x2, int y2) {
        Paint background = this.bottomBgColor == null || Objects.equals((Object)this.topBgColor, (Object)this.bottomBgColor) ? this.topBgColor : new GradientPaint(x1, y1, this.topBgColor, x2, y2, this.bottomBgColor);
        return background;
    }

    protected Component getHeaderRenderer(int index) {
        TableColumn aColumn = ((JTableHeader)this.component).getColumnModel().getColumn(index);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = ((JTableHeader)this.component).getDefaultRenderer();
        }
        boolean hasFocus = !((JTableHeader)this.component).isPaintingForPrint() && ((JTableHeader)this.component).hasFocus();
        return renderer.getTableCellRendererComponent(((JTableHeader)this.component).getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, index);
    }

    protected int getViewIndexForColumn(TableColumn column) {
        int viewIndex = -1;
        TableColumnModel cm = ((JTableHeader)this.component).getColumnModel();
        for (int index = 0; index < cm.getColumnCount(); ++index) {
            if (cm.getColumn(index) != column) continue;
            viewIndex = index;
            break;
        }
        return viewIndex;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.headerHeight != null) {
            ps.height = Math.max(ps.height, this.headerHeight);
        }
        return ps;
    }
}

