/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.table.TableHeaderToolTipProvider;
import com.alee.laf.table.TableRowHeightOptimizer;
import com.alee.laf.table.TableToolTipProvider;
import com.alee.laf.table.WebTableHeader;
import com.alee.laf.table.WebTableUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WebTable
extends JTable
implements Styleable,
EventMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebTable>,
SizeMethods<WebTable> {
    public static final String TABLE_HEADER_PROPERTY = "tableHeader";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String HEADER_TOOLTIP_PROVIDER_PROPERTY = "headerTooltipProvider";
    public static final String TOOLTIP_PROVIDER_PROPERTY = "tooltipProvider";
    protected boolean editable = true;
    protected int visibleRowCount = 10;
    protected transient TableRowHeightOptimizer rowHeightOptimizer;

    public WebTable() {
        this(StyleId.auto);
    }

    public WebTable(TableModel model) {
        this(StyleId.auto, model);
    }

    public WebTable(TableModel model, TableColumnModel columnModel) {
        this(StyleId.auto, model, columnModel);
    }

    public WebTable(TableModel model, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        this(StyleId.auto, model, columnModel, selectionModel);
    }

    public WebTable(int rows, int columns) {
        this(StyleId.auto, rows, columns);
    }

    public WebTable(Vector data, Vector columnNames) {
        this(StyleId.auto, data, columnNames);
    }

    public WebTable(Object[][] data, Object[] columnNames) {
        this(StyleId.auto, data, columnNames);
    }

    public WebTable(StyleId id) {
        this(id, null, null, null);
    }

    public WebTable(StyleId id, int rows, int columns) {
        this(id, new DefaultTableModel(rows, columns), null, null);
    }

    public WebTable(StyleId id, Vector data, Vector columnNames) {
        this(id, new DefaultTableModel(data, columnNames), null, null);
    }

    public WebTable(StyleId id, Object[][] data, Object[] columnNames) {
        this(id, new DefaultTableModel(data, columnNames), null, null);
    }

    public WebTable(StyleId id, TableModel model) {
        this(id, model, null, null);
    }

    public WebTable(StyleId id, TableModel model, TableColumnModel columnModel) {
        this(id, model, columnModel, null);
    }

    public WebTable(StyleId id, TableModel model, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        super(model, columnModel, selectionModel);
        this.setStyleId(id);
    }

    @Override
    protected WebTableHeader createDefaultTableHeader() {
        return new WebTableHeader(this.getColumnModel());
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.table;
    }

    public TableHeaderToolTipProvider getHeaderToolTipProvider() {
        return (TableHeaderToolTipProvider)this.getClientProperty(HEADER_TOOLTIP_PROVIDER_PROPERTY);
    }

    public void setHeaderToolTipProvider(TableHeaderToolTipProvider provider) {
        this.putClientProperty(HEADER_TOOLTIP_PROVIDER_PROPERTY, provider);
    }

    public TableToolTipProvider getToolTipProvider() {
        return (TableToolTipProvider)this.getClientProperty(TOOLTIP_PROVIDER_PROPERTY);
    }

    public void setToolTipProvider(TableToolTipProvider provider) {
        this.putClientProperty(TOOLTIP_PROVIDER_PROPERTY, provider);
    }

    public boolean isOptimizeRowHeight() {
        return this.rowHeightOptimizer != null;
    }

    public void setOptimizeRowHeight(boolean optimize) {
        if (optimize) {
            if (this.rowHeightOptimizer == null) {
                this.rowHeightOptimizer = new TableRowHeightOptimizer(this);
                this.rowHeightOptimizer.install();
            }
        } else if (this.rowHeightOptimizer != null) {
            this.rowHeightOptimizer.uninstall();
            this.rowHeightOptimizer = null;
        }
    }

    public void optimizeColumnWidths() {
        this.optimizeColumnWidths(false, 20, Integer.MAX_VALUE);
    }

    public void optimizeColumnWidths(boolean processData) {
        this.optimizeColumnWidths(processData, 20, Integer.MAX_VALUE);
    }

    public void optimizeColumnWidths(boolean processData, int minWidth, int maxWidth) {
        if (this.getTableHeader() != null || processData) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                int width = this.getOptimalColumnWidth(column, processData, minWidth, maxWidth);
                this.getColumnModel().getColumn(column).setPreferredWidth(width);
            }
        }
    }

    protected int getOptimalColumnWidth(int column, boolean processData, int minWidth, int maxWidth) {
        int width = 0;
        JTableHeader th = this.getTableHeader();
        if (th != null) {
            Object value = th.getColumnModel().getColumn(column).getHeaderValue();
            TableCellRenderer hr = th.getDefaultRenderer();
            Component r = hr.getTableCellRendererComponent(this, value, false, false, -1, column);
            width = Math.max(width, r.getPreferredSize().width);
        }
        if (processData) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object value = this.getModel().getValueAt(row, column);
                TableCellRenderer cr = this.getCellRenderer(row, column);
                Component r = cr.getTableCellRendererComponent(this, value, false, false, row, column);
                width = Math.max(width, r.getPreferredSize().width);
            }
        }
        return Math.max(minWidth, Math.min(width, maxWidth));
    }

    public void setSelectedRow(int row) {
        this.setSelectedRow(row, true);
    }

    public void setSelectedRow(int row, boolean scroll) {
        this.clearSelection();
        this.addSelectedRow(row);
        if (row != -1 && scroll) {
            this.scrollToRow(row);
        }
    }

    public void addSelectedRow(int row) {
        if (row != -1) {
            this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
            this.addRowSelectionInterval(row, row);
        }
    }

    public void setSelectedRows(int startRow, int endRow) {
        this.clearSelection();
        this.addSelectedRows(startRow, endRow);
    }

    public void addSelectedRows(int startRow, int endRow) {
        if (startRow != -1 && endRow != -1) {
            this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
            this.addRowSelectionInterval(startRow, endRow);
        }
    }

    public void setSelectedColumn(int column) {
        this.setSelectedColumn(column, true);
    }

    public void setSelectedColumn(int column, boolean scroll) {
        this.clearSelection();
        this.addSelectedColumn(column);
        if (scroll) {
            this.scrollToColumn(column);
        }
    }

    public void addSelectedColumn(int column) {
        if (column != -1) {
            this.addColumnSelectionInterval(column, column);
            this.addRowSelectionInterval(0, this.getRowCount() - 1);
        }
    }

    public void setSelectedColumns(int startColumn, int endColumn) {
        this.clearSelection();
        this.addSelectedColumns(startColumn, endColumn);
    }

    public void addSelectedColumns(int startColumn, int endColumn) {
        if (startColumn != -1 && endColumn != -1) {
            this.addColumnSelectionInterval(startColumn, endColumn);
            this.addRowSelectionInterval(0, this.getRowCount() - 1);
        }
    }

    public void scrollToRow(int row) {
        Rectangle lastCell;
        Rectangle firstCell = this.getCellRect(row, 0, true);
        Rectangle rect = GeometryUtils.getContainingRect(firstCell, lastCell = this.getCellRect(row, this.getColumnCount() - 1, true));
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    public void scrollToColumn(int column) {
        Rectangle lastCell;
        Rectangle firstCell = this.getCellRect(0, column, true);
        Rectangle rect = GeometryUtils.getContainingRect(firstCell, lastCell = this.getCellRect(this.getRowCount() - 1, column, true));
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject event) {
        boolean editingStarted = super.editCellAt(row, column, event);
        if (editingStarted) {
            try {
                TableCellEditor cellEditor = this.getCellEditor();
                Component editorComponent = (Component)ReflectUtils.callMethod(cellEditor, "getComponent", new Object[0]);
                editorComponent.requestFocusInWindow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return editingStarted;
    }

    public boolean stopCellEditing() {
        TableCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable && super.isCellEditable(row, column);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        this.setPreferredScrollableViewportSize(null);
        JScrollPane scrollPane = SwingUtils.getScrollPane(this);
        if (scrollPane != null) {
            scrollPane.getViewport().invalidate();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredViewportSize != null) {
            return this.preferredViewportSize;
        }
        if (this.visibleRowCount != -1) {
            int rowHeight;
            if (this.getRowCount() > 0) {
                Rectangle r = this.getCellRect(0, 0, true);
                rowHeight = r.height;
            } else {
                rowHeight = this.getRowHeight();
            }
            Dimension ps = this.getPreferredSize();
            ps.height = this.visibleRowCount * rowHeight;
            return ps;
        }
        return this.getPreferredSize();
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setPreferredScrollableViewportSize(null);
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain(this, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, mouseButton, runnable);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this);
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this, listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this, listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this);
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this, listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this, listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this);
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebTable setPlainFont() {
        return (WebTable)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebTable setPlainFont(boolean apply2) {
        return (WebTable)FontMethodsImpl.setPlainFont(this, apply2);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebTable setBoldFont() {
        return (WebTable)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebTable setBoldFont(boolean apply2) {
        return (WebTable)FontMethodsImpl.setBoldFont(this, apply2);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebTable setItalicFont() {
        return (WebTable)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebTable setItalicFont(boolean apply2) {
        return (WebTable)FontMethodsImpl.setItalicFont(this, apply2);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebTable setFontStyle(boolean bold, boolean italic) {
        return (WebTable)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTable setFontStyle(int style) {
        return (WebTable)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebTable setFontSize(int fontSize) {
        return (WebTable)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebTable changeFontSize(int change) {
        return (WebTable)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebTable setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebTable)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTable setFontSizeAndStyle(int fontSize, int style) {
        return (WebTable)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTable setFontName(String fontName) {
        return (WebTable)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebTable setPreferredWidth(int preferredWidth) {
        return (WebTable)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebTable setPreferredHeight(int preferredHeight) {
        return (WebTable)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebTable setPreferredSize(int width, int height) {
        return (WebTable)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebTable setMaximumWidth(int maximumWidth) {
        return (WebTable)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebTable setMaximumHeight(int maximumHeight) {
        return (WebTable)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebTable setMaximumSize(int width, int height) {
        return (WebTable)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebTable setMinimumWidth(int minimumWidth) {
        return (WebTable)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebTable setMinimumHeight(int minimumHeight) {
        return (WebTable)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebTable setMinimumSize(int width, int height) {
        return (WebTable)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WebTableUI getUI() {
        return (WebTableUI)super.getUI();
    }

    public void setUI(WebTableUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }

    protected void configureScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Component corner = scrollPane.getCorner("UPPER_TRAILING_CORNER");
            if (corner == null || corner instanceof UIResource) {
                corner = null;
                Object componentClass = UIManager.get("Table.scrollPaneCornerComponent");
                if (componentClass instanceof Class) {
                    try {
                        corner = (Component)((Class)componentClass).newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                scrollPane.setCorner("UPPER_TRAILING_CORNER", corner);
            }
        }
    }
}

