/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Corner;
import com.alee.extended.canvas.WebCanvas;
import com.alee.laf.scroll.ScrollPaneCornerProvider;
import com.alee.laf.table.WTableUI;
import com.alee.laf.table.editors.WebBooleanEditor;
import com.alee.laf.table.editors.WebDateEditor;
import com.alee.laf.table.editors.WebGenericEditor;
import com.alee.laf.table.editors.WebNumberEditor;
import com.alee.laf.table.renderers.WebTableBooleanCellRenderer;
import com.alee.laf.table.renderers.WebTableCellRenderer;
import com.alee.laf.table.renderers.WebTableDateCellRenderer;
import com.alee.laf.table.renderers.WebTableDoubleCellRenderer;
import com.alee.laf.table.renderers.WebTableFloatCellRenderer;
import com.alee.laf.table.renderers.WebTableIconCellRenderer;
import com.alee.laf.table.renderers.WebTableNumberCellRenderer;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;

public class WebTableUI
extends WTableUI
implements ScrollPaneCornerProvider {
    protected transient PropertyChangeListener propertyChangeListener;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebTableUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        this.table.setDefaultRenderer(Object.class, new WebTableCellRenderer.UIResource());
        this.table.setDefaultRenderer(Number.class, new WebTableNumberCellRenderer.UIResource());
        this.table.setDefaultRenderer(Double.class, new WebTableDoubleCellRenderer.UIResource());
        this.table.setDefaultRenderer(Float.class, new WebTableFloatCellRenderer.UIResource());
        this.table.setDefaultRenderer(Date.class, new WebTableDateCellRenderer.UIResource());
        this.table.setDefaultRenderer(Icon.class, new WebTableIconCellRenderer.UIResource());
        this.table.setDefaultRenderer(ImageIcon.class, new WebTableIconCellRenderer.UIResource());
        this.table.setDefaultRenderer(Boolean.class, new WebTableBooleanCellRenderer.UIResource());
        this.table.setDefaultEditor(Object.class, new WebGenericEditor());
        this.table.setDefaultEditor(Number.class, new WebNumberEditor());
        this.table.setDefaultEditor(Boolean.class, new WebBooleanEditor());
        this.table.setDefaultEditor(Date.class, new WebDateEditor());
        this.updateTableHeaderStyleId();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                WebTableUI.this.updateTableHeaderStyleId();
            }
        };
        this.table.addPropertyChangeListener("tableHeader", this.propertyChangeListener);
        StyleManager.installSkin(this.table);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.table);
        this.table.removePropertyChangeListener("tableHeader", this.propertyChangeListener);
        this.propertyChangeListener = null;
        super.uninstallUI(c);
    }

    protected void updateTableHeaderStyleId() {
        JTableHeader header = this.table.getTableHeader();
        if (header != null) {
            StyleId.tableHeader.at(this.table).set(header);
        }
    }

    @Override
    @Nullable
    public JComponent getCorner(@NotNull Corner type) {
        return type == Corner.upperTrailing ? new WebCanvas(StyleId.tableCorner.at(this.table), type.name()) : null;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    @NotNull
    public CellRendererPane getCellRendererPane() {
        return this.rendererPane;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

