/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.toolbar.IToolBarPainter;
import com.alee.laf.toolbar.WebToolBarUI;
import com.alee.painter.decoration.AbstractContainerPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ToolBarPainter<C extends JToolBar, U extends WebToolBarUI, D extends IDecoration<C, D>>
extends AbstractContainerPainter<C, U, D>
implements IToolBarPainter<C, U> {
    protected transient AncestorListener ancestorListener;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installFloatingModeListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallFloatingModeListeners();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, "floatable", "orientation")) {
            this.updateDecorationState();
        }
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(((JToolBar)this.component).getOrientation() == 0 ? "horizontal" : "vertical");
        states.add(((WebToolBarUI)this.ui).isFloating() ? "floating" : "attached");
        return states;
    }

    protected void installFloatingModeListeners() {
        this.ancestorListener = new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ToolBarPainter.this.updateDecorationState();
            }
        };
        ((JToolBar)this.component).addAncestorListener(this.ancestorListener);
    }

    protected void uninstallFloatingModeListeners() {
        ((JToolBar)this.component).removeAncestorListener(this.ancestorListener);
        this.ancestorListener = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
    }
}

