/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.layout.AbstractLineLayout;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.laf.WebLookAndFeel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WhiteSpace
extends JComponent
implements SwingConstants {
    private int spacing;
    private int orientation;

    public WhiteSpace() {
        this(2);
    }

    public WhiteSpace(int spacing) {
        this(spacing, -1);
    }

    public WhiteSpace(int spacing, int orientation) {
        WebLookAndFeel.setOrientation(this);
        this.setSpacing(spacing);
        this.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.orientation;
    }

    protected int getActualOrientation() {
        int orientation;
        Container container = this.getParent();
        if (container != null) {
            LayoutManager layoutManager = container.getLayout();
            if (layoutManager instanceof AbstractLineLayout) {
                AbstractLineLayout layout = (AbstractLineLayout)layoutManager;
                orientation = layout.getOrientation(container);
            } else {
                BoxLayout layout;
                int axis;
                orientation = layoutManager instanceof BoxLayout ? ((axis = (layout = (BoxLayout)layoutManager).getAxis()) == 2 || axis == 0 ? 0 : 1) : (layoutManager instanceof HorizontalFlowLayout || layoutManager instanceof FlowLayout ? 0 : (layoutManager instanceof VerticalFlowLayout ? 1 : this.orientation));
            }
        } else {
            orientation = this.orientation;
        }
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public Dimension getPreferredSize() {
        int orientation = this.getActualOrientation();
        int width = orientation != 1 ? this.spacing : 0;
        int height = orientation != 0 ? this.spacing : 0;
        return new Dimension(width, height);
    }
}

