/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Predicate;
import com.alee.laf.tree.TreeNodeEventRunnable;
import com.alee.laf.tree.WebTree;
import com.alee.utils.SwingUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.MutableTreeNode;

public final class TreeEventMethodsImpl {
    @NotNull
    public static <N extends MutableTreeNode> MouseAdapter onNodeDoubleClick(@NotNull WebTree<N> tree, @NotNull TreeNodeEventRunnable<N> runnable) {
        return TreeEventMethodsImpl.onNodeDoubleClick(tree, null, runnable);
    }

    @NotNull
    public static <N extends MutableTreeNode> MouseAdapter onNodeDoubleClick(final @NotNull WebTree<N> tree, final @Nullable Predicate<N> condition, final @NotNull TreeNodeEventRunnable<N> runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Object node;
                int row;
                if (SwingUtils.isDoubleClick(e) && (row = tree.getUI().getExactRowForLocation(e.getPoint())) != -1 && (node = tree.getNodeForRow(row)) != null && (condition == null || condition.test(node))) {
                    runnable.run(node);
                }
            }
        };
        tree.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }
}

