/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.jdk.Objects;
import com.alee.api.ui.RenderingParameters;
import com.alee.laf.tree.TreeCellArea;
import com.alee.laf.tree.TreeUtils;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeNodeParameters<N extends TreeNode, C extends JTree>
implements RenderingParameters {
    protected final C tree;
    protected final N node;
    protected final int row;
    protected final boolean leaf;
    protected final boolean selected;
    protected final boolean expanded;
    protected final boolean focused;

    public TreeNodeParameters(C tree, TreeCellArea<? extends N, C> area) {
        this(tree, (TreeNode)((JTree)tree).getPathForRow(area.row()).getLastPathComponent());
    }

    public TreeNodeParameters(C tree, N node) {
        TreePath treePath = TreeUtils.getTreePath(node);
        this.tree = (JTree)Objects.requireNonNull(tree, "Tree must not be null");
        this.node = node;
        this.row = ((JTree)tree).getRowForPath(treePath);
        this.leaf = ((JTree)tree).getModel().isLeaf(node);
        this.selected = ((JTree)tree).isPathSelected(treePath);
        this.expanded = ((JTree)tree).isExpanded(treePath);
        this.focused = ((Component)tree).hasFocus() && ((JTree)tree).getLeadSelectionRow() == this.row;
    }

    public TreeNodeParameters(C tree, N node, int row, boolean leaf, boolean selected, boolean expanded, boolean focused) {
        this.tree = (JTree)Objects.requireNonNull(tree, "Tree must not be null");
        this.node = node;
        this.row = row;
        this.leaf = leaf;
        this.selected = selected;
        this.expanded = expanded;
        this.focused = focused;
    }

    public C tree() {
        return this.tree;
    }

    public N node() {
        return this.node;
    }

    public int row() {
        return this.row;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isFocused() {
        return this.focused;
    }
}

