/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.jdk.Predicate;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebExTree;
import com.alee.laf.tree.ITreeDropLocationPainter;
import com.alee.laf.tree.ITreeNodePainter;
import com.alee.laf.tree.ITreePainter;
import com.alee.laf.tree.ITreeRowPainter;
import com.alee.laf.tree.ITreeSelectionPainter;
import com.alee.laf.tree.ITreeSelectorPainter;
import com.alee.laf.tree.TreeDropLocationPainter;
import com.alee.laf.tree.TreeNodePainter;
import com.alee.laf.tree.TreePaintParameters;
import com.alee.laf.tree.TreeRowPainter;
import com.alee.laf.tree.TreeSelectionPainter;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.TreeSelectorPainter;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.WTreeUI;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageSensitive;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.style.BoundsType;
import com.alee.painter.DefaultPainter;
import com.alee.painter.PainterSupport;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.IDecorationPainter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePainter<C extends JTree, U extends WTreeUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements ITreePainter<C, U> {
    protected boolean paintLines;
    protected boolean dashedLines;
    protected Color linesColor;
    @DefaultPainter(value=TreeRowPainter.class)
    protected ITreeRowPainter rowPainter;
    @DefaultPainter(value=TreeNodePainter.class)
    protected ITreeNodePainter nodePainter;
    @DefaultPainter(value=TreeSelectionPainter.class)
    protected ITreeSelectionPainter selectionPainter;
    @DefaultPainter(value=TreeDropLocationPainter.class)
    protected ITreeDropLocationPainter dropLocationPainter;
    @DefaultPainter(value=TreeSelectorPainter.class)
    protected ITreeSelectorPainter selectorPainter;
    protected transient TreeSelectionListener treeSelectionListener;
    protected transient TreeExpansionListener treeExpansionListener;
    protected transient MouseAdapter mouseAdapter;
    protected transient LanguageListener languageSensitive;
    protected transient List<Integer> initialSelection = new ArrayList<Integer>();
    protected transient Point selectionStart = null;
    protected transient Point selectionEnd = null;
    protected transient TreePath draggablePath = null;
    protected transient Map<TreePath, Boolean> paintingCache;
    protected transient TreePaintParameters paintParameters;
    protected transient int totalChildIndent;
    protected transient int depthOffset;
    protected transient TreeModel treeModel;
    protected transient AbstractLayoutCache treeLayoutCache;
    protected transient CellRendererPane rendererPane;
    protected transient int editingRow = -1;
    protected transient int lastSelectionRow = -1;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.rowPainter, this.nodePainter, this.selectionPainter, this.dropLocationPainter, this.selectorPainter);
    }

    @Override
    protected void installPropertiesAndListeners() {
        this.paintingCache = new HashMap<TreePath, Boolean>();
        super.installPropertiesAndListeners();
        this.installTreeSelectionListeners();
        this.installTreeExpansionListeners();
        this.installTreeMouseListeners();
        this.installLanguageListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallLanguageListeners();
        this.uninstallTreeMouseListeners();
        this.uninstallTreeExpansionListeners();
        this.uninstallTreeSelectionListeners();
        super.uninstallPropertiesAndListeners();
        this.paintingCache = null;
    }

    protected void installTreeSelectionListeners() {
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (TreePainter.this.component != null) {
                    TreePainter.this.repaintSelection();
                }
            }
        };
        ((JTree)this.component).addTreeSelectionListener(this.treeSelectionListener);
    }

    protected void uninstallTreeSelectionListeners() {
        ((JTree)this.component).removeTreeSelectionListener(this.treeSelectionListener);
        this.treeSelectionListener = null;
    }

    protected void installTreeExpansionListeners() {
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(@NotNull TreeExpansionEvent event) {
                if (TreePainter.this.component != null) {
                    TreePainter.this.repaintSelection();
                }
            }

            @Override
            public void treeCollapsed(@NotNull TreeExpansionEvent event) {
                if (TreePainter.this.component != null) {
                    TreePainter.this.repaintSelection();
                }
            }
        };
        ((JTree)this.component).addTreeExpansionListener(this.treeExpansionListener);
    }

    protected void uninstallTreeExpansionListeners() {
        ((JTree)this.component).removeTreeExpansionListener(this.treeExpansionListener);
        this.treeExpansionListener = null;
    }

    protected void installTreeMouseListeners() {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (TreePainter.this.component != null && ((JTree)TreePainter.this.component).isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                    TreePath path;
                    boolean notInNodeSpace;
                    boolean ctrl = SwingUtils.isCtrl(e);
                    boolean shift = SwingUtils.isShift(e);
                    boolean noDrag = !((JTree)TreePainter.this.component).getDragEnabled() || ((JTree)TreePainter.this.component).getTransferHandler() == null;
                    boolean bl = notInNodeSpace = ((WTreeUI)TreePainter.this.ui).getExactRowForLocation(e.getPoint(), false) == -1;
                    if (notInNodeSpace && TreePainter.this.isFullLineSelection() && (path = ((WTreeUI)TreePainter.this.ui).getClosestPathForLocation((JTree)TreePainter.this.component, e.getX(), e.getY())) != null && !TreePainter.this.isLocationInExpandControl(path, e.getX(), e.getY()) && !((WTreeUI)TreePainter.this.ui).isLocationInCheckBoxControl(path, e.getX(), e.getY())) {
                        int clickRow = ((WTreeUI)TreePainter.this.ui).getExactRowForLocation(e.getPoint(), true);
                        switch (((JTree)TreePainter.this.component).getSelectionModel().getSelectionMode()) {
                            case 1: {
                                if (ctrl && ((JTree)TreePainter.this.component).isRowSelected(clickRow)) {
                                    ((JTree)TreePainter.this.component).clearSelection();
                                    break;
                                }
                                ((JTree)TreePainter.this.component).setSelectionRow(clickRow);
                                break;
                            }
                            case 2: {
                                int anchorRow;
                                if (shift) {
                                    anchorRow = ((JTree)TreePainter.this.component).getRowForPath(((JTree)TreePainter.this.component).getAnchorSelectionPath());
                                    List<Integer> selected = CollectionUtils.intRange(anchorRow, clickRow);
                                    selected.remove(0);
                                    selected.add(anchorRow);
                                    ((JTree)TreePainter.this.component).setSelectionRows(CollectionUtils.toIntArray(selected));
                                    break;
                                }
                                if (ctrl) {
                                    if (((JTree)TreePainter.this.component).isRowSelected(clickRow)) {
                                        ((JTree)TreePainter.this.component).removeSelectionRow(clickRow);
                                        break;
                                    }
                                    ((JTree)TreePainter.this.component).addSelectionRow(clickRow);
                                    break;
                                }
                                ((JTree)TreePainter.this.component).setSelectionRow(clickRow);
                                break;
                            }
                            case 4: {
                                int anchorRow;
                                if (shift) {
                                    int[] selectionRows;
                                    anchorRow = ((JTree)TreePainter.this.component).getRowForPath(((JTree)TreePainter.this.component).getAnchorSelectionPath());
                                    List<Integer> selected = CollectionUtils.intRange(anchorRow, clickRow);
                                    if (ctrl && (selectionRows = ((JTree)TreePainter.this.component).getSelectionRows()) != null) {
                                        CollectionUtils.addUnique(selected, selectionRows);
                                    }
                                    selected.remove(0);
                                    selected.add(anchorRow);
                                    ((JTree)TreePainter.this.component).setSelectionRows(CollectionUtils.toIntArray(selected));
                                    break;
                                }
                                if (ctrl) {
                                    if (((JTree)TreePainter.this.component).isRowSelected(clickRow)) {
                                        ((JTree)TreePainter.this.component).removeSelectionRow(clickRow);
                                        break;
                                    }
                                    ((JTree)TreePainter.this.component).addSelectionRow(clickRow);
                                    break;
                                }
                                ((JTree)TreePainter.this.component).setSelectionRow(clickRow);
                            }
                        }
                        int rowForPath = ((WTreeUI)TreePainter.this.ui).getRowForPath((JTree)TreePainter.this.component, path);
                        if (TreePainter.this.isDragAvailable() && ((WTreeUI)TreePainter.this.ui).getRowBounds(rowForPath).contains(e.getX(), e.getY()) && ((JTree)TreePainter.this.component).isRowSelected(rowForPath)) {
                            TreePainter.this.draggablePath = path;
                        }
                    }
                    if (!(ctrl || shift || !noDrag && !notInNodeSpace || !TreePainter.this.isSelectorAvailable() || (path = ((WTreeUI)TreePainter.this.ui).getClosestPathForLocation((JTree)TreePainter.this.component, e.getX(), e.getY())) != null && (TreePainter.this.isLocationInExpandControl(path, e.getX(), e.getY()) || ((WTreeUI)TreePainter.this.ui).isLocationInCheckBoxControl(path, e.getX(), e.getY())))) {
                        int rowForPath = ((WTreeUI)TreePainter.this.ui).getRowForPath((JTree)TreePainter.this.component, path);
                        if (TreePainter.this.isDragAvailable() && rowForPath != -1 && ((WTreeUI)TreePainter.this.ui).getRowBounds(rowForPath).contains(e.getX(), e.getY()) && ((JTree)TreePainter.this.component).isRowSelected(rowForPath)) {
                            TreePainter.this.draggablePath = path;
                        } else {
                            TreePainter.this.selectionEnd = TreePainter.this.selectionStart = e.getPoint();
                            TreePainter.this.initialSelection = this.getSelectedRows();
                            this.validateSelection(e);
                            this.repaintSelector();
                        }
                    }
                }
            }

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                if (TreePainter.this.component != null) {
                    if (TreePainter.this.draggablePath != null) {
                        TransferHandler transferHandler = ((JTree)TreePainter.this.component).getTransferHandler();
                        transferHandler.exportAsDrag(TreePainter.this.component, e, transferHandler.getSourceActions(TreePainter.this.component));
                        TreePainter.this.draggablePath = null;
                    }
                    if (TreePainter.this.isSelectorAvailable() && TreePainter.this.selectionStart != null) {
                        TreePainter.this.selectionEnd = e.getPoint();
                        this.validateSelection(e);
                        this.repaintSelector();
                        if (!((JTree)TreePainter.this.component).getVisibleRect().contains(e.getPoint())) {
                            ((JTree)TreePainter.this.component).scrollRectToVisible(new Rectangle(e.getPoint(), new Dimension(0, 0)));
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (TreePainter.this.component != null) {
                    if (TreePainter.this.draggablePath != null) {
                        TreePainter.this.draggablePath = null;
                    }
                    if (TreePainter.this.isSelectorAvailable() && TreePainter.this.selectionStart != null) {
                        TreePainter.this.selectionStart = null;
                        TreePainter.this.selectionEnd = null;
                        this.repaintSelector();
                    }
                }
            }

            private void validateSelection(@NotNull MouseEvent e) {
                Rectangle selection2 = GeometryUtils.getNonNullContainingRect(TreePainter.this.selectionStart, TreePainter.this.selectionEnd);
                ArrayList<Integer> newSelection = new ArrayList<Integer>();
                if (SwingUtils.isShift(e)) {
                    for (int row = 0; row < ((JTree)TreePainter.this.component).getRowCount(); ++row) {
                        if (!((WTreeUI)TreePainter.this.ui).getRowBounds(row).intersects(selection2) || TreePainter.this.initialSelection.contains(row)) continue;
                        newSelection.add(row);
                    }
                    newSelection.addAll(TreePainter.this.initialSelection);
                } else if (SwingUtils.isCtrl(e)) {
                    ArrayList<Integer> excludedRows = new ArrayList<Integer>();
                    for (int row = 0; row < ((JTree)TreePainter.this.component).getRowCount(); ++row) {
                        if (!((WTreeUI)TreePainter.this.ui).getRowBounds(row).intersects(selection2)) continue;
                        if (TreePainter.this.initialSelection.contains(row)) {
                            excludedRows.add(row);
                            continue;
                        }
                        newSelection.add(row);
                    }
                    for (int row : TreePainter.this.initialSelection) {
                        if (excludedRows.contains(row)) continue;
                        newSelection.add(row);
                    }
                } else {
                    for (int row = 0; row < ((JTree)TreePainter.this.component).getRowCount(); ++row) {
                        if (!((WTreeUI)TreePainter.this.ui).getRowBounds(row).intersects(selection2)) continue;
                        newSelection.add(row);
                    }
                }
                if (!CollectionUtils.equals(this.getSelectedRows(), newSelection, true)) {
                    if (newSelection.size() > 0) {
                        ((JTree)TreePainter.this.component).setSelectionRows(CollectionUtils.toIntArray(newSelection));
                    } else {
                        ((JTree)TreePainter.this.component).clearSelection();
                    }
                }
            }

            @NotNull
            private List<Integer> getSelectedRows() {
                ArrayList<Integer> selection2 = new ArrayList<Integer>();
                int[] selectionRows = ((JTree)TreePainter.this.component).getSelectionRows();
                if (selectionRows != null) {
                    for (int row : selectionRows) {
                        selection2.add(row);
                    }
                }
                return selection2;
            }

            private void repaintSelector() {
                ((JTree)TreePainter.this.component).repaint(((JTree)TreePainter.this.component).getVisibleRect());
            }
        };
        ((JTree)this.component).addMouseListener(this.mouseAdapter);
        ((JTree)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    protected void uninstallTreeMouseListeners() {
        ((JTree)this.component).removeMouseMotionListener(this.mouseAdapter);
        ((JTree)this.component).removeMouseListener(this.mouseAdapter);
        this.mouseAdapter = null;
    }

    protected void installLanguageListeners() {
        this.languageSensitive = new LanguageListener(){

            @Override
            public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                if (TreePainter.this.isLanguageSensitive() && ((JTree)TreePainter.this.component).getRowCount() > 0) {
                    TreeUI ui = ((JTree)TreePainter.this.component).getUI();
                    if (ui instanceof WTreeUI) {
                        ((WTreeUI)ui).updateNodeSizes();
                    } else {
                        ((JTree)TreePainter.this.component).repaint();
                    }
                }
            }
        };
        UILanguageManager.addLanguageListener(this.component, this.languageSensitive);
    }

    protected boolean isLanguageSensitive() {
        return this.component instanceof LanguageSensitive || ((JTree)this.component).getCellRenderer() instanceof LanguageSensitive || ((JTree)this.component).getModel() instanceof LanguageSensitive || this.component instanceof WebExTree && ((WebExTree)this.component).getDataProvider() instanceof LanguageSensitive || this.component instanceof WebAsyncTree && ((WebAsyncTree)this.component).getDataProvider() instanceof LanguageSensitive || TreeUtils.getTreeWalker((JTree)this.component).anyMatch(new Predicate<TreeNode>(){

            @Override
            public boolean test(TreeNode treeNode) {
                return treeNode instanceof LanguageSensitive;
            }
        });
    }

    protected void uninstallLanguageListeners() {
        UILanguageManager.removeLanguageListener(this.component, this.languageSensitive);
        this.languageSensitive = null;
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"dropLocation") && this.dropLocationPainter != null) {
            JTree.DropLocation newLocation;
            boolean changed = false;
            Rectangle repaint = null;
            JTree.DropLocation oldLocation = (JTree.DropLocation)oldValue;
            if (oldLocation != null && oldLocation.getPath() != null) {
                changed = true;
                repaint = this.dropLocationPainter.getDropViewBounds(oldLocation);
            }
            if ((newLocation = (JTree.DropLocation)newValue) != null && newLocation.getPath() != null) {
                changed = true;
                repaint = GeometryUtils.getContainingRect(repaint, this.dropLocationPainter.getDropViewBounds(newLocation));
            }
            if (changed) {
                if (repaint != null) {
                    this.repaint(repaint);
                } else {
                    this.repaint();
                }
            }
        }
    }

    @Override
    public boolean isRowHoverDecorationSupported() {
        boolean supported = false;
        if (this.component != null && ((JTree)this.component).isEnabled()) {
            if (this.rowPainter != null && this.rowPainter instanceof IDecorationPainter) {
                supported = ((IDecorationPainter)((Object)this.rowPainter)).usesState("hover");
            }
            if (!supported && this.nodePainter != null && this.nodePainter instanceof IDecorationPainter) {
                supported = ((IDecorationPainter)((Object)this.nodePainter)).usesState("hover");
            }
        }
        return supported;
    }

    @Override
    public void prepareToPaint(@NotNull TreePaintParameters parameters) {
        this.paintParameters = parameters;
    }

    @Override
    public void cleanupAfterPaint() {
        this.paintParameters = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.treeLayoutCache = ((WTreeUI)ui).getTreeLayoutCache();
        if (this.treeLayoutCache != null) {
            this.treeModel = ((JTree)this.component).getModel();
            this.totalChildIndent = ((BasicTreeUI)ui).getLeftChildIndent() + ((BasicTreeUI)ui).getRightChildIndent();
            this.rendererPane = ((WTreeUI)ui).getCellRendererPane();
            this.lastSelectionRow = ((JTree)this.component).getLeadSelectionRow();
            TreePath editingPath = ((JTree)this.component).getEditingPath();
            this.editingRow = editingPath != null ? ((JTree)this.component).getRowForPath(editingPath) : -1;
            this.updateDepthOffset();
            this.paintBackground(g2d);
            this.paintSelectedNodesBackground(g2d);
            this.paintTree(g2d);
            this.paintDropLocation(g2d);
            this.paintMultiselector(g2d);
        }
        this.treeModel = null;
        this.treeLayoutCache = null;
        this.rendererPane = null;
    }

    protected void paintBackground(@NotNull Graphics2D g2d) {
        if (this.rowPainter != null || this.nodePainter != null) {
            Rectangle paintBounds = g2d.getClipBounds();
            TreePath initialPath = ((WTreeUI)this.ui).getClosestPathForLocation((JTree)this.component, 0, paintBounds.y);
            Enumeration<TreePath> paintingEnumerator = this.treeLayoutCache.getVisiblePathsFrom(initialPath);
            if (initialPath != null && paintingEnumerator != null) {
                Rectangle bounds;
                TreePath path;
                Insets insets = ((JTree)this.component).getInsets();
                int endY = paintBounds.y + paintBounds.height;
                Rectangle boundsBuffer = new Rectangle();
                int row = this.treeLayoutCache.getRowForPath(initialPath);
                while (paintingEnumerator.hasMoreElements() && (path = paintingEnumerator.nextElement()) != null && (bounds = this.getPathBounds(path, insets, boundsBuffer)) != null) {
                    if (this.rowPainter != null) {
                        Rectangle rowBounds = ((WTreeUI)this.ui).getRowBounds(row, true);
                        Insets padding = PainterSupport.getPadding(this.component);
                        if (padding != null) {
                            rowBounds.x -= padding.left;
                            rowBounds.width += padding.left + padding.right;
                        }
                        this.rowPainter.prepareToPaint(row);
                        this.paintSection(this.rowPainter, g2d, rowBounds);
                    }
                    if (this.nodePainter != null) {
                        Rectangle nodeBounds = ((WTreeUI)this.ui).getRowBounds(row);
                        this.nodePainter.prepareToPaint(row);
                        this.paintSection(this.nodePainter, g2d, nodeBounds);
                    }
                    if (bounds.y + bounds.height >= endY) break;
                    ++row;
                }
            }
        }
    }

    protected void paintCentered(@NotNull Component c, @NotNull Graphics2D g2d, @NotNull Icon icon, int x, int y) {
        int ix = this.findCenteredX(x, icon.getIconWidth());
        int iy = y - icon.getIconHeight() / 2;
        icon.paintIcon(c, g2d, ix, iy);
    }

    protected int findCenteredX(int x, int iconWidth) {
        return this.ltr ? x - (int)Math.ceil((double)iconWidth / 2.0) : x - (int)Math.floor((double)iconWidth / 2.0);
    }

    protected void paintSelectedNodesBackground(@NotNull Graphics2D g2d) {
        if (this.selectionPainter != null && ((JTree)this.component).getSelectionCount() > 0 && ((WTreeUI)this.ui).getSelectionStyle() != TreeSelectionStyle.none) {
            List<Rectangle> selections = this.getSelectionRects();
            for (Rectangle rect : selections) {
                this.paintSection(this.selectionPainter, g2d, rect);
            }
        }
    }

    @NotNull
    protected List<Rectangle> getSelectionRects() {
        List<Rectangle> selections;
        if (((WTreeUI)this.ui).getSelectionStyle() != TreeSelectionStyle.none) {
            int[] indices = ((JTree)this.component).getSelectionRows();
            if (indices != null && indices.length != 0) {
                Arrays.sort(indices);
                selections = new ArrayList<Rectangle>(indices.length);
                Insets insets = ((JTree)this.component).getInsets();
                Rectangle maxRect = null;
                int lastRow = -1;
                for (int index : indices) {
                    if (((WTreeUI)this.ui).getSelectionStyle() == TreeSelectionStyle.single) {
                        selections.add(((JTree)this.component).getRowBounds(index));
                        continue;
                    }
                    if (lastRow != -1 && lastRow + 1 != index) {
                        selections.add(maxRect);
                        maxRect = null;
                        lastRow = -1;
                    }
                    if (lastRow != -1 && lastRow + 1 != index) continue;
                    Rectangle b = ((JTree)this.component).getRowBounds(index);
                    if (this.isFullLineSelection()) {
                        b.x = insets.left;
                        b.width = ((JTree)this.component).getWidth() - insets.left - insets.right;
                    }
                    maxRect = lastRow == -1 ? b : GeometryUtils.getContainingRect(maxRect, b);
                    lastRow = index;
                }
                if (maxRect != null) {
                    selections.add(maxRect);
                }
            } else {
                selections = Collections.emptyList();
            }
        } else {
            selections = Collections.emptyList();
        }
        return selections;
    }

    protected void repaintSelection() {
        if (((JTree)this.component).getSelectionCount() > 0) {
            for (Rectangle rect : this.getSelectionRects()) {
                ((JTree)this.component).repaint(rect);
            }
        }
    }

    protected void paintTree(@NotNull Graphics2D g2d) {
        Rectangle paintBounds = g2d.getClipBounds();
        Insets insets = ((JTree)this.component).getInsets();
        TreePath initialPath = ((WTreeUI)this.ui).getClosestPathForLocation((JTree)this.component, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeLayoutCache.getVisiblePathsFrom(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        int row = this.treeLayoutCache.getRowForPath(initialPath);
        this.paintingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            TreePath path;
            TreePath parentPath = initialPath;
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g2d, paintBounds, insets, parentPath);
                this.paintingCache.put(parentPath, Boolean.TRUE);
            }
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            while (paintingEnumerator.hasMoreElements() && (path = paintingEnumerator.nextElement()) != null) {
                boolean isExpanded;
                boolean hasBeenExpanded;
                boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                if (isLeaf) {
                    hasBeenExpanded = false;
                    isExpanded = false;
                } else {
                    isExpanded = this.treeLayoutCache.getExpandedState(path);
                    hasBeenExpanded = ((JTree)this.component).hasBeenExpanded(path);
                }
                Rectangle bounds = this.getPathBounds(path, insets, boundsBuffer);
                if (bounds == null) break;
                parentPath = path.getParentPath();
                if (parentPath != null) {
                    if (this.paintingCache.get(parentPath) == null) {
                        this.paintVerticalPartOfLeg(g2d, paintBounds, insets, parentPath);
                        this.paintingCache.put(parentPath, Boolean.TRUE);
                    }
                    this.paintHorizontalPartOfLeg(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                } else if (rootVisible && row == 0) {
                    this.paintHorizontalPartOfLeg(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
                if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                    this.paintExpandControl(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
                this.paintRow(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                if (bounds.y + bounds.height >= endY) break;
                ++row;
            }
        }
        this.rendererPane.removeAll();
    }

    protected boolean isLocationInExpandControl(@Nullable TreePath path, int mouseX, int mouseY) {
        boolean inExpandControl;
        if (path != null && !((JTree)this.component).getModel().isLeaf(path.getLastPathComponent())) {
            int boxWidth = ((WTreeUI)this.ui).getExpandedIcon() != null ? ((WTreeUI)this.ui).getExpandedIcon().getIconWidth() : 8;
            Insets i = ((JTree)this.component).getInsets();
            int boxLeftX = this.getRowX(((JTree)this.component).getRowForPath(path), path.getPathCount() - 1);
            boxLeftX = this.ltr ? boxLeftX + i.left - ((WTreeUI)this.ui).getRightChildIndent() + 1 : ((JTree)this.component).getWidth() - boxLeftX - i.right + ((WTreeUI)this.ui).getRightChildIndent() - 1;
            boxLeftX = this.findCenteredX(boxLeftX, boxWidth);
            inExpandControl = mouseX >= boxLeftX && mouseX < boxLeftX + boxWidth;
        } else {
            inExpandControl = false;
        }
        return inExpandControl;
    }

    protected void paintExpandControl(@NotNull Graphics2D g2d, @NotNull Rectangle clipBounds, @NotNull Insets insets, @NotNull Rectangle bounds, @NotNull TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object value = path.getLastPathComponent();
        if (!(isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0)) {
            int middleXOfKnob = this.ltr ? bounds.x - ((WTreeUI)this.ui).getRightChildIndent() + 1 : bounds.x + bounds.width + ((WTreeUI)this.ui).getRightChildIndent() - 1;
            int middleYOfKnob = bounds.y + bounds.height / 2;
            if (isExpanded) {
                Icon expandedIcon = ((WTreeUI)this.ui).getExpandedIcon();
                if (expandedIcon != null) {
                    this.paintCentered(this.component, g2d, expandedIcon, middleXOfKnob, middleYOfKnob);
                }
            } else {
                Icon collapsedIcon = ((WTreeUI)this.ui).getCollapsedIcon();
                if (collapsedIcon != null) {
                    this.paintCentered(this.component, g2d, collapsedIcon, middleXOfKnob, middleYOfKnob);
                }
            }
        }
    }

    protected void paintRow(@NotNull Graphics2D g2d, @NotNull Rectangle clipBounds, @NotNull Insets insets, @NotNull Rectangle bounds, @NotNull TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingRow != row && this.paintParameters != null) {
            Object value = path.getLastPathComponent();
            boolean hasFocus = (((JTree)this.component).hasFocus() ? this.lastSelectionRow : -1) == row;
            boolean selected = ((JTree)this.component).isRowSelected(row);
            Component rowComponent = this.paintParameters.renderer.getTreeCellRendererComponent((JTree)this.component, value, selected, isExpanded, isLeaf, row, hasFocus);
            this.rendererPane.paintComponent(g2d, rowComponent, this.component, bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
    }

    protected boolean shouldPaintExpandControl(@NotNull TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int depth;
        boolean shouldPaint = !isLeaf ? (depth = path.getPathCount() - 1) != 0 && (depth != 1 || this.isRootVisible()) || this.getShowsRootHandles() : false;
        return shouldPaint;
    }

    protected boolean isRootVisible() {
        return this.component != null && ((JTree)this.component).isRootVisible();
    }

    protected boolean getShowsRootHandles() {
        return this.component != null && ((JTree)this.component).getShowsRootHandles();
    }

    protected void paintHorizontalPartOfLeg(@NotNull Graphics2D g2d, @NotNull Rectangle clipBounds, @NotNull Insets insets, @NotNull Rectangle bounds, @NotNull TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int depth;
        if (this.paintLines && ((depth = path.getPathCount() - 1) != 0 && (depth != 1 || this.isRootVisible()) || this.getShowsRootHandles())) {
            int clipLeft = clipBounds.x;
            int clipRight = clipBounds.x + clipBounds.width;
            int clipTop = clipBounds.y;
            int clipBottom = clipBounds.y + clipBounds.height;
            int lineY = bounds.y + bounds.height / 2;
            if (this.ltr) {
                int leftX = bounds.x - ((WTreeUI)this.ui).getRightChildIndent();
                int nodeX = bounds.x - this.getHorizontalLegIndent();
                if (lineY >= clipTop && lineY < clipBottom && nodeX >= clipLeft && leftX < clipRight && leftX < nodeX) {
                    g2d.setPaint(this.linesColor);
                    this.paintHorizontalLine(g2d, lineY, leftX, nodeX - 1);
                }
            } else {
                int nodeX = bounds.x + bounds.width + this.getHorizontalLegIndent();
                int rightX = bounds.x + bounds.width + ((WTreeUI)this.ui).getRightChildIndent();
                if (lineY >= clipTop && lineY < clipBottom && rightX >= clipLeft && nodeX < clipRight && nodeX < rightX) {
                    g2d.setPaint(this.linesColor);
                    this.paintHorizontalLine(g2d, lineY, nodeX, rightX - 1);
                }
            }
        }
    }

    protected int getHorizontalLegIndent() {
        return -2;
    }

    protected void paintVerticalPartOfLeg(@NotNull Graphics2D g2d, @NotNull Rectangle clipBounds, @NotNull Insets insets, @NotNull TreePath path) {
        int depth;
        if (this.paintLines && ((depth = path.getPathCount() - 1) != 0 || this.getShowsRootHandles() || this.isRootVisible())) {
            int lineX = this.getRowX(-1, depth + 1);
            lineX = this.ltr ? lineX - ((WTreeUI)this.ui).getRightChildIndent() + insets.left : ((JTree)this.component).getWidth() - lineX - insets.right + ((WTreeUI)this.ui).getRightChildIndent() - 1;
            int clipLeft = clipBounds.x;
            int clipRight = clipBounds.x + clipBounds.width - 1;
            if (lineX >= clipLeft && lineX <= clipRight) {
                int clipTop = clipBounds.y;
                int clipBottom = clipBounds.y + clipBounds.height;
                Rectangle parentBounds = this.getPathBounds(path);
                Rectangle lastChildBounds = this.getPathBounds(this.getLastChildPath(path));
                if (lastChildBounds != null) {
                    int bottom;
                    Object root;
                    int top = parentBounds == null ? Math.max(insets.top + this.getVerticalLegIndent(), clipTop) : Math.max(parentBounds.y + parentBounds.height + this.getVerticalLegIndent(), clipTop);
                    if (depth == 0 && !this.isRootVisible() && this.treeModel != null && this.treeModel.getChildCount(root = this.treeModel.getRoot()) > 0 && (parentBounds = this.getPathBounds(path.pathByAddingChild(this.treeModel.getChild(root, 0)))) != null) {
                        top = Math.max(insets.top + this.getVerticalLegIndent(), parentBounds.y + parentBounds.height / 2);
                    }
                    if (top <= (bottom = Math.min(lastChildBounds.y + lastChildBounds.height / 2, clipBottom))) {
                        g2d.setPaint(this.linesColor);
                        this.paintVerticalLine(g2d, lineX, top, bottom);
                    }
                }
            }
        }
    }

    @Nullable
    protected TreePath getLastChildPath(@NotNull TreePath parent) {
        int childCount;
        TreePath lastChildPath = this.treeModel != null ? ((childCount = this.treeModel.getChildCount(parent.getLastPathComponent())) > 0 ? parent.pathByAddingChild(this.treeModel.getChild(parent.getLastPathComponent(), childCount - 1)) : null) : null;
        return lastChildPath;
    }

    protected void paintVerticalLine(@NotNull Graphics2D g2d, int x, int y1, int y2) {
        if (this.dashedLines) {
            this.paintDashedVerticalLine(g2d, x, y1, y2);
        } else {
            g2d.drawLine(x, y1, x, y2);
        }
    }

    protected void paintDashedVerticalLine(@NotNull Graphics2D g2d, int x, int y1, int y2) {
        y1 += y1 % 2;
        for (int y = y1; y <= y2; y += 2) {
            g2d.drawLine(x, y, x, y);
        }
    }

    protected void paintHorizontalLine(@NotNull Graphics2D g2d, int y, int x1, int x2) {
        if (this.dashedLines) {
            this.paintDashedHorizontalLine(g2d, y, x1, x2);
        } else {
            g2d.drawLine(x1, y, x2, y);
        }
    }

    protected void paintDashedHorizontalLine(@NotNull Graphics2D g2d, int y, int x1, int x2) {
        x1 += x1 % 2 + (this.ltr ? 0 : -1);
        for (int x = x1; x <= x2; x += 2) {
            g2d.drawLine(x, y, x, y);
        }
    }

    protected int getRowX(int row, int depth) {
        return this.totalChildIndent * (depth + this.depthOffset);
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected int getVerticalLegIndent() {
        return 0;
    }

    protected void paintDropLocation(@NotNull Graphics2D g2d) {
        Rectangle dropViewBounds;
        JTree.DropLocation dropLocation;
        if (this.dropLocationPainter != null && (dropLocation = ((JTree)this.component).getDropLocation()) != null && dropLocation.getPath() != null && (dropViewBounds = this.dropLocationPainter.getDropViewBounds(dropLocation)) != null) {
            this.dropLocationPainter.prepareToPaint(dropLocation);
            this.paintSection(this.dropLocationPainter, g2d, dropViewBounds);
        }
    }

    protected void paintMultiselector(@NotNull Graphics2D g2d) {
        if (this.isSelectorAvailable() && this.selectionStart != null && this.selectionEnd != null) {
            Rectangle rawBounds = GeometryUtils.getNonNullContainingRect(this.selectionStart, this.selectionEnd);
            Rectangle bounds = rawBounds.intersection(BoundsType.component.bounds(this.component));
            --bounds.width;
            --bounds.height;
            this.paintSection(this.selectorPainter, g2d, bounds);
        }
    }

    protected boolean isSelectorAvailable() {
        return this.selectorPainter != null && this.component != null && ((JTree)this.component).isEnabled() && ((JTree)this.component).getSelectionModel().getSelectionMode() != 1;
    }

    @Nullable
    protected Rectangle getPathBounds(@Nullable TreePath path) {
        Rectangle pathBounds = this.component != null && this.treeLayoutCache != null ? this.getPathBounds(path, ((JTree)this.component).getInsets(), new Rectangle()) : null;
        return pathBounds;
    }

    @Nullable
    protected Rectangle getPathBounds(@Nullable TreePath path, @NotNull Insets insets, @NotNull Rectangle bounds) {
        if ((bounds = this.treeLayoutCache.getBounds(path, bounds)) != null) {
            bounds.x = this.ltr ? (bounds.x += insets.left) : ((JTree)this.component).getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    protected boolean isFullLineSelection() {
        return ((WTreeUI)this.ui).getSelectionStyle() == TreeSelectionStyle.line;
    }

    protected boolean isDragAvailable() {
        return this.component != null && ((JTree)this.component).isEnabled() && ((JTree)this.component).getDragEnabled() && ((JTree)this.component).getTransferHandler() != null && ((JTree)this.component).getTransferHandler().getSourceActions(this.component) > 0;
    }
}

