/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.ExTreeModel;
import com.alee.extended.tree.walker.AsyncTreeWalker;
import com.alee.laf.tree.NodeState;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.walker.AbstractTreeWalker;
import com.alee.laf.tree.walker.SimpleTreeWalker;
import com.alee.laf.tree.walker.TreeWalker;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeUtils {
    @NotNull
    public static TreeState getTreeState(@NotNull JTree tree) {
        return TreeUtils.getTreeState(tree, true);
    }

    @NotNull
    public static TreeState getTreeState(@NotNull JTree tree, boolean saveSelection) {
        return TreeUtils.getTreeState(tree, tree.getModel().getRoot(), saveSelection);
    }

    @NotNull
    public static TreeState getTreeState(@NotNull JTree tree, @Nullable Object root) {
        return TreeUtils.getTreeState(tree, root, true);
    }

    @NotNull
    public static TreeState getTreeState(@NotNull JTree tree, @Nullable Object root, boolean saveSelection) {
        TreeState state = new TreeState();
        if (root != null) {
            if (!(root instanceof UniqueNode)) {
                throw new RuntimeException("To get tree state you must use UniqueNode or any class that extends it as tree elements");
            }
            TreeUtils.saveTreeStateImpl(tree, state, (UniqueNode)root, saveSelection);
        }
        return state;
    }

    private static void saveTreeStateImpl(@NotNull JTree tree, @NotNull TreeState state, @NotNull UniqueNode parent, boolean saveSelection) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeUtils.saveTreeStateImpl(tree, state, (UniqueNode)parent.getChildAt(i), saveSelection);
        }
        TreePath path = new TreePath(parent.getPath());
        state.addState(parent.getId(), new NodeState(tree.getModel().getRoot() == parent && !tree.isRootVisible() || tree.isExpanded(path), saveSelection && tree.isPathSelected(path)));
    }

    public static void setTreeState(@NotNull JTree tree, @Nullable TreeState treeState) {
        TreeUtils.setTreeState(tree, treeState, tree.getModel().getRoot(), true);
    }

    public static void setTreeState(@NotNull JTree tree, @Nullable TreeState treeState, boolean restoreSelection) {
        TreeUtils.setTreeState(tree, treeState, tree.getModel().getRoot(), restoreSelection);
    }

    public static void setTreeState(@NotNull JTree tree, @Nullable TreeState treeState, @Nullable Object root) {
        TreeUtils.setTreeState(tree, treeState, root, true);
    }

    public static void setTreeState(@NotNull JTree tree, @Nullable TreeState treeState, @Nullable Object root, boolean restoreSelection) {
        if (root != null) {
            if (!(root instanceof UniqueNode)) {
                throw new RuntimeException("To set tree state you must use UniqueNode or any class that extends it as tree elements");
            }
            if (treeState != null) {
                TreeUtils.restoreTreeStateImpl(tree, treeState, (UniqueNode)root, restoreSelection);
            }
        }
    }

    private static void restoreTreeStateImpl(@NotNull JTree tree, @NotNull TreeState treeState, @NotNull UniqueNode parent, boolean restoreSelection) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeUtils.restoreTreeStateImpl(tree, treeState, (UniqueNode)parent.getChildAt(i), restoreSelection);
        }
        TreePath path = new TreePath(parent.getPath());
        if (treeState.isExpanded(parent.getId())) {
            if (!tree.isExpanded(path)) {
                tree.expandPath(path);
            }
        } else if (tree.isExpanded(path)) {
            tree.collapsePath(path);
        }
        if (restoreSelection) {
            if (treeState.isSelected(parent.getId())) {
                if (!tree.isPathSelected(path)) {
                    tree.addSelectionPath(path);
                }
            } else if (tree.isPathSelected(path)) {
                tree.removeSelectionPath(path);
            }
        }
    }

    @NotNull
    public static <N extends TreeNode> TreeWalker<N> getTreeWalker(@NotNull JTree tree) {
        AbstractTreeWalker treeWalker = tree.getModel() instanceof AsyncTreeModel ? new AsyncTreeWalker(tree) : new SimpleTreeWalker(tree);
        return treeWalker;
    }

    @Nullable
    public static TreePath getTreePath(@Nullable TreeNode node) {
        Object[] path;
        TreePath treePath = node != null ? ((path = TreeUtils.getPath(node)) != null ? new TreePath(path) : null) : null;
        return treePath;
    }

    @Nullable
    public static TreeNode[] getPath(@Nullable TreeNode node) {
        return TreeUtils.getPathToRoot(node, 0);
    }

    @Nullable
    private static TreeNode[] getPathToRoot(@Nullable TreeNode node, int depth) {
        TreeNode[] path;
        if (node == null) {
            path = depth != 0 ? new TreeNode[depth] : null;
        } else {
            path = TreeUtils.getPathToRoot(node.getParent(), ++depth);
            if (path != null) {
                path[path.length - depth] = node;
            }
        }
        return path;
    }

    public static boolean isNodeAncestor(@NotNull TreeNode node, @Nullable TreeNode anotherNode) {
        boolean nodeAncestor = false;
        if (anotherNode != null) {
            TreeNode ancestor = node;
            do {
                if (ancestor != anotherNode) continue;
                nodeAncestor = true;
                break;
            } while ((ancestor = ancestor.getParent()) != null);
        }
        return nodeAncestor;
    }

    public static boolean isNodeAncestor(@NotNull JTree tree, @NotNull TreeNode node, @Nullable TreeNode anotherNode) {
        boolean ancestor;
        TreeModel model = tree.getModel();
        if (model instanceof ExTreeModel) {
            boolean isParent = false;
            ExTreeModel exTreeModel = (ExTreeModel)model;
            if (anotherNode != null) {
                TreeNode parent = node;
                do {
                    if (parent != anotherNode) continue;
                    isParent = true;
                    break;
                } while ((parent = exTreeModel.getRawParent((UniqueNode)parent)) != null);
            }
            ancestor = isParent;
        } else {
            ancestor = TreeUtils.isNodeAncestor(node, anotherNode);
        }
        return ancestor;
    }

    public static int getLevel(@NotNull TreeNode node) {
        int levels = 0;
        TreeNode ancestor = node;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public static void expandAll(@NotNull JTree tree) {
        if (tree instanceof WebTree) {
            WebTree webTree = (WebTree)tree;
            webTree.expandAll();
        } else {
            for (int row = 0; row < tree.getRowCount(); ++row) {
                tree.expandRow(row);
            }
        }
    }

    public static void expandLoaded(@NotNull JTree tree) {
        Object root = tree.getModel().getRoot();
        if (!(root instanceof TreeNode)) {
            throw new RuntimeException("Specified tree doesn't use TreeNodes: " + tree);
        }
        TreeUtils.expandLoaded(tree, (TreeNode)root);
    }

    public static void expandLoaded(@NotNull JTree tree, @NotNull TreeNode node) {
        TreePath path;
        if (node.getParent() != null && !tree.isExpanded(path = TreeUtils.getTreePath(node.getParent()))) {
            tree.expandPath(path);
        }
        for (int index = 0; index < node.getChildCount(); ++index) {
            TreeUtils.expandLoaded(tree, node.getChildAt(index));
        }
    }
}

