/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.ui.ChildStyleIdBridge;
import com.alee.api.ui.ForegroundBridge;
import com.alee.api.ui.IconBridge;
import com.alee.api.ui.StyleIdBridge;
import com.alee.api.ui.TextBridge;
import com.alee.extended.label.WebStyledLabel;
import com.alee.laf.tree.TreeNodeParameters;
import com.alee.laf.tree.WTreeUI;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class WebTreeCellRenderer<N extends TreeNode, C extends JTree, P extends TreeNodeParameters<N, C>>
extends WebStyledLabel
implements TreeCellRenderer,
Stateful {
    public static final String ID_PREFIX = "WTCR";
    @NotNull
    protected final String id;
    @NotNull
    protected final List<String> states;

    public WebTreeCellRenderer() {
        this.setName("Tree.cellRenderer");
        this.id = TextUtils.generateId(ID_PREFIX);
        this.states = new ArrayList<String>(5);
    }

    @Override
    @NotNull
    public List<String> getStates() {
        return this.states;
    }

    protected void updateStates(@NotNull P parameters) {
        TreeUI ui;
        this.states.clear();
        this.states.add(((TreeNodeParameters)parameters).isSelected() ? "selected" : "unselected");
        this.states.add(((TreeNodeParameters)parameters).isExpanded() ? "expanded" : "collapsed");
        if (((TreeNodeParameters)parameters).isFocused()) {
            this.states.add("focused");
        }
        if (((TreeNodeParameters)parameters).isLeaf()) {
            this.states.add("leaf");
        }
        if ((ui = ((JTree)((TreeNodeParameters)parameters).tree()).getUI()) instanceof WTreeUI && ((WTreeUI)ui).getHoverRow() == ((TreeNodeParameters)parameters).row()) {
            this.states.add("hover");
        }
        this.states.addAll(DecorationUtils.getExtraStates(((TreeNodeParameters)parameters).node()));
    }

    protected void updateStyleId(@NotNull P parameters) {
        StyleIdBridge styleIdBridge;
        StyleId styleId;
        StyleId id = null;
        if (((TreeNodeParameters)parameters).node() instanceof ChildStyleIdBridge) {
            ChildStyleIdBridge childStyleIdBridge = (ChildStyleIdBridge)((TreeNodeParameters)parameters).node();
            ChildStyleId childStyleId = childStyleIdBridge.getChildStyleId(parameters);
            if (childStyleId != null) {
                id = childStyleId.at((JComponent)((TreeNodeParameters)parameters).tree());
            }
        } else if (((TreeNodeParameters)parameters).node() instanceof StyleIdBridge && (styleId = (styleIdBridge = (StyleIdBridge)((TreeNodeParameters)parameters).node()).getStyleId(parameters)) != null) {
            id = styleId;
        }
        if (id == null) {
            id = StyleId.treeCellRenderer.at((JComponent)((TreeNodeParameters)parameters).tree());
        }
        this.setStyleId(id);
    }

    protected void updateView(@NotNull P parameters) {
        this.setEnabled(this.enabledForValue(parameters));
        this.setComponentOrientation(this.orientationForValue(parameters));
        this.setFont(this.fontForValue(parameters));
        this.setForeground(this.foregroundForValue(parameters));
        this.setIcon(this.iconForValue(parameters));
        this.setText(this.textForValue(parameters));
    }

    protected boolean enabledForValue(@NotNull P parameters) {
        return ((Component)((TreeNodeParameters)parameters).tree()).isEnabled();
    }

    @NotNull
    protected ComponentOrientation orientationForValue(@NotNull P parameters) {
        return ((Component)((TreeNodeParameters)parameters).tree()).getComponentOrientation();
    }

    @Nullable
    protected Font fontForValue(@NotNull P parameters) {
        return ((Component)((TreeNodeParameters)parameters).tree()).getFont();
    }

    @Nullable
    protected Color foregroundForValue(@NotNull P parameters) {
        ForegroundBridge foregroundBridge;
        Color fg;
        Color foreground = ((TreeNodeParameters)parameters).node() instanceof ForegroundBridge ? ((fg = (foregroundBridge = (ForegroundBridge)((TreeNodeParameters)parameters).node()).getForeground(parameters)) != null ? fg : ((Component)((TreeNodeParameters)parameters).tree()).getForeground()) : ((Component)((TreeNodeParameters)parameters).tree()).getForeground();
        return foreground;
    }

    @Nullable
    protected Icon iconForValue(@NotNull P parameters) {
        Icon icon;
        boolean enabled = this.enabledForValue(parameters);
        if (((TreeNodeParameters)parameters).node() instanceof IconBridge) {
            IconBridge iconBridge = (IconBridge)((TreeNodeParameters)parameters).node();
            icon = iconBridge.getIcon(parameters);
        } else {
            boolean root;
            boolean bl = root = ((JTree)((TreeNodeParameters)parameters).tree()).getModel().getRoot() == ((TreeNodeParameters)parameters).node();
            icon = root ? (((TreeNodeParameters)parameters).isExpanded() ? Icons.rootOpen : Icons.root) : (!((TreeNodeParameters)parameters).isLeaf() ? (((TreeNodeParameters)parameters).isExpanded() ? Icons.folderOpen : Icons.folder) : Icons.leaf);
        }
        return icon == null || enabled ? icon : UIManager.getLookAndFeel().getDisabledIcon(this, icon);
    }

    @Nullable
    protected String textForValue(@NotNull P parameters) {
        String text;
        if (((TreeNodeParameters)parameters).node() instanceof TextBridge) {
            TextBridge textBridge = (TextBridge)((TreeNodeParameters)parameters).node();
            text = textBridge.getText(parameters);
        } else {
            text = ((JTree)((TreeNodeParameters)parameters).tree()).convertValueToText(((TreeNodeParameters)parameters).node(), ((TreeNodeParameters)parameters).isSelected(), ((TreeNodeParameters)parameters).isExpanded(), ((TreeNodeParameters)parameters).isLeaf(), ((TreeNodeParameters)parameters).row(), ((TreeNodeParameters)parameters).isFocused());
        }
        return text;
    }

    @Override
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object node, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        P parameters = this.getRenderingParameters(tree, (TreeNode)node, isSelected, expanded, leaf, row, hasFocus);
        this.updateStates(parameters);
        this.updateStyleId(parameters);
        this.updateView(parameters);
        DecorationUtils.fireStatesChanged(this);
        return this;
    }

    @NotNull
    protected P getRenderingParameters(@NotNull C tree, @NotNull N node, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return (P)new TreeNodeParameters<N, C>(tree, node, row, leaf, isSelected, expanded, hasFocus);
    }

    @Override
    public final void validate() {
    }

    @Override
    public final void invalidate() {
    }

    @Override
    public final void revalidate() {
    }

    @Override
    public final void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public final void repaint(@NotNull Rectangle r) {
    }

    @Override
    public final void repaint() {
    }

    protected void checkPropertyChange(@NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        if (Objects.equals((Object)propertyName, "styleId", "parent", "decorationStates", "styleRanges", "text", "border", "model")) {
            this.allowPropertyChange(propertyName, oldValue, newValue);
        } else if (Objects.equals((Object)propertyName, "font", "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            this.allowPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void allowPropertyChange(@NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected final void firePropertyChange(@NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, byte oldValue, byte newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, char oldValue, char newValue) {
        this.checkPropertyChange(propertyName, Character.valueOf(oldValue), Character.valueOf(newValue));
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, short oldValue, short newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, int oldValue, int newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, long oldValue, long newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, float oldValue, float newValue) {
        this.checkPropertyChange(propertyName, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, double oldValue, double newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(@NotNull String propertyName, boolean oldValue, boolean newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    public static final class UIResource<N extends TreeNode, C extends JTree, P extends TreeNodeParameters<N, C>>
    extends WebTreeCellRenderer<N, C, P>
    implements javax.swing.plaf.UIResource {
    }
}

