/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.Behavior;
import com.alee.laf.tree.WebTree;
import com.alee.utils.swing.HoverListener;
import javax.swing.tree.MutableTreeNode;

public class TreeHoverSelectionBehavior<N extends MutableTreeNode>
implements HoverListener<N>,
Behavior {
    @NotNull
    protected final WebTree<N> tree;

    public TreeHoverSelectionBehavior(@NotNull WebTree<N> tree) {
        this.tree = tree;
    }

    @Override
    public void hoverChanged(@Nullable N previous, @Nullable N current) {
        if (current != null) {
            this.tree.setSelectedNode(current);
        } else {
            this.tree.clearSelection();
        }
    }

    public static TreeHoverSelectionBehavior install(@NotNull WebTree tree) {
        TreeHoverSelectionBehavior.uninstall(tree);
        TreeHoverSelectionBehavior behavior = new TreeHoverSelectionBehavior(tree);
        tree.addHoverListener(behavior);
        return behavior;
    }

    public static void uninstall(@NotNull WebTree tree) {
        for (HoverListener listener : tree.getHoverListeners()) {
            if (!(listener instanceof TreeHoverSelectionBehavior)) continue;
            tree.removeHoverListener(listener);
        }
    }

    public static boolean isInstalled(@NotNull WebTree tree) {
        boolean installed = false;
        for (HoverListener listener : tree.getHoverListeners()) {
            if (!(listener instanceof TreeHoverSelectionBehavior)) continue;
            installed = true;
            break;
        }
        return installed;
    }
}

