/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.viewport;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.Mergeable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.scroll.layout.ScrollBarSettings;
import com.alee.laf.scroll.layout.ScrollPaneLayout;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

@XStreamAlias(value="ViewportLayout")
public class ViewportLayout
extends AbstractLayoutManager
implements Mergeable,
Cloneable,
Serializable {
    @Override
    public void layoutContainer(@NotNull Container container) {
        JViewport viewport = (JViewport)container;
        Component view = viewport.getView();
        if (view != null) {
            LayoutManager layout;
            JScrollPane scrollPane;
            Scrollable scrollableView = null;
            if (view instanceof Scrollable) {
                scrollableView = (Scrollable)((Object)view);
            }
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension vpSize = viewport.getSize();
            Dimension extentSize = viewport.toViewCoordinates(vpSize);
            Dimension viewSize = new Dimension(viewPrefSize);
            int vExtend = 0;
            int hExtend = 0;
            Container scroll = viewport.getParent();
            if (scroll instanceof JScrollPane && viewport == (scrollPane = (JScrollPane)scroll).getViewport() && (layout = scrollPane.getLayout()) instanceof ScrollPaneLayout) {
                JScrollBar hsb;
                ScrollBarSettings hpos;
                JScrollBar vsb;
                ScrollBarSettings vpos = ((ScrollPaneLayout)layout).getVerticalScrollBarPosition();
                if (vpos.isHovering() && vpos.isExtending() && (vsb = scrollPane.getVerticalScrollBar()) != null && vsb.isShowing()) {
                    vExtend = vsb.getPreferredSize().width;
                    viewSize.width += vExtend;
                }
                if ((hpos = ((ScrollPaneLayout)layout).getHorizontalScrollBarPosition()).isHovering() && hpos.isExtending() && (hsb = scrollPane.getHorizontalScrollBar()) != null && hsb.isShowing()) {
                    hExtend = hsb.getPreferredSize().height;
                    viewSize.height += hExtend;
                }
            }
            if (scrollableView != null) {
                Rectangle oldBounds = null;
                if (vExtend != 0 || hExtend != 0) {
                    oldBounds = viewport.getBounds();
                    viewport.setBounds(oldBounds.x, oldBounds.y, oldBounds.width - vExtend, oldBounds.height - hExtend);
                }
                if (scrollableView.getScrollableTracksViewportWidth()) {
                    viewSize.width = vpSize.width;
                }
                if (scrollableView.getScrollableTracksViewportHeight()) {
                    viewSize.height = vpSize.height;
                }
                if (oldBounds != null) {
                    viewport.setBounds(oldBounds);
                }
            }
            Point viewPosition = viewport.getViewPosition();
            if (scrollableView == null || viewport.getParent() == null || viewport.getParent().getComponentOrientation().isLeftToRight()) {
                if (viewPosition.x + extentSize.width > viewSize.width) {
                    viewPosition.x = Math.max(0, viewSize.width - extentSize.width);
                }
            } else {
                viewPosition.x = extentSize.width > viewSize.width ? viewSize.width - extentSize.width : Math.max(0, Math.min(viewSize.width - extentSize.width, viewPosition.x));
            }
            if (viewPosition.y + extentSize.height > viewSize.height) {
                viewPosition.y = Math.max(0, viewSize.height - extentSize.height);
            }
            if (scrollableView == null) {
                if (viewPosition.x <= 0 && vpSize.width > viewSize.width) {
                    viewPosition.x = Math.max(0, viewPosition.x);
                    viewSize.width = vpSize.width;
                }
                if (viewPosition.y == 0 && vpSize.height > viewSize.height) {
                    viewSize.height = vpSize.height;
                }
            }
            viewport.setViewPosition(viewPosition);
            viewport.setViewSize(viewSize);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        LayoutManager layout;
        JScrollPane scrollPane;
        Dimension ps;
        JViewport viewport = (JViewport)container;
        Component view = viewport.getView();
        if (view == null) {
            ps = new Dimension(0, 0);
        } else if (view instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)view);
            ps = scrollable.getPreferredScrollableViewportSize();
        } else {
            ps = view.getPreferredSize();
        }
        Container scroll = viewport.getParent();
        if (scroll instanceof JScrollPane && viewport == (scrollPane = (JScrollPane)scroll).getViewport() && (layout = scrollPane.getLayout()) instanceof ScrollPaneLayout) {
            JScrollBar hsb;
            ScrollBarSettings hpos;
            JScrollBar vsb;
            ScrollBarSettings vpos = ((ScrollPaneLayout)layout).getVerticalScrollBarPosition();
            if (vpos.isHovering() && vpos.isExtending() && (vsb = scrollPane.getVerticalScrollBar()) != null && vsb.isShowing()) {
                ps.width += vsb.getPreferredSize().width;
            }
            if ((hpos = ((ScrollPaneLayout)layout).getHorizontalScrollBarPosition()).isHovering() && hpos.isExtending() && (hsb = scrollPane.getHorizontalScrollBar()) != null && hsb.isShowing()) {
                ps.height += hsb.getPreferredSize().height;
            }
        }
        return ps;
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return new Dimension(4, 4);
    }

    @XStreamAlias(value="ViewportLayout$UIResource")
    public static final class UIResource
    extends ViewportLayout
    implements javax.swing.plaf.UIResource {
    }
}

