/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.window;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.laf.rootpane.WebRootPane;
import com.alee.laf.window.WindowEventMethods;
import com.alee.laf.window.WindowEventMethodsImpl;
import com.alee.laf.window.WindowEventRunnable;
import com.alee.laf.window.WindowMethods;
import com.alee.laf.window.WindowMethodsImpl;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.swing.extensions.ComponentEventRunnable;
import com.alee.utils.swing.extensions.WindowCloseAdapter;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class WebFrame<T extends WebFrame<T>>
extends JFrame
implements Styleable,
WindowEventMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
WindowMethods<T> {
    protected boolean closeOnFocusLoss = false;
    protected transient DefaultFocusTracker focusTracker;

    public WebFrame() {
        this(StyleId.auto);
    }

    public WebFrame(GraphicsConfiguration gc) {
        this(StyleId.auto, gc);
    }

    public WebFrame(String title) {
        this(StyleId.auto, title);
    }

    public WebFrame(String title, GraphicsConfiguration gc) {
        this(StyleId.auto, title, gc);
    }

    public WebFrame(StyleId id) {
        this(id, "");
    }

    public WebFrame(StyleId id, GraphicsConfiguration gc) {
        this(id, "", gc);
    }

    public WebFrame(StyleId id, String title) {
        this(id, title, null);
    }

    public WebFrame(StyleId id, String title, GraphicsConfiguration gc) {
        super(UILanguageManager.getInitialText(title, new Object[0]), gc);
        this.initialize(id, title);
    }

    @Override
    protected void frameInit() {
    }

    protected void initialize(StyleId id, String title) {
        this.enableEvents(72L);
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        ProprietaryUtils.checkAndSetPolicy(this);
        WebLookAndFeel.setOrientation(this);
        this.setStyleId(id);
        if (title != null) {
            UILanguageManager.registerInitialLanguage(this, title, new Object[0]);
        }
        this.focusTracker = new DefaultFocusTracker(this.getRootPane(), true){

            @Override
            public boolean isEnabled() {
                return WebFrame.this.closeOnFocusLoss && super.isEnabled();
            }

            @Override
            public void focusChanged(boolean focused) {
                if (this.isEnabled() && !focused) {
                    WebFrame.this.processWindowEvent(new WindowEvent(WebFrame.this, 201));
                }
            }
        };
        FocusManager.addFocusTracker(this.getRootPane(), this.focusTracker);
    }

    @Override
    protected JRootPane createRootPane() {
        return new WebFrameRootPane();
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public List<Component> getFocusableChildren() {
        return this.focusTracker.getFocusableChildren();
    }

    public void addFocusableChild(Component child) {
        this.focusTracker.addFocusableChild(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusTracker.removeFocusableChild(child);
    }

    public boolean isDisplayTitleComponent() {
        return this.getUI().isDisplayTitleComponent();
    }

    public void setDisplayTitleComponent(boolean display) {
        this.getUI().setDisplayTitleComponent(display);
    }

    public JComponent getTitleComponent() {
        return this.getUI().getTitleComponent();
    }

    public void setTitleComponent(JComponent title) {
        this.getUI().setTitleComponent(title);
    }

    public boolean isDisplayWindowButtons() {
        return this.getUI().isDisplayWindowButtons();
    }

    public void setDisplayWindowButtons(boolean display) {
        this.getUI().setDisplayWindowButtons(display);
    }

    public boolean isDisplayMinimizeButton() {
        return this.getUI().isDisplayMinimizeButton();
    }

    public void setDisplayMinimizeButton(boolean display) {
        this.getUI().setDisplayMinimizeButton(display);
    }

    public boolean isDisplayMaximizeButton() {
        return this.getUI().isDisplayMaximizeButton();
    }

    public void setDisplayMaximizeButton(boolean display) {
        this.getUI().setDisplayMaximizeButton(display);
    }

    public boolean isDisplayCloseButton() {
        return this.getUI().isDisplayCloseButton();
    }

    public void setDisplayCloseButton(boolean display) {
        this.getUI().setDisplayCloseButton(display);
    }

    public JComponent getButtonsPanel() {
        return this.getUI().getButtonsPanel();
    }

    public boolean isDisplayMenuBar() {
        return this.getUI().isDisplayMenuBar();
    }

    public void setDisplayMenuBar(boolean display) {
        this.getUI().setDisplayMenuBar(display);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return JFrame.isDefaultLookAndFeelDecorated() ? StyleId.frameDecorated : StyleId.frame;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.getRootPane());
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this.getRootPane(), id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this.getRootPane());
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this.getRootPane());
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this.getRootPane(), skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this.getRootPane(), skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this.getRootPane());
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this.getRootPane(), listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this.getRootPane(), listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this.getRootPane());
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this.getRootPane());
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this.getRootPane());
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this.getRootPane());
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this.getRootPane(), enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this.getRootPane());
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this.getRootPane(), margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this.getRootPane(), top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this.getRootPane(), margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this.getRootPane());
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this.getRootPane(), padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this.getRootPane(), top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this.getRootPane(), padding);
    }

    public WRootPaneUI getUI() {
        return (WRootPaneUI)this.getRootPane().getUI();
    }

    public void setUI(WRootPaneUI ui) {
        this.getRootPane().setUI(ui);
    }

    @Override
    public WindowAdapter onClosing(WindowEventRunnable runnable) {
        return WindowEventMethodsImpl.onClosing(this, runnable);
    }

    @Override
    public WindowCloseAdapter onClose(ComponentEventRunnable runnable) {
        return WindowEventMethodsImpl.onClose(this, runnable);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this.getRootPane());
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this.getRootPane(), key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this.getRootPane(), data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this.getRootPane(), key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this.getRootPane());
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this.getRootPane(), updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this.getRootPane());
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this.getRootPane(), configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this.getRootPane(), processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this.getRootPane());
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this.getRootPane());
    }

    @Override
    public boolean isWindowOpaque() {
        return WindowMethodsImpl.isWindowOpaque(this);
    }

    @Override
    public T setWindowOpaque(boolean opaque) {
        return (T)((WebFrame)WindowMethodsImpl.setWindowOpaque(this, opaque));
    }

    @Override
    public float getWindowOpacity() {
        return WindowMethodsImpl.getWindowOpacity(this);
    }

    @Override
    public T setWindowOpacity(float opacity) {
        return (T)((WebFrame)WindowMethodsImpl.setWindowOpacity(this, opacity));
    }

    @Override
    public T center() {
        return (T)((WebFrame)WindowMethodsImpl.center(this));
    }

    @Override
    public T center(Component relativeTo) {
        return (T)((WebFrame)WindowMethodsImpl.center(this, relativeTo));
    }

    @Override
    public T center(int width, int height) {
        return (T)((WebFrame)WindowMethodsImpl.center(this, width, height));
    }

    @Override
    public T center(Component relativeTo, int width, int height) {
        return (T)((WebFrame)WindowMethodsImpl.center(this, relativeTo, width, height));
    }

    @Override
    public T packToWidth(int width) {
        return (T)((WebFrame)WindowMethodsImpl.packToWidth(this, width));
    }

    @Override
    public T packToHeight(int height) {
        return (T)((WebFrame)WindowMethodsImpl.packToHeight(this, height));
    }

    public class WebFrameRootPane
    extends WebRootPane {
        public WebFrameRootPane() {
            super(StyleManager.getDescriptor(WebFrameRootPane.class).getDefaultStyleId());
        }

        @Override
        @NotNull
        public StyleId getDefaultStyleId() {
            return WebFrame.this.getDefaultStyleId();
        }
    }
}

