/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

@XStreamAlias(value="Bezier")
public final class Bezier
extends AbstractEasing {
    @XStreamAsAttribute
    private final double x1;
    @XStreamAsAttribute
    private final double y1;
    @XStreamAsAttribute
    private final double x2;
    @XStreamAsAttribute
    private final double y2;

    public Bezier(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public String getTitle() {
        return "Bezier";
    }

    @Override
    protected double calculateImpl(double start2, double distance, double current, double total) {
        double xprogress = 1.0 - current / total;
        double time = 3.0 * Math.pow(1.0 - xprogress, 2.0) * xprogress * this.x1 + 3.0 * (1.0 - xprogress) * xprogress * xprogress * this.x2 + xprogress * xprogress * xprogress;
        double yprogress = 1.0 - time;
        double animation = 3.0 * Math.pow(1.0 - yprogress, 2.0) * yprogress * this.y1 + 3.0 * (1.0 - yprogress) * yprogress * yprogress * this.y2 + yprogress * yprogress * yprogress;
        return start2 + distance * animation;
    }
}

